/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.AuthorityInformationAccess;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.CertificateSource;
import org.openspcoop2.utils.certificate.ocsp.IOCSPResourceReader;
import org.openspcoop2.utils.certificate.ocsp.OCSPConfig;
import org.openspcoop2.utils.transport.http.HttpLibrary;
import org.openspcoop2.utils.transport.http.HttpLibraryConnection;

public class OCSPRequestParams {
    private X509Certificate certificate;
    private X509Certificate issuerCertificate;
    private KeyStore issuerTrustStore;
    private X509Certificate signerCertificate;
    private KeyStore signerTrustStore;
    private List<String> responderURIs;
    private KeyStore httpsTrustStore;
    private KeyStore httpsKeyStore;
    private OCSPConfig config;
    private boolean isSelfSigned;
    private boolean isCA;
    private HttpLibrary httpLibrary = HttpLibraryConnection.getDefaultLibrary();
    private KeyStore configTrustStore;
    private IOCSPResourceReader reader;

    public boolean isSelfSigned() {
        return this.isSelfSigned;
    }

    public void setSelfSigned(boolean isSelfSigned) {
        this.isSelfSigned = isSelfSigned;
    }

    public boolean isCA() {
        return this.isCA;
    }

    public void setCA(boolean isCA) {
        this.isCA = isCA;
    }

    public OCSPConfig getConfig() {
        return this.config;
    }

    public void setConfig(OCSPConfig config) {
        this.config = config;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public X509Certificate getIssuerCertificate() {
        return this.issuerCertificate;
    }

    public void setIssuerCertificate(X509Certificate issuerCertificate) {
        this.issuerCertificate = issuerCertificate;
    }

    public KeyStore getIssuerTrustStore() {
        return this.issuerTrustStore;
    }

    public void setIssuerTrustStore(KeyStore issuerTrustStore) {
        this.issuerTrustStore = issuerTrustStore;
    }

    public X509Certificate getSignerCertificate() {
        return this.signerCertificate;
    }

    public void setSignerCertificate(X509Certificate signerCertificate) {
        this.signerCertificate = signerCertificate;
    }

    public KeyStore getSignerTrustStore() {
        return this.signerTrustStore;
    }

    public void setSignerTrustStore(KeyStore signerTrustStore) {
        this.signerTrustStore = signerTrustStore;
    }

    public List<String> getResponderURIs() {
        return this.responderURIs;
    }

    public void setResponderURIs(List<String> responderURIs) {
        this.responderURIs = responderURIs;
    }

    public KeyStore getHttpsTrustStore() {
        return this.httpsTrustStore;
    }

    public void setHttpsTrustStore(KeyStore httpsTrustStore) {
        this.httpsTrustStore = httpsTrustStore;
    }

    public KeyStore getHttpsKeyStore() {
        return this.httpsKeyStore;
    }

    public void setHttpsKeyStore(KeyStore httpsKeyStore) {
        this.httpsKeyStore = httpsKeyStore;
    }

    public KeyStore getConfigTrustStore() {
        return this.configTrustStore;
    }

    public void setConfigTrustStore(KeyStore configTrustStore) {
        this.configTrustStore = configTrustStore;
    }

    public IOCSPResourceReader getReader() {
        return this.reader;
    }

    public void setReader(IOCSPResourceReader reader) {
        this.reader = reader;
    }

    public HttpLibrary getHttpLibrary() {
        return this.httpLibrary;
    }

    public void setHttpLibrary(HttpLibrary httpLibrary) {
        this.httpLibrary = httpLibrary;
    }

    public static OCSPRequestParams build(LoggerBuffer log, X509Certificate certificate, KeyStore trustStore, OCSPConfig config, IOCSPResourceReader reader) throws UtilsException {
        CertificateInfo cer = new CertificateInfo(certificate, "ocspVerifica");
        return OCSPRequestParams.build(log, cer, trustStore, config, reader);
    }

    public static OCSPRequestParams build(LoggerBuffer log, CertificateInfo certificate, KeyStore trustStore, OCSPConfig config, IOCSPResourceReader reader) throws UtilsException {
        if (config == null) {
            throw new UtilsException("Param config is null");
        }
        if (certificate == null) {
            throw new UtilsException("Param certificate is null");
        }
        OCSPRequestParams params = new OCSPRequestParams();
        params.config = config;
        params.certificate = certificate.getCertificate();
        try {
            params.isCA = certificate.isCA();
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), t);
        }
        params.isSelfSigned = certificate.isSelfSigned();
        params.configTrustStore = trustStore;
        params.reader = reader;
        if (!params.isSelfSigned) {
            reader.initConfig(config);
            if (config.getCaSource() != null && !config.getCaSource().isEmpty()) {
                for (CertificateSource s : config.getCaSource()) {
                    if (CertificateSource.CONFIG.equals(s)) {
                        if (trustStore == null) continue;
                        params.issuerCertificate = (X509Certificate)trustStore.getCertificateBySubject(params.certificate.getIssuerX500Principal());
                        if (params.issuerCertificate == null) continue;
                        params.issuerTrustStore = trustStore;
                        log.debug("OCSP IssuerCertificate: use truststore config");
                        break;
                    }
                    if (CertificateSource.ALTERNATIVE_CONFIG.equals(s)) {
                        KeyStore alternativeTrustStore = null;
                        if (config.getAlternativeTrustStoreCAPath() != null) {
                            alternativeTrustStore = reader.getIssuerAlternativeTrustStore();
                        }
                        if (alternativeTrustStore == null) continue;
                        params.issuerCertificate = (X509Certificate)alternativeTrustStore.getCertificateBySubject(params.certificate.getIssuerX500Principal());
                        if (params.issuerCertificate == null) continue;
                        params.issuerTrustStore = alternativeTrustStore;
                        log.debug("OCSP IssuerCertificate: use alternative truststore config");
                        break;
                    }
                    if (!CertificateSource.AUTHORITY_INFORMATION_ACCESS.equals(s)) continue;
                    try {
                        List<String> issuer;
                        AuthorityInformationAccess aia = certificate.getAuthorityInformationAccess();
                        if (aia == null || (issuer = aia.getCAIssuers()) == null || issuer.isEmpty()) continue;
                        ArrayList listExceptions = new ArrayList();
                        StringBuilder sbError = new StringBuilder();
                        boolean find = false;
                        for (String urlIssuer : issuer) {
                            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
                            try {
                                Certificate cer;
                                byte[] issCert;
                                reader.readExternalResource(urlIssuer, map);
                                if (map.isEmpty() || (issCert = (byte[])map.get(urlIssuer)) == null || (cer = ArchiveLoader.load(issCert)) == null || cer.getCertificate() == null) continue;
                                params.issuerCertificate = cer.getCertificate().getCertificate();
                                if (params.issuerCertificate == null) continue;
                                log.debug("OCSP IssuerCertificate: retrieved from external url '" + urlIssuer + "'");
                                find = true;
                                break;
                            }
                            catch (Exception t) {
                                String msgError = "[AuthorityInformationAccess-CAIssuer: " + urlIssuer + "] retrieve failed: " + t.getMessage();
                                if (sbError.length() > 0) {
                                    sbError.append("\n");
                                }
                                sbError.append(msgError);
                                log.debug("OCSP " + msgError, t);
                                listExceptions.add(new Exception(msgError, t));
                            }
                        }
                        if (!find) {
                            if (listExceptions.isEmpty()) continue;
                            throw new UtilsMultiException("OCSP IssuerCertificate retrieve failed: " + sbError.toString(), listExceptions.toArray(new Throwable[1]));
                        }
                        break;
                    }
                    catch (Exception t) {
                        throw new UtilsException(t.getMessage(), t);
                    }
                }
            }
            KeyStore signerTrustStore = reader.getSignerTrustStore();
            if (config.getAliasCertificateSigner() != null) {
                try {
                    params.signerCertificate = (X509Certificate)signerTrustStore.getCertificate(config.getAliasCertificateSigner());
                    if (params.signerCertificate == null) {
                        throw new UtilsException("Not found");
                    }
                    log.debug("OCSP SignerCertificate: retrieved from truststore config (alias:" + config.getAliasCertificateSigner() + ")");
                }
                catch (Exception t) {
                    throw new UtilsException("Get signer certificate failed: " + t.getMessage(), t);
                }
            } else {
                params.signerTrustStore = signerTrustStore;
                if (signerTrustStore != null) {
                    log.debug("OCSP SignerCertificate: use truststore config");
                }
            }
            params.responderURIs = new ArrayList<String>();
            if (config.getResponderUrlSource() != null && !config.getResponderUrlSource().isEmpty()) {
                for (CertificateSource s : config.getResponderUrlSource()) {
                    if (CertificateSource.CONFIG.equals(s)) {
                        throw new UtilsException("Unsupported");
                    }
                    if (CertificateSource.ALTERNATIVE_CONFIG.equals(s)) {
                        List<String> alternativeUrl = params.isCA ? config.getAlternativeResponderUrlCA() : config.getAlternativeResponderUrl();
                        if (alternativeUrl == null || alternativeUrl.isEmpty()) continue;
                        for (String url : alternativeUrl) {
                            if (params.responderURIs.contains(url)) continue;
                            params.responderURIs.add(url);
                            log.debug("OCSP ResponderURL: add alternative url '" + url + "'");
                        }
                        continue;
                    }
                    if (!CertificateSource.AUTHORITY_INFORMATION_ACCESS.equals(s)) continue;
                    try {
                        String urlOcsp;
                        List<String> ocsps;
                        AuthorityInformationAccess aia = certificate.getAuthorityInformationAccess();
                        if (aia == null || (ocsps = aia.getOCSPs()) == null || ocsps.isEmpty() || params.responderURIs.contains(urlOcsp = ocsps.get(0))) continue;
                        params.responderURIs.add(urlOcsp);
                        log.debug("OCSP ResponderURL: add external url '" + urlOcsp + "'");
                    }
                    catch (Exception t) {
                        throw new UtilsException(t.getMessage(), t);
                    }
                }
            }
            params.httpsTrustStore = reader.getHttpsTrustStore();
            params.httpsKeyStore = reader.getHttpsKeyStore();
            params.httpLibrary = config.getHttpLibrary();
        }
        return params;
    }
}

