/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

public enum OCSPResponseCode {
    SUCCESSFUL(0),
    MALFORMED_REQUEST(1),
    INTERNAL_ERROR(2),
    TRY_LATER(3),
    SIG_REQUIRED(5),
    UNAUTHORIZED(6),
    UNKNOWN(-1),
    OCSP_BUILD_REQUEST_FAILED(-2),
    OCSP_INVOKE_FAILED(-3);

    private int code;

    private OCSPResponseCode(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        switch (this.ordinal()) {
            case 0: {
                return "Successful";
            }
            case 2: {
                return "Internal error";
            }
            case 3: {
                return "Internal error, try later.";
            }
            case 4: {
                return "Invalid or missing signature";
            }
            case 5: {
                return "Unauthorized request";
            }
            case 1: {
                return "Malformed request";
            }
            case 7: {
                return "OCSP build request signed failed";
            }
            case 8: {
                return "OCSP invoke failed";
            }
        }
        return "Error";
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(int code) {
        return this.code == code;
    }

    public static final OCSPResponseCode toOCSPResponseCode(int code) {
        if (code == OCSPResponseCode.SUCCESSFUL.code) {
            return SUCCESSFUL;
        }
        if (code == OCSPResponseCode.MALFORMED_REQUEST.code) {
            return MALFORMED_REQUEST;
        }
        if (code == OCSPResponseCode.INTERNAL_ERROR.code) {
            return INTERNAL_ERROR;
        }
        if (code == OCSPResponseCode.TRY_LATER.code) {
            return TRY_LATER;
        }
        if (code == OCSPResponseCode.SIG_REQUIRED.code) {
            return SIG_REQUIRED;
        }
        if (code == OCSPResponseCode.UNAUTHORIZED.code) {
            return UNAUTHORIZED;
        }
        if (code == OCSPResponseCode.UNKNOWN.code) {
            return UNKNOWN;
        }
        if (code == OCSPResponseCode.OCSP_BUILD_REQUEST_FAILED.code) {
            return OCSP_BUILD_REQUEST_FAILED;
        }
        if (code == OCSPResponseCode.OCSP_INVOKE_FAILED.code) {
            return OCSP_INVOKE_FAILED;
        }
        return UNKNOWN;
    }
}

