/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.ocsp;

import java.math.BigInteger;
import java.security.cert.CRLReason;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateRevokedException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.cert.ocsp.jcajce.JcaCertificateID;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.openspcoop2.utils.LoggerBuffer;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.certificate.CRLDistributionPoint;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.ExtendedKeyUsage;
import org.openspcoop2.utils.certificate.Extensions;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.ocsp.CRLParams;
import org.openspcoop2.utils.certificate.ocsp.CertificateStatus;
import org.openspcoop2.utils.certificate.ocsp.OCSPRequestParams;
import org.openspcoop2.utils.certificate.ocsp.OCSPRequestSigned;
import org.openspcoop2.utils.certificate.ocsp.OCSPResponseCode;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.random.RandomGenerator;
import org.openspcoop2.utils.random.SecureRandomAlgorithm;
import org.openspcoop2.utils.transport.TransportUtils;
import org.openspcoop2.utils.transport.http.HttpRequest;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class OCSPValidator {
    private OCSPValidator() {
    }

    public static CertificateStatus check(Logger log, OCSPRequestParams params) throws UtilsException {
        LoggerBuffer lb = new LoggerBuffer();
        lb.setLogDebug(log);
        lb.setLogError(log);
        return OCSPValidator.check(lb, params, null);
    }

    public static CertificateStatus check(Logger log, OCSPRequestParams params, String crlInput) throws UtilsException {
        LoggerBuffer lb = new LoggerBuffer();
        lb.setLogDebug(log);
        lb.setLogError(log);
        return OCSPValidator.check(lb, params, crlInput);
    }

    public static CertificateStatus check(LoggerBuffer log, OCSPRequestParams params) throws UtilsException {
        return OCSPValidator.check(log, params, null);
    }

    public static CertificateStatus check(LoggerBuffer log, OCSPRequestParams params, String crlInput) throws UtilsException {
        if (params == null) {
            throw new UtilsException("Params is null");
        }
        if (params.getCertificate() == null) {
            throw new UtilsException("Certificate not provided");
        }
        if (params.getConfig() == null) {
            throw new UtilsException("OCSP config not provided");
        }
        if (params.isSelfSigned()) {
            return CertificateStatus.SELF_SIGNED();
        }
        int indexLimit = 1000;
        OCSPRequestParams req = params;
        CertificateStatus principalStatus = null;
        for (int index = 0; index < indexLimit; ++index) {
            OCSPRequestParams newReq;
            CertificateStatus status = OCSPValidator.checkEngine(log, req, crlInput);
            if (principalStatus == null) {
                principalStatus = status;
            }
            if (status.isREVOKED() || status.isEXPIRED() || status.isUNKNOWN()) {
                return status;
            }
            if (!params.getConfig().isCertificateChainVerify() || req.isSelfSigned()) {
                return principalStatus;
            }
            req = newReq = OCSPRequestParams.build(log, req.getIssuerCertificate(), params.getConfigTrustStore(), params.getConfig(), params.getReader());
        }
        throw new UtilsException("Certificate chain too big");
    }

    private static CertificateStatus checkEngine(LoggerBuffer log, OCSPRequestParams params, String crlInput) throws UtilsException {
        if (params == null) {
            throw new UtilsException("Params is null");
        }
        if (params.getCertificate() == null) {
            throw new UtilsException("Certificate not provided");
        }
        if (params.getConfig() == null) {
            throw new UtilsException("OCSP config not provided");
        }
        String prefixCert = "OCSP [certificate: " + String.valueOf(params.getCertificate().getSubjectX500Principal()) + "] ";
        CertificateInfo certificateInfo = new CertificateInfo(params.getCertificate(), "certificate");
        log.debug(prefixCert + "issuer: " + String.valueOf(params.getCertificate().getIssuerX500Principal()));
        try {
            log.debug(prefixCert + "CAissuer: " + String.valueOf(certificateInfo.getAuthorityInformationAccess() != null ? certificateInfo.getAuthorityInformationAccess().getCAIssuers() : null));
        }
        catch (Exception t) {
            log.debug(prefixCert + "CAissuer: read error: " + t.getMessage(), t);
        }
        try {
            log.debug(prefixCert + "OCSP: " + String.valueOf(certificateInfo.getAuthorityInformationAccess() != null ? certificateInfo.getAuthorityInformationAccess().getOCSPs() : null));
        }
        catch (Exception t) {
            log.debug(prefixCert + "OCSP: read error: " + t.getMessage(), t);
        }
        try {
            if (certificateInfo.getCRLDistributionPoints() != null && certificateInfo.getCRLDistributionPoints().getCRLDistributionPoints() != null && !certificateInfo.getCRLDistributionPoints().getCRLDistributionPoints().isEmpty()) {
                int indexCRL = 0;
                for (CRLDistributionPoint point : certificateInfo.getCRLDistributionPoints().getCRLDistributionPoints()) {
                    log.debug(prefixCert + "CRL-" + indexCRL + "-Issuer: " + String.valueOf(point.getCRLIssuers()));
                    log.debug(prefixCert + "CRL-" + indexCRL + ": " + String.valueOf(point.getDistributionPointNames()));
                    ++indexCRL;
                }
            } else {
                log.debug(prefixCert + "CRL: null");
            }
        }
        catch (Exception t) {
            log.debug(prefixCert + "CRL: read error: " + t.getMessage(), t);
        }
        Date date = DateManager.getDate();
        boolean isCA = false;
        try {
            isCA = certificateInfo.isCA();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        try {
            if (isCA) {
                if (params.getConfig().isCheckCAValidity()) {
                    log.debug(prefixCert + "Check validity ...");
                    certificateInfo.checkValid(date);
                }
            } else if (params.getConfig().isCheckValidity()) {
                log.debug(prefixCert + "Check validity ...");
                certificateInfo.checkValid(date);
            }
        }
        catch (CertificateExpiredException t) {
            return CertificateStatus.EXPIRED(prefixCert + t.getMessage(), certificateInfo.getNotAfter());
        }
        catch (CertificateNotYetValidException t) {
            return CertificateStatus.EXPIRED(prefixCert + t.getMessage(), certificateInfo.getNotBefore());
        }
        catch (Exception t) {
            return CertificateStatus.EXPIRED(prefixCert + t.getMessage(), certificateInfo.getNotAfter());
        }
        if (certificateInfo.isSelfSigned()) {
            log.debug(prefixCert + "Self signed");
            return CertificateStatus.SELF_SIGNED();
        }
        if (params.getIssuerCertificate() == null) {
            if (params.getConfig().isRejectsCertificateWithoutCA()) {
                throw new UtilsException(prefixCert + "IssuerCertificate not provided");
            }
            return CertificateStatus.ISSUER_NOT_FOUND();
        }
        if (params.getConfig().isCrl()) {
            return OCSPValidator.checkCRLEngine(log, params, crlInput, date, prefixCert);
        }
        if (params.getResponderURIs() == null || params.getResponderURIs().isEmpty()) {
            boolean reject = true;
            reject = isCA ? params.getConfig().isRejectsCAWithoutResponderUrl() : params.getConfig().isRejectsCertificateWithoutResponderUrl();
            if (reject) {
                throw new UtilsException(prefixCert + "At least one OCSP responder required");
            }
            if (isCA && params.getConfig().isCrlCaCheck()) {
                return OCSPValidator.checkCRLEngine(log, params, crlInput, date, prefixCert);
            }
            return CertificateStatus.OCSP_RESPONDER_NOT_FOUND();
        }
        StringBuilder sbError = new StringBuilder();
        for (String responderURI : params.getResponderURIs()) {
            BasicOCSPResp ocspResp;
            OCSPRequestSigned ocspRequest;
            UtilsException error;
            OCSPResponseCode responseCode;
            String prefix;
            block43: {
                prefix = prefixCert + "[" + responderURI + "] ";
                responseCode = null;
                error = null;
                ocspRequest = null;
                try {
                    log.debug(prefix + "Build request ...");
                    ocspRequest = OCSPValidator.buildOCSPReq(log, prefix, params);
                }
                catch (Exception t) {
                    responseCode = OCSPResponseCode.OCSP_BUILD_REQUEST_FAILED;
                    error = new UtilsException(prefixCert + "(url: " + responderURI + "): " + t.getMessage(), t);
                    log.error(prefix + "costruzione richiesta fallita: " + t.getMessage(), t);
                }
                ocspResp = null;
                if (ocspRequest != null) {
                    try {
                        log.debug(prefix + "Invoke ocsp ...");
                        OCSPResp ocspResponse = OCSPValidator.invokeOCSP(log, ocspRequest, responderURI, params);
                        log.debug(prefix + "Analyze response ...");
                        responseCode = OCSPResponseCode.toOCSPResponseCode(ocspResponse.getStatus());
                        if (!OCSPResponseCode.SUCCESSFUL.equals((Object)responseCode)) break block43;
                        if (ocspResponse.getResponseObject() == null) {
                            throw new UtilsException("OCSP response object not found");
                        }
                        if (ocspResponse.getResponseObject() instanceof BasicOCSPResp) {
                            ocspResp = (BasicOCSPResp)ocspResponse.getResponseObject();
                            break block43;
                        }
                        throw new UtilsException("Invalid or unknown OCSP response");
                    }
                    catch (Exception t) {
                        responseCode = OCSPResponseCode.OCSP_INVOKE_FAILED;
                        error = new UtilsException(prefixCert + "(url: " + responderURI + "): " + t.getMessage(), t);
                        log.error(prefix + "invocazione servizio ocsp fallita: " + t.getMessage(), t);
                    }
                }
            }
            try {
                if (OCSPResponseCode.SUCCESSFUL.equals((Object)responseCode) && ocspResp != null) {
                    return OCSPValidator.analyzeResponse(log, prefix, params, date, ocspRequest, ocspResp);
                }
                Object msgFailed = responseCode.getMessage();
                if (error != null) {
                    msgFailed = (String)msgFailed + "; " + error.getMessage();
                }
                String exceptionMessage = "OCSP response error (" + responseCode.getCode() + " - " + responseCode.name() + "): " + (String)msgFailed;
                if (params.getConfig().getResponderBreakStatus() == null || params.getConfig().getResponderBreakStatus().isEmpty() || params.getConfig().getResponderBreakStatus().contains((Object)responseCode)) {
                    throw new UtilsException(exceptionMessage);
                }
                if (sbError.length() > 0) {
                    sbError.append("\n");
                }
                sbError.append("[").append(responderURI).append("] ");
                sbError.append(exceptionMessage);
            }
            catch (Exception t) {
                log.error(prefix + "analisi fallita: " + t.getMessage(), t);
                throw new UtilsException(prefixCert + "OCSP analysis failed (url: " + responderURI + "): " + t.getMessage(), t);
            }
        }
        throw new UtilsException("OCSP analysis failed.\n" + sbError.toString());
    }

    private static OCSPRequestSigned buildOCSPReq(LoggerBuffer log, String prefix, OCSPRequestParams params) throws UtilsException {
        try {
            OCSPReq ocspRequest;
            OCSPRequestSigned ocspRequestSigned = new OCSPRequestSigned();
            DigestCalculatorProvider digestCalculatorProvider = new JcaDigestCalculatorProviderBuilder().build();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(CertificateID.HASH_SHA1);
            JcaCertificateID certificateID = new JcaCertificateID(digestCalculator, params.getIssuerCertificate(), params.getCertificate().getSerialNumber());
            SecureRandomAlgorithm secureRandomAlgorithm = params.getConfig().getSecureRandomAlgorithm();
            if (secureRandomAlgorithm == null) {
                secureRandomAlgorithm = SecureRandomAlgorithm.SHA1PRNG;
            }
            RandomGenerator randomGenerator = new RandomGenerator(true, secureRandomAlgorithm);
            BigInteger nounce = BigInteger.valueOf(Math.abs(randomGenerator.nextInt()));
            DEROctetString derNounceString = new DEROctetString(nounce.toByteArray());
            Extension nounceExtension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)derNounceString);
            org.bouncycastle.asn1.x509.Extensions extensions = new org.bouncycastle.asn1.x509.Extensions(nounceExtension);
            OCSPReqBuilder builder = new OCSPReqBuilder();
            if (params.getConfig().isNonce()) {
                log.debug(prefix + "Build nonce value '" + String.valueOf(derNounceString) + "' ...");
                builder.addRequest((CertificateID)certificateID, extensions);
                builder.setRequestExtensions(extensions);
            } else {
                builder.addRequest((CertificateID)certificateID);
            }
            ocspRequestSigned.request = ocspRequest = builder.build();
            ocspRequestSigned.certificateID = certificateID;
            ocspRequestSigned.nounce = nounce;
            return ocspRequestSigned;
        }
        catch (Exception t) {
            throw new UtilsException("Build OCSP Request failed: " + t.getMessage(), t);
        }
    }

    private static OCSPResp invokeOCSP(LoggerBuffer log, OCSPRequestSigned ocspRequest, String responderURI, OCSPRequestParams params) throws UtilsException {
        try {
            if (!responderURI.trim().startsWith("http") && !responderURI.trim().startsWith("file")) {
                throw new UtilsException("Unsupported protocol");
            }
            HttpRequest req = new HttpRequest();
            req.setMethod(HttpRequestMethod.POST);
            req.setContentType("application/ocsp-request");
            req.setContent(ocspRequest.request.getEncoded());
            req.setHttpLibrary(params.getHttpLibrary());
            responderURI = responderURI.trim();
            if (params.getConfig().getForwardProxyUrl() != null && StringUtils.isNotEmpty((CharSequence)params.getConfig().getForwardProxyUrl())) {
                String remoteLocation;
                String forwardProxyUrl = params.getConfig().getForwardProxyUrl();
                String string = remoteLocation = params.getConfig().isForwardProxyBase64() ? Base64Utilities.encodeAsString(responderURI.getBytes()) : responderURI;
                if (params.getConfig().getForwardProxyHeader() != null && StringUtils.isNotEmpty((CharSequence)params.getConfig().getForwardProxyHeader())) {
                    req.addHeader(params.getConfig().getForwardProxyHeader(), remoteLocation);
                } else if (params.getConfig().getForwardProxyQueryParameter() != null && StringUtils.isNotEmpty((CharSequence)params.getConfig().getForwardProxyQueryParameter())) {
                    HashMap<String, List<String>> queryParameters = new HashMap<String, List<String>>();
                    TransportUtils.addParameter(queryParameters, params.getConfig().getForwardProxyQueryParameter(), remoteLocation);
                    forwardProxyUrl = TransportUtils.buildUrlWithParameters(queryParameters, forwardProxyUrl, false, log.getLogDebug());
                } else {
                    throw new UtilsException("Forward Proxy configuration error: header and query parameter not found");
                }
                req.setUrl(forwardProxyUrl);
            } else {
                req.setUrl(responderURI);
            }
            if (req.getUrl().startsWith("https")) {
                req.setHostnameVerifier(params.getConfig().isExternalResourcesHostnameVerifier());
                req.setTrustAllCerts(params.getConfig().isExternalResourcesTrustAllCerts());
                if (params.getHttpsTrustStore() != null) {
                    req.setTrustStore(params.getHttpsTrustStore().getKeystore());
                }
                if (params.getHttpsKeyStore() != null) {
                    req.setKeyStore(params.getHttpsKeyStore().getKeystore());
                    req.setKeyAlias(params.getConfig().getExternalResourcesKeyAlias());
                    req.setKeyPassword(params.getConfig().getExternalResourcesKeyPassword());
                }
            }
            req.setConnectTimeout(params.getConfig().getConnectTimeout());
            req.setReadTimeout(params.getConfig().getReadTimeout());
            HttpResponse res = HttpUtilities.httpInvoke(req);
            List<Integer> returnCodeValid = params.getConfig().getResponderReturnCodeOk();
            if (returnCodeValid == null) {
                returnCodeValid = new ArrayList<Integer>();
            }
            if (returnCodeValid.isEmpty()) {
                returnCodeValid.add(200);
            }
            boolean isValid = false;
            for (Integer rt : returnCodeValid) {
                if (rt == null || rt.intValue() != res.getResultHTTPOperation()) continue;
                isValid = true;
                break;
            }
            byte[] response = res.getContent();
            if (isValid) {
                if (response != null && response.length > 0) {
                    return new OCSPResp(res.getContent());
                }
                throw new UtilsException("OCSP empty response (http code: " + res.getResultHTTPOperation() + ")");
            }
            Object error = null;
            if (response.length <= 2048 && (error = Utilities.convertToPrintableText(response, 2048)) != null && ((String)error).contains("Visualizzazione non riuscita")) {
                error = null;
            }
            error = error == null ? "" : ": " + (String)error;
            throw new UtilsException("OCSP response error (http code: " + res.getResultHTTPOperation() + ")" + (String)error);
        }
        catch (Exception t) {
            throw new UtilsException("Invoke OCSP '" + responderURI + "' failed: " + t.getMessage(), t);
        }
    }

    private static CertificateStatus analyzeResponse(LoggerBuffer log, String prefix, OCSPRequestParams params, Date date, OCSPRequestSigned requestSigned, BasicOCSPResp basicOcspResponse) throws UtilsException {
        OCSPValidator.verifyResponse(log, prefix, params, date, requestSigned, basicOcspResponse);
        SingleResp expectedResponseForCertificate = null;
        for (SingleResp resp : basicOcspResponse.getResponses()) {
            if (!OCSPValidator.isEquals(requestSigned.certificateID, resp.getCertID())) continue;
            expectedResponseForCertificate = resp;
            break;
        }
        if (expectedResponseForCertificate == null) {
            throw new UtilsException("OSPC Response does not contain info for certificate supplied in the OCSP request");
        }
        org.bouncycastle.cert.ocsp.CertificateStatus certStatus = expectedResponseForCertificate.getCertStatus();
        if (certStatus == org.bouncycastle.cert.ocsp.CertificateStatus.GOOD) {
            return CertificateStatus.GOOD();
        }
        if (certStatus instanceof RevokedStatus) {
            RevokedStatus revoked = (RevokedStatus)certStatus;
            CRLReason reason = null;
            if (revoked.hasRevocationReason()) {
                reason = CRLReason.values()[revoked.getRevocationReason()];
            }
            return CertificateStatus.REVOKED(reason, revoked.getRevocationTime());
        }
        if (certStatus instanceof UnknownStatus) {
            return CertificateStatus.UNKNOWN();
        }
        throw new UtilsException("OSPC Response contain unknown revocation status (" + String.valueOf(certStatus) + ")");
    }

    private static boolean isEquals(JcaCertificateID ocspRequestCertificateId, CertificateID ocspResponseCertificateId) {
        if (ocspRequestCertificateId == null || ocspResponseCertificateId == null) {
            return false;
        }
        if (ocspRequestCertificateId == ocspResponseCertificateId) {
            return true;
        }
        boolean serialNumberEquals = ocspRequestCertificateId.getSerialNumber() != null && ocspResponseCertificateId.getSerialNumber() != null && ocspRequestCertificateId.getSerialNumber().equals(ocspResponseCertificateId.getSerialNumber());
        boolean nameHashEquals = ocspRequestCertificateId.getIssuerNameHash() != null && ocspResponseCertificateId.getIssuerNameHash() != null && Arrays.equals(ocspRequestCertificateId.getIssuerNameHash(), ocspResponseCertificateId.getIssuerNameHash());
        boolean keyHashEquals = ocspRequestCertificateId.getIssuerKeyHash() != null && ocspResponseCertificateId.getIssuerKeyHash() != null && Arrays.equals(ocspRequestCertificateId.getIssuerKeyHash(), ocspResponseCertificateId.getIssuerKeyHash());
        return serialNumberEquals && nameHashEquals && keyHashEquals;
    }

    private static void verifyResponse(LoggerBuffer log, String prefix, OCSPRequestParams params, Date date, OCSPRequestSigned requestSigned, BasicOCSPResp basicOcspResponse) throws UtilsException {
        ArrayList<X509CertificateHolder> certs = new ArrayList<X509CertificateHolder>(Arrays.asList(basicOcspResponse.getCerts()));
        try {
            X509CertificateHolder[] ospcCerts = basicOcspResponse.getCerts();
            if (ospcCerts != null && ospcCerts.length > 0) {
                certs.addAll(Arrays.asList(ospcCerts));
            }
            certs.add((X509CertificateHolder)new JcaX509CertificateHolder(params.getIssuerCertificate()));
            if (params.getSignerCertificate() != null) {
                certs.add((X509CertificateHolder)new JcaX509CertificateHolder(params.getSignerCertificate()));
            }
        }
        catch (Exception e) {
            throw new UtilsException("OCSP Response signature unverifiable; read certs failed: " + e.getMessage(), e);
        }
        X509Certificate signingCert = OCSPValidator.readSigningCertByResponderId(log, certs, basicOcspResponse);
        if (signingCert == null) {
            throw new UtilsException("OCSP Response signature unverifiable: signing cert not found");
        }
        OCSPValidator.verifySigningCert(log, prefix, signingCert, params, date);
        try {
            log.debug(prefix + "Verify OCSP Response ...");
            JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();
            builder.setProvider("BC");
            ContentVerifierProvider contentVerifier = builder.build(signingCert.getPublicKey());
            boolean valid = basicOcspResponse.isSignatureValid(contentVerifier);
            if (!valid) {
                throw new UtilsException("invalid signature");
            }
        }
        catch (Exception t) {
            throw new UtilsException("Verifying OCSP Response's signature failed: " + t.getMessage(), t);
        }
        OCSPValidator.verifyNonceOrDates(log, prefix, params, requestSigned, basicOcspResponse, date);
    }

    private static X509Certificate readSigningCertByResponderId(LoggerBuffer log, List<X509CertificateHolder> certs, BasicOCSPResp basicOcspResponse) throws UtilsException {
        if (basicOcspResponse.getResponderId() == null) {
            throw new UtilsException("OSPC Response does not contain responder id");
        }
        ResponderID responderId = basicOcspResponse.getResponderId().toASN1Primitive();
        if (responderId == null) {
            throw new UtilsException("OSPC Response does not contain responder id (asn1)");
        }
        ArrayList<Exception> listThrowable = new ArrayList<Exception>();
        if (certs != null && !certs.isEmpty()) {
            X500Name responderName = responderId.getName();
            byte[] responderKey = responderId.getKeyHash();
            if (responderName != null) {
                for (X509CertificateHolder certHolder : certs) {
                    try {
                        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
                        converter.setProvider("BC");
                        X509Certificate certCheck = converter.getCertificate(certHolder);
                        X500Name nameCheck = new X500Name(certCheck.getSubjectX500Principal().getName());
                        if (!responderName.equals((Object)nameCheck)) continue;
                        return certCheck;
                    }
                    catch (Exception t) {
                        log.debug("check (responderName) failed: " + t.getMessage(), t);
                        listThrowable.add(t);
                    }
                }
            } else if (responderKey != null) {
                SubjectKeyIdentifier responderSubjectKey = new SubjectKeyIdentifier(responderKey);
                for (X509CertificateHolder certHolder : certs) {
                    try {
                        JcaX509CertificateConverter converter = new JcaX509CertificateConverter();
                        converter.setProvider("BC");
                        X509Certificate certCheck = converter.getCertificate(certHolder);
                        SubjectKeyIdentifier subjectKeyIdentifierCheck = null;
                        if (certHolder.getExtensions() != null) {
                            subjectKeyIdentifierCheck = SubjectKeyIdentifier.fromExtensions((org.bouncycastle.asn1.x509.Extensions)certHolder.getExtensions());
                        }
                        if (subjectKeyIdentifierCheck != null && responderSubjectKey.equals((Object)subjectKeyIdentifierCheck)) {
                            return certCheck;
                        }
                        subjectKeyIdentifierCheck = new JcaX509ExtensionUtils().createSubjectKeyIdentifier(certCheck.getPublicKey());
                        if (!responderSubjectKey.equals((Object)subjectKeyIdentifierCheck)) continue;
                        return certCheck;
                    }
                    catch (Exception t) {
                        log.debug("check (responderKey) failed: " + t.getMessage(), t);
                        listThrowable.add(t);
                    }
                }
            }
        }
        if (!listThrowable.isEmpty()) {
            if (listThrowable.size() == 1) {
                Throwable t = (Throwable)listThrowable.get(0);
                throw new UtilsException("OCSP Response signature unverifiable: signing cert not found; " + t.getMessage(), t);
            }
            UtilsMultiException multi = new UtilsMultiException("OCSP Response signature unverifiable: signing cert not found; multiple exception", listThrowable.toArray(new Throwable[1]));
            throw new UtilsException(multi.getMessage(), multi);
        }
        return null;
    }

    private static void verifySigningCert(LoggerBuffer log, String prefix, X509Certificate signingCert, OCSPRequestParams params, Date date) throws UtilsException {
        if (signingCert == null) {
            throw new UtilsException("Signing certificate not found");
        }
        if (signingCert.equals(params.getIssuerCertificate())) {
            log.debug(prefix + "[Case 1] OCSP response is signed by the certificate's Issuing CA");
        } else if (params.getSignerCertificate() != null && signingCert.equals(params.getSignerCertificate())) {
            log.debug(prefix + "[Case 3] OCSP response is signed by an authorized responder certificate manually configured: " + String.valueOf(signingCert.getSubjectX500Principal()));
        } else {
            boolean responderCertificateManuallyAuthorized = false;
            X509Certificate differentIssuerResponderCertificateCA = null;
            KeyStore differentIssuerResponderCertificateTrustStore = null;
            if (!signingCert.getIssuerX500Principal().equals(params.getIssuerCertificate().getSubjectX500Principal())) {
                log.debug(prefix + "[Case 3] OCSP response is signed by an responder certificate readed in ocsp response (different CA '" + String.valueOf(signingCert.getIssuerX500Principal()) + "'): " + String.valueOf(signingCert.getSubjectX500Principal()));
                if (params.getSignerTrustStore() != null) {
                    X509Certificate tmp = (X509Certificate)params.getSignerTrustStore().getCertificateBySubject(signingCert.getSubjectX500Principal());
                    if (tmp != null && tmp.equals(signingCert)) {
                        responderCertificateManuallyAuthorized = true;
                    } else {
                        differentIssuerResponderCertificateCA = (X509Certificate)params.getSignerTrustStore().getCertificateBySubject(signingCert.getIssuerX500Principal());
                    }
                    differentIssuerResponderCertificateTrustStore = params.getSignerTrustStore();
                }
                if (!responderCertificateManuallyAuthorized && differentIssuerResponderCertificateCA == null) {
                    throw new UtilsException("Signing certificate is not authorized to sign OCSP responses: unauthorized different issuer certificate '" + String.valueOf(signingCert.getIssuerX500Principal()) + "'");
                }
            } else {
                log.debug(prefix + "[Case 2] OCSP response is signed by an responder certificate readed in ocsp response (same CA): " + String.valueOf(signingCert.getSubjectX500Principal()));
            }
            CertificateInfo certificateInfo = new CertificateInfo(signingCert, "signingCert");
            List<ExtendedKeyUsage> requiredExtendedKeyUsages = params.getConfig().getExtendedKeyUsageRequired();
            if (requiredExtendedKeyUsages != null && !requiredExtendedKeyUsages.isEmpty()) {
                for (ExtendedKeyUsage extendedKeyUsage : requiredExtendedKeyUsages) {
                    boolean hasExtendedKeyUsage = false;
                    try {
                        log.debug(prefix + "Check ExtendedKeyUsage '" + String.valueOf((Object)extendedKeyUsage) + "' ...");
                        hasExtendedKeyUsage = certificateInfo.hasExtendedKeyUsage(extendedKeyUsage);
                    }
                    catch (Exception t) {
                        throw new UtilsException("Signing certificate not valid for signing OCSP responses: extended key usage '" + String.valueOf((Object)extendedKeyUsage) + "' not found; " + t.getMessage(), t);
                    }
                    if (hasExtendedKeyUsage) continue;
                    throw new UtilsException("Signing certificate not valid for signing OCSP responses: extended key usage '" + String.valueOf((Object)extendedKeyUsage) + "' not found");
                }
            } else {
                log.debug(prefix + "Check ExtendedKeyUsage disable");
            }
            Extensions exts = null;
            try {
                exts = certificateInfo.getExtensions();
            }
            catch (Exception t) {
                log.debug("Extension read failed: " + t.getMessage(), t);
            }
            boolean ocspNoCheck = exts != null && exts.hasExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nocheck);
            log.debug(prefix + "ocsp_nocheck:" + ocspNoCheck);
            CRLParams crlParams = null;
            if (!ocspNoCheck && params.getConfig().isCrlSigningCertCheck()) {
                log.debug(prefix + "(SigningCert:" + String.valueOf(signingCert.getSubjectX500Principal()) + ") Build CRL params...");
                KeyStore trustStoreConfig = differentIssuerResponderCertificateTrustStore != null ? differentIssuerResponderCertificateTrustStore : params.getIssuerTrustStore();
                try {
                    crlParams = CRLParams.build(log, signingCert, null, trustStoreConfig, params.getConfig(), params.getReader());
                }
                catch (Exception t) {
                    throw new UtilsException(t.getMessage(), t);
                }
            }
            if (crlParams == null || crlParams.getCrlCertstore() == null) {
                try {
                    log.debug(prefix + " (SigningCert:" + String.valueOf(signingCert.getSubjectX500Principal()) + ") Check valid...");
                    certificateInfo.checkValid(date);
                }
                catch (CertificateNotYetValidException t) {
                    throw new UtilsException("Signing certificate not yet valid: " + t.getMessage(), t);
                }
                catch (CertificateExpiredException t) {
                    throw new UtilsException("Signing certificate expired: " + t.getMessage(), t);
                }
                catch (Exception t) {
                    throw new UtilsException("Signing certificate not valid: " + t.getMessage(), t);
                }
            }
            String ca = "n.d.";
            try {
                if (!responderCertificateManuallyAuthorized) {
                    if (differentIssuerResponderCertificateCA != null) {
                        if (differentIssuerResponderCertificateCA.getSubjectX500Principal() != null) {
                            ca = differentIssuerResponderCertificateCA.getSubjectX500Principal().toString();
                        }
                        log.debug(prefix + "(SigningCert:" + String.valueOf(signingCert.getSubjectX500Principal()) + ") verify against ca '" + ca + "'...");
                        certificateInfo.verify(differentIssuerResponderCertificateCA);
                    } else {
                        if (params.getIssuerCertificate().getSubjectX500Principal() != null) {
                            ca = params.getIssuerCertificate().getSubjectX500Principal().toString();
                        }
                        log.debug(prefix + "(SigningCert:" + String.valueOf(signingCert.getSubjectX500Principal()) + ") verify against ca '" + ca + "'...");
                        certificateInfo.verify(params.getIssuerCertificate());
                    }
                }
            }
            catch (Exception t) {
                throw new UtilsException("Signing certificate not valid (CA: " + ca + "): " + t.getMessage(), t);
            }
            if (crlParams != null && crlParams.getCrlCertstore() != null) {
                try {
                    log.debug(prefix + "(SigningCert:" + String.valueOf(signingCert.getSubjectX500Principal()) + ") CRL check...");
                    certificateInfo.checkValid(crlParams.getCrlCertstore(), crlParams.getCrlTrustStore(), date);
                }
                catch (Exception t) {
                    throw new UtilsException("Signing certificate not valid (CRL): " + t.getMessage(), t);
                }
            }
        }
    }

    private static void verifyNonceOrDates(LoggerBuffer log, String prefix, OCSPRequestParams params, OCSPRequestSigned requestSigned, BasicOCSPResp basicOcspResponse, Date date) throws UtilsException {
        byte[] requestNonce = requestSigned.nounce != null ? requestSigned.nounce.toByteArray() : null;
        Extension responseNonce = basicOcspResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (responseNonce != null && requestNonce != null) {
            log.debug(prefix + "Verify nonce request-response...");
            if (!Arrays.equals(requestNonce, responseNonce.getExtnValue().getOctets())) {
                throw new UtilsException("OCSP Response not valid: nonces do not match");
            }
        } else {
            log.debug(prefix + "Verify nonce dates...");
            long current = date.getTime();
            int toleranceMilliseconds = params.getConfig().getResponseCheckDateToleranceMilliseconds();
            Date rightInterval = new Date(current + (long)toleranceMilliseconds);
            Date leftInterval = new Date(current - (long)toleranceMilliseconds);
            SingleResp[] resp = basicOcspResponse.getResponses();
            if (resp != null && resp.length > 0) {
                for (SingleResp singleResp : resp) {
                    Date dateCheck;
                    if (rightInterval.before(singleResp.getThisUpdate())) {
                        throw new UtilsException("OCSP Response is unreliable: this update time '" + DateUtils.getSimpleDateFormatMs().format(singleResp.getThisUpdate()) + "' is later than the local system time");
                    }
                    Date date2 = dateCheck = singleResp.getNextUpdate() != null ? singleResp.getNextUpdate() : singleResp.getThisUpdate();
                    if (!leftInterval.after(dateCheck)) continue;
                    throw new UtilsException("OCSP Response is unreliable: next update time '" + DateUtils.getSimpleDateFormatMs().format(dateCheck) + "' is earlier than the local system time");
                }
            }
        }
    }

    private static CertificateStatus checkCRLEngine(LoggerBuffer log, OCSPRequestParams params, String crlInput, Date date, String prefix) throws UtilsException {
        log.debug(prefix + "Build CRL request ...");
        CRLParams crlParams = null;
        try {
            crlParams = CRLParams.build(log, params.getCertificate(), crlInput, params.getIssuerTrustStore(), params.getConfig(), params.getReader());
        }
        catch (Exception t) {
            throw new UtilsException(t.getMessage(), t);
        }
        CertificateInfo certificateInfo = new CertificateInfo(params.getCertificate(), "certificateCrlCheck");
        if (!certificateInfo.isSelfSigned()) {
            log.debug(prefix + "Verify against CA ...");
            String ca = "n.d.";
            try {
                if (params.getIssuerCertificate().getSubjectX500Principal() != null) {
                    ca = params.getIssuerCertificate().getSubjectX500Principal().toString();
                }
                certificateInfo.verify(params.getIssuerCertificate());
            }
            catch (Exception t) {
                CertificateStatus cs = CertificateStatus.REVOKED(CRLReason.UNSPECIFIED, null);
                String eMessage = t.getMessage();
                String msgError = "Certificate not valid (CA: " + ca + "): " + eMessage;
                log.error(msgError, t);
                cs.setDetails(msgError);
                return cs;
            }
        } else {
            log.debug(prefix + "Certificate self-signed");
        }
        CertificateStatus status = CertificateStatus.GOOD();
        try {
            if (crlParams.getCrlCertstore() != null) {
                log.debug(prefix + "Verify CRL ...");
                certificateInfo.checkValid(crlParams.getCrlCertstore(), crlParams.getCrlTrustStore(), date);
            } else {
                log.debug(prefix + "CRL undefined");
                status = CertificateStatus.CRL_NOT_FOUND();
            }
        }
        catch (Exception t) {
            CertificateRevokedException cre;
            Throwable inner;
            CertificateStatus cs = CertificateStatus.REVOKED(CRLReason.UNSPECIFIED, null);
            String eMessage = t.getMessage();
            if (Utilities.existsInnerException((Throwable)t, CertificateExpiredException.class)) {
                inner = Utilities.getInnerException((Throwable)t, CertificateExpiredException.class);
                if (inner != null && inner.getMessage() != null) {
                    eMessage = inner.getMessage();
                }
            } else if (Utilities.existsInnerException((Throwable)t, CertificateRevokedException.class) && (inner = Utilities.getInnerException((Throwable)t, CertificateRevokedException.class)) instanceof CertificateRevokedException && (cre = (CertificateRevokedException)inner).getRevocationReason() != null) {
                cs = CertificateStatus.REVOKED(cre.getRevocationReason(), cre.getRevocationDate());
            }
            String msgError = "Certificate not valid (CRL): " + eMessage;
            log.error(msgError, t);
            cs.setDetails(msgError);
            return cs;
        }
        return status;
    }
}

