/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.remote;

import java.io.Serializable;

public enum RemoteKeyType implements Serializable
{
    PUBLIC_KEY("public", "Public Key"),
    JWK("jwk", "JWK (Json Web Key)"),
    X509("x509", "X.509 Certificate");

    private final String nome;
    private final String label;

    private RemoteKeyType(String nome, String label) {
        this.nome = nome;
        this.label = label;
    }

    public String getNome() {
        return this.nome;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.nome;
    }

    public String toString() {
        return this.nome;
    }

    public static RemoteKeyType toEnumFromName(String name) {
        RemoteKeyType[] tipi = RemoteKeyType.values();
        for (int i = 0; i < tipi.length; ++i) {
            RemoteKeyType tipo = tipi[i];
            if (!tipo.getNome().equals(name)) continue;
            return tipo;
        }
        return null;
    }

    public static RemoteKeyType toEnumFromLabel(String label) {
        RemoteKeyType[] tipi = RemoteKeyType.values();
        for (int i = 0; i < tipi.length; ++i) {
            RemoteKeyType tipo = tipi[i];
            if (!tipo.getLabel().equals(label)) continue;
            return tipo;
        }
        return null;
    }
}

