/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.certificate.test;

import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsMultiException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateDecodeConfig;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;

public class CertificateReaderTest {
    public static void main(String[] args) throws Exception {
        CertificateReaderTest.test();
    }

    public static void test() throws Exception {
        int index;
        UtilsMultiException e;
        byte[] PEM = Utilities.getAsByteArray(CertificateReaderTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/Soggetto1.pem"));
        System.out.println("PEM ...");
        Certificate certDecoded = ArchiveLoader.load(PEM);
        System.out.println("PEM: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        byte[] DER = Utilities.getAsByteArray(CertificateReaderTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/Soggetto1.der"));
        System.out.println("DER ...");
        certDecoded = ArchiveLoader.load(DER);
        System.out.println("DER: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        Object cert = "-----BEGIN CERTIFICATE-----\nMIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEW\nDWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsG\nA1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRl\nc3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkx\nNDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQG\nEwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9w\nZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX+rOc+zUHpOSt\n8JXndItBQVOfNGZ8i+qFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3\nlv2hX0qLlq0h+IdhV7jqTxOOVfwMiYMaI9IRiRs26Af/1RMMH3Q3KhiM4blW6q/J\nKkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZ\nGVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7Yknm\nzK86buXUG6n/nJruzAM1Wp8Tqc4dN9XX7F/MAszxOLxr4Acr4jbHExsTSPD1yEo9\n9yRr/onMnZurvTMTwzcJgpRjheE=\n-----END CERTIFICATE-----";
        CertificateDecodeConfig config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        System.out.println("PEM (asString) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM (asString): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "MIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEW\nDWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsG\nA1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRl\nc3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkx\nNDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQG\nEwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9w\nZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX+rOc+zUHpOSt\n8JXndItBQVOfNGZ8i+qFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3\nlv2hX0qLlq0h+IdhV7jqTxOOVfwMiYMaI9IRiRs26Af/1RMMH3Q3KhiM4blW6q/J\nKkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZ\nGVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7Yknm\nzK86buXUG6n/nJruzAM1Wp8Tqc4dN9XX7F/MAszxOLxr4Acr4jbHExsTSPD1yEo9\n9yRr/onMnZurvTMTwzcJgpRjheE=";
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setEnrichPEMBeginEnd(true);
        System.out.println("PEM senza BEGIN e END ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM senza BEGIN e END: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "-----BEGIN CERTIFICATE----- MIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEW DWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsG A1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRl c3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkx NDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQG EwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9w ZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEw gZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX+rOc+zUHpOSt 8JXndItBQVOfNGZ8i+qFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3 lv2hX0qLlq0h+IdhV7jqTxOOVfwMiYMaI9IRiRs26Af/1RMMH3Q3KhiM4blW6q/J KkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZ GVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7Yknm zK86buXUG6n/nJruzAM1Wp8Tqc4dN9XX7F/MAszxOLxr4Acr4jbHExsTSPD1yEo9 9yRr/onMnZurvTMTwzcJgpRjheE= -----END CERTIFICATE-----";
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setReplace(true);
        config.setReplaceSource(" ");
        config.setReplaceDest("\n");
        System.out.println("PEM (asString) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM (asString): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "-----BEGIN%20CERTIFICATE-----%0AMIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEW%0ADWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsG%0AA1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRl%0Ac3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkx%0ANDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQG%0AEwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9w%0AZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEw%0AgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX%2BrOc%2BzUHpOSt%0A8JXndItBQVOfNGZ8i%2BqFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3%0Alv2hX0qLlq0h%2BIdhV7jqTxOOVfwMiYMaI9IRiRs26Af%2F1RMMH3Q3KhiM4blW6q%2FJ%0AKkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZ%0AGVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7Yknm%0AzK86buXUG6n%2FnJruzAM1Wp8Tqc4dN9XX7F%2FMAszxOLxr4Acr4jbHExsTSPD1yEo9%0A9yRr%2FonMnZurvTMTwzcJgpRjheE%3D%0A-----END%20CERTIFICATE-----";
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(true);
        System.out.println("PEM + URL Encoded ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + URL Encoded: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("PEM + URL Encoded (config UrlDecode_or_base64Decode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + URL Encoded (config UrlDecode_or_base64Decode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("PEM + URL Encoded (config UrlDecode_or_base64Decode_or_hexDecode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + URL Encoded (config UrlDecode_or_base64Decode_or_hexDecode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = ((String)cert).replaceFirst("%20", "%%%");
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("PEM + URL Encoded (corrupted) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("PEM + URL Encoded (corrupted): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("PEM + URL Encoded (corrupted) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("PEM + URL Encoded (corrupted): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
        cert = "MIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEW%0ADWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsG%0AA1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRl%0Ac3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkx%0ANDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQG%0AEwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9w%0AZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEw%0AgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX%2BrOc%2BzUHpOSt%0A8JXndItBQVOfNGZ8i%2BqFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3%0Alv2hX0qLlq0h%2BIdhV7jqTxOOVfwMiYMaI9IRiRs26Af%2F1RMMH3Q3KhiM4blW6q%2FJ%0AKkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZ%0AGVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7Yknm%0AzK86buXUG6n%2FnJruzAM1Wp8Tqc4dN9XX7F%2FMAszxOLxr4Acr4jbHExsTSPD1yEo9%0A9yRr%2FonMnZurvTMTwzcJgpRjheE";
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setEnrichPEMBeginEnd(true);
        config.setUrlDecode(true);
        System.out.println("PEM + URL Encoded senza BEGIN e END ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + URL Encoded senza BEGIN e END: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "MIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEWDWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsGA1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRlc3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkxNDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQGEwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9wZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX+rOc+zUHpOSt8JXndItBQVOfNGZ8i+qFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3lv2hX0qLlq0h+IdhV7jqTxOOVfwMiYMaI9IRiRs26Af/1RMMH3Q3KhiM4blW6q/JKkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZGVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7YknmzK86buXUG6n/nJruzAM1Wp8Tqc4dN9XX7F/MAszxOLxr4Acr4jbHExsTSPD1yEo99yRr/onMnZurvTMTwzcJgpRjheE=";
        config = new CertificateDecodeConfig();
        config.setBase64Decode(true);
        config.setUrlDecode(false);
        System.out.println("DER + BASE64 ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("DER + BASE64: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("DER + BASE64 (config UrlDecode_or_base64Decode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("DER + BASE64 (config UrlDecode_or_base64Decode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("DER + BASE64 (config UrlDecode_or_base64Decode_or_hexDecode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("DER + BASE64 (config UrlDecode_or_base64Decode_or_hexDecode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "-----BEGIN CERTIFICATE-----\nMIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEW\nDWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsG\nA1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRl\nc3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkx\nNDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQG\nEwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9w\nZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX+rOc+zUHpOSt\n8JXndItBQVOfNGZ8i+qFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3\nlv2hX0qLlq0h+IdhV7jqTxOOVfwMiYMaI9IRiRs26Af/1RMMH3Q3KhiM4blW6q/J\nKkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZ\nGVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7Yknm\nzK86buXUG6n/nJruzAM1Wp8Tqc4dN9XX7F/MAszxOLxr4Acr4jbHExsTSPD1yEo9\n9yRr/onMnZurvTMTwzcJgpRjheE=\n-----END CERTIFICATE-----";
        cert = Base64Utilities.encodeAsString(((String)cert).getBytes());
        config = new CertificateDecodeConfig();
        config.setBase64Decode(true);
        config.setUrlDecode(false);
        System.out.println("PEM + BASE64 ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + BASE64: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("PEM + BASE64 (config UrlDecode_or_base64Decode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + BASE64 (config UrlDecode_or_base64Decode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("PEM + BASE64 (config UrlDecode_or_base64Decode_or_hexDecode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + BASE64 (config UrlDecode_or_base64Decode_or_hexDecode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "ALTRICARATTERICORROMPERE" + (String)cert;
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("PEM + BASE64 (corrupted) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("PEM + BASE64 (corrupted): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("PEM + BASE64 (corrupted) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("PEM + BASE64 (corrupted): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
        cert = HexBinaryUtilities.encodeAsString(DER);
        System.out.println("HEX cert: " + (String)cert);
        config = new CertificateDecodeConfig();
        config.setHexDecode(true);
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        System.out.println("DER + HEX ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("DER + HEX: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("DER + HEX (config UrlDecode_or_base64Decode) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("DER + HEX (config UrlDecode_or_base64Decode): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("DER + HEX (config UrlDecode_or_base64Decode_or_hexDecode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("DER + HEX (config UrlDecode_or_base64Decode_or_hexDecode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "-----BEGIN CERTIFICATE-----\nMIICgDCCAekCBE6Vnp0wDQYJKoZIhvcNAQEFBQAwgYYxHDAaBgkqhkiG9w0BCQEW\nDWFwb2xpQGxpbmsuaXQxCzAJBgNVBAYTAklUMQ4wDAYDVQQIDAVJdGFseTENMAsG\nA1UEBwwEUGlzYTEXMBUGA1UECgwOb3BlbnNwY29vcC5vcmcxDTALBgNVBAsMBHRl\nc3QxEjAQBgNVBAMMCVNvZ2dldHRvMTAeFw0xMTEwMTIxNDA1MTdaFw0yMTEwMDkx\nNDA1MTdaMIGGMRwwGgYJKoZIhvcNAQkBFg1hcG9saUBsaW5rLml0MQswCQYDVQQG\nEwJJVDEOMAwGA1UECAwFSXRhbHkxDTALBgNVBAcMBFBpc2ExFzAVBgNVBAoMDm9w\nZW5zcGNvb3Aub3JnMQ0wCwYDVQQLDAR0ZXN0MRIwEAYDVQQDDAlTb2dnZXR0bzEw\ngZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAI7Zy01BmPwitnoX+rOc+zUHpOSt\n8JXndItBQVOfNGZ8i+qFV564eLYPHOS5pyNlG0xpivNYokO12CAANrnv4lkqG7W3\nlv2hX0qLlq0h+IdhV7jqTxOOVfwMiYMaI9IRiRs26Af/1RMMH3Q3KhiM4blW6q/J\nKkQeVPeBYqyffIZlAgMBAAEwDQYJKoZIhvcNAQEFBQADgYEATeUM8Flh3BmhArqZ\nGVntBS3tEaGzHimyMUjMDncpKxR9aSIMib4t0Fq8jBCNsnQRPoUWObrdbMm7Yknm\nzK86buXUG6n/nJruzAM1Wp8Tqc4dN9XX7F/MAszxOLxr4Acr4jbHExsTSPD1yEo9\n9yRr/onMnZurvTMTwzcJgpRjheE=\n-----END CERTIFICATE-----";
        cert = HexBinaryUtilities.encodeAsString(((String)cert).getBytes());
        System.out.println("HEX: " + (String)cert);
        config = new CertificateDecodeConfig();
        config.setHexDecode(true);
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        System.out.println("PEM + HEX ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + HEX: " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("PEM + HEX (config UrlDecode_or_base64Decode) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("PEM + HEX (config UrlDecode_or_base64Decode): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("PEM + HEX (config UrlDecode_or_base64Decode_or_hexDecode) ...");
        certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        System.out.println("PEM + HEX (config UrlDecode_or_base64Decode_or_hexDecode): " + certDecoded.getCertificate().toString());
        if (!"Soggetto1".equals(certDecoded.getCertificate().getSubject().getCN())) {
            throw new Exception("CN '" + certDecoded.getCertificate().getSubject().getCN() + "' differente da quello atteso");
        }
        cert = "ALTRICARATTERICORROMPERE" + (String)cert;
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64Decode(true);
        System.out.println("PEM + HEX (corrupted) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("PEM + BASE64 (corrupted): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
        config = new CertificateDecodeConfig();
        config.setBase64Decode(false);
        config.setUrlDecode(false);
        config.setUrlDecodeOrBase64DecodeOrHexDecode(true);
        System.out.println("PEM + HEX (corrupted) ...");
        try {
            certDecoded = CertificateUtils.readCertificate(config, (String)cert);
        }
        catch (Exception multi) {
            if (Utilities.existsInnerException((Throwable)multi, UtilsMultiException.class)) {
                System.out.println("PEM + BASE64 (corrupted): eccezione attesa");
                e = (UtilsMultiException)Utilities.getInnerException((Throwable)multi, UtilsMultiException.class);
                index = 0;
                for (Throwable t : e.getExceptions()) {
                    System.out.println("Eccezione[" + index + "]=" + t.getMessage());
                    ++index;
                }
            }
            throw multi;
        }
    }
}

