/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.crypt.CodecCrypt;
import org.openspcoop2.utils.crypt.CodecType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptType;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.crypt.JasyptCrypt;
import org.openspcoop2.utils.crypt.JasyptType;
import org.openspcoop2.utils.crypt.OldMD5Crypt;
import org.openspcoop2.utils.crypt.PBEKeySpecCrypt;
import org.openspcoop2.utils.crypt.PlainCrypt;
import org.openspcoop2.utils.crypt.SpringCrypt;
import org.openspcoop2.utils.crypt.SpringType;
import org.slf4j.Logger;

public class CryptFactory {
    public static ICrypt getCrypt(Logger log, CryptConfig config) throws UtilsException {
        if (config.getCryptType() != null) {
            return CryptFactory.getCrypt(log, config.getCryptType(), config);
        }
        String className = config.getCryptCustomType();
        if (StringUtils.isEmpty((CharSequence)className)) {
            throw new UtilsException("Property 'passwordEncrypt.type' or 'passwordEncrypt.customType' are required");
        }
        return CryptFactory.getCrypt(log, className, config);
    }

    public static ICrypt getCrypt(Logger log, CryptType type, CryptConfig config) {
        return CryptFactory._getCrypt(log, type, config);
    }

    public static ICrypt getCrypt(CryptType type, CryptConfig config) {
        return CryptFactory._getCrypt(null, type, config);
    }

    public static ICrypt getCrypt(Logger log, CryptType type) {
        return CryptFactory._getCrypt(log, type, null);
    }

    public static ICrypt getCrypt(CryptType type) {
        return CryptFactory._getCrypt(null, type, null);
    }

    private static ICrypt _getCrypt(Logger log, CryptType type, CryptConfig config) {
        switch (type) {
            case LIBC_CRYPT_MD5: {
                return CryptFactory.getCodecCrypt(log, CodecType.LIBC_CRYPT_MD5, config);
            }
            case LIBC_CRYPT_MD5_APACHE: {
                return CryptFactory.getCodecCrypt(log, CodecType.LIBC_CRYPT_MD5_APACHE, config);
            }
            case SHA2_BASED_UNIX_CRYPT_SHA256: {
                return CryptFactory.getCodecCrypt(log, CodecType.SHA2_BASED_UNIX_CRYPT_SHA256, config);
            }
            case SHA2_BASED_UNIX_CRYPT_SHA512: {
                return CryptFactory.getCodecCrypt(log, CodecType.SHA2_BASED_UNIX_CRYPT_SHA512, config);
            }
            case DES_UNIX_CRYPT: {
                return CryptFactory.getCodecCrypt(log, CodecType.DES_UNIX_CRYPT, config);
            }
            case RFC2307_MD5: {
                return CryptFactory.getJasyptCrypt(log, JasyptType.RFC2307_MD5);
            }
            case RFC2307_SMD5: {
                return CryptFactory.getJasyptCrypt(log, JasyptType.RFC2307_SMD5);
            }
            case RFC2307_SHA: {
                return CryptFactory.getJasyptCrypt(log, JasyptType.RFC2307_SHA);
            }
            case RFC2307_SSHA: {
                return CryptFactory.getJasyptCrypt(log, JasyptType.RFC2307_SSHA);
            }
            case JASYPT_BASIC_PASSWORD: {
                return CryptFactory.getJasyptCrypt(log, JasyptType.JASYPT_BASIC_PASSWORD);
            }
            case JASYPT_STRONG_PASSWORD: {
                return CryptFactory.getJasyptCrypt(log, JasyptType.JASYPT_STRONG_PASSWORD);
            }
            case JASYPT_CUSTOM_PASSWORD: {
                return CryptFactory.getJasyptCrypt(log, config);
            }
            case PBE_KEY_SPEC: {
                PBEKeySpecCrypt pbe = new PBEKeySpecCrypt();
                pbe.init(log, config);
                return pbe;
            }
            case B_CRYPT: {
                return CryptFactory.getSpringCrypt(log, SpringType.B_CRYPT);
            }
            case S_CRYPT: {
                return CryptFactory.getSpringCrypt(log, SpringType.S_CRYPT);
            }
            case PLAIN: {
                PlainCrypt pbe = new PlainCrypt();
                pbe.init(log, config);
                return pbe;
            }
        }
        return null;
    }

    public static ICrypt getCrypt(Logger log, String className, CryptConfig config) throws UtilsException {
        return CryptFactory._getCrypt(log, className, config);
    }

    public static ICrypt getCrypt(String className, CryptConfig config) throws UtilsException {
        return CryptFactory._getCrypt(null, className, config);
    }

    public static ICrypt getCrypt(Logger log, String className) throws UtilsException {
        return CryptFactory._getCrypt(log, className, null);
    }

    public static ICrypt getCrypt(String className) throws UtilsException {
        return CryptFactory._getCrypt(null, className, null);
    }

    private static ICrypt _getCrypt(Logger log, String className, CryptConfig config) throws UtilsException {
        Class<ICrypt> c = null;
        try {
            c = Class.forName(className);
        }
        catch (Throwable e) {
            throw new UtilsException(e.getMessage(), e);
        }
        return CryptFactory._getCrypt(log, c, config);
    }

    public static ICrypt getCrypt(Logger log, Class<ICrypt> c, CryptConfig config) throws UtilsException {
        return CryptFactory._getCrypt(log, c, config);
    }

    public static ICrypt getCrypt(Class<ICrypt> c, CryptConfig config) throws UtilsException {
        return CryptFactory._getCrypt(null, c, config);
    }

    public static ICrypt getCrypt(Logger log, Class<ICrypt> c) throws UtilsException {
        return CryptFactory._getCrypt(log, c, null);
    }

    public static ICrypt getCrypt(Class<ICrypt> c) throws UtilsException {
        return CryptFactory._getCrypt(null, c, null);
    }

    private static ICrypt _getCrypt(Logger log, Class<ICrypt> c, CryptConfig config) throws UtilsException {
        try {
            ICrypt crypt = Utilities.newInstance(c);
            crypt.init(log, config);
            return crypt;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static OldMD5Crypt getOldMD5Crypt(Logger log) {
        OldMD5Crypt old = new OldMD5Crypt();
        old.init(log, null);
        return old;
    }

    public static OldMD5Crypt getOldMD5Crypt() {
        return CryptFactory.getOldMD5Crypt(null);
    }

    public static CodecCrypt getCodecCrypt(Logger log, CodecType type, CryptConfig config) {
        CodecCrypt c = new CodecCrypt(type);
        c.init(log, config);
        return c;
    }

    public static CodecCrypt getCodecCrypt(CodecType type, CryptConfig config) {
        return CryptFactory.getCodecCrypt(null, type, config);
    }

    public static CodecCrypt getCodecCrypt(Logger log, CodecType type) {
        return CryptFactory.getCodecCrypt(log, type, null);
    }

    public static CodecCrypt getCodecCrypt(CodecType type) {
        return CryptFactory.getCodecCrypt(null, type, null);
    }

    public static JasyptCrypt getJasyptCrypt(Logger log, CryptConfig config) {
        JasyptCrypt j = new JasyptCrypt();
        j.init(log, config);
        return j;
    }

    public static JasyptCrypt getJasyptCrypt(CryptConfig config) {
        return CryptFactory.getJasyptCrypt(null, config);
    }

    public static JasyptCrypt getJasyptCrypt(Logger log, JasyptType type) {
        JasyptCrypt j = new JasyptCrypt(type);
        j.init(log, null);
        return j;
    }

    public static JasyptCrypt getJasyptCrypt(JasyptType type) {
        return CryptFactory.getJasyptCrypt(null, type);
    }

    public static SpringCrypt getSpringCrypt(Logger log, SpringType type) {
        SpringCrypt s = new SpringCrypt(type);
        s.init(log, null);
        return s;
    }

    public static SpringCrypt getSpringCrypt(SpringType type) {
        return CryptFactory.getSpringCrypt(null, type);
    }
}

