/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.crypt;

import org.jasypt.salt.SaltGenerator;
import org.openspcoop2.utils.random.RandomGenerator;

public class JasyptCustomSaltGenerator
implements SaltGenerator {
    private RandomGenerator randomGenerator;
    private int lastSizeGenerated;

    public int getLastSizeGenerated() {
        return this.lastSizeGenerated;
    }

    public JasyptCustomSaltGenerator(RandomGenerator randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    public boolean includePlainSaltInEncryptionResults() {
        return true;
    }

    public byte[] generateSalt(int size) {
        try {
            byte[] byArray = this.randomGenerator.nextRandomBytes(size);
            return byArray;
        }
        finally {
            this.lastSizeGenerated = size;
        }
    }
}

