/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.csv;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.apache.commons.lang3.ArrayUtils;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.csv.Format;

public class FormatReader {
    public static final String CSV_FORMAT = "format";
    public static final String CSV_ALLOW_MISSING_COLUMN_NAMES = "allowMissingColumnNames";
    public static final String CSV_COMMENT_MARKER = "commentMarker";
    public static final String CSV_DELIMITER = "delimiter";
    public static final String CSV_ESCAPE = "escape";
    public static final String CSV_WITH_HEADER = "withHeader";
    public static final String CSV_HEADER = "header";
    public static final String CSV_WITH_IGNORE_EMPTY_LINES = "ignoreEmptyLines";
    public static final String CSV_WITH_IGNORE_SURROUNDING_SPACES = "ignoreSurroundingSpaces";
    public static final String CSV_WITH_NULL_STRING = "nullString";
    public static final String CSV_WITH_QUOTE = "quote";
    public static final String CSV_WITH_QUOTE_MODE = "quoteMode";
    public static final String CSV_WITH_RECORD_SEPARATOR = "recordSeparator";
    public static final String CSV_WITH_SKIP_HEADER_RECORD = "skipHeaderRecord";
    public static final String CSV_SKIP_EMPTY_RECORD = "skipEmptyRecord";
    private CSVFormat format;
    private boolean skipEmptyRecord = true;

    public FormatReader(InputStream is) throws UtilsException {
        Properties p = null;
        try {
            p = new Properties();
            p.load(is);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
        this.init(p);
    }

    public FormatReader(Properties properties) throws UtilsException {
        this.init(properties);
    }

    private void init(Properties properties) throws UtilsException {
        BooleanNullable skipEmptyRecord;
        BooleanNullable withSkipHeaderRecord;
        Character withRecordSeparator;
        String withQuoteMode;
        Character withQuote;
        String withNullString;
        BooleanNullable withIgnoreSurroundingSpaces;
        BooleanNullable withIgnoreEmptyLines;
        BooleanNullable withHeader;
        Character escape;
        Character delimiter;
        Character commentMarker;
        CSVFormat.Builder builder = null;
        if (properties.containsKey(CSV_FORMAT)) {
            String input = properties.getProperty(CSV_FORMAT).trim();
            CSVFormat.Predefined[] p = CSVFormat.Predefined.values();
            boolean found = false;
            for (int i = 0; i < p.length; ++i) {
                if (!p[i].toString().equalsIgnoreCase(input)) continue;
                builder = CSVFormat.Builder.create((CSVFormat)p[i].getFormat());
                found = true;
                break;
            }
            if (!found) {
                builder = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT);
            }
        } else {
            builder = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT);
        }
        BooleanNullable allowMissingColumnsNames = this.getBooleanProperty(properties, CSV_ALLOW_MISSING_COLUMN_NAMES);
        if (allowMissingColumnsNames != null && allowMissingColumnsNames.getValue() != null) {
            builder.setAllowMissingColumnNames(allowMissingColumnsNames.getValue().booleanValue());
        }
        if ((commentMarker = this.getCharProperty(properties, CSV_COMMENT_MARKER)) != null) {
            builder.setCommentMarker(commentMarker);
        }
        if ((delimiter = this.getCharProperty(properties, CSV_DELIMITER)) != null) {
            builder.setDelimiter(delimiter.charValue());
        }
        if ((escape = this.getCharProperty(properties, CSV_ESCAPE)) != null) {
            builder.setEscape(escape);
        }
        if ((withHeader = this.getBooleanProperty(properties, CSV_WITH_HEADER)) != null && withHeader.getValue() != null) {
            if (withHeader.getValue().booleanValue()) {
                h = this.getArrayStringProperty(properties, CSV_HEADER);
                if (h != null && h.length > 0) {
                    builder.setHeader(h);
                } else {
                    builder.setHeader(new String[0]);
                }
            }
        } else {
            h = this.getArrayStringProperty(properties, CSV_HEADER);
            if (h != null && h.length > 0) {
                builder.setHeader(h);
            }
        }
        if ((withIgnoreEmptyLines = this.getBooleanProperty(properties, CSV_WITH_IGNORE_EMPTY_LINES)) != null && withIgnoreEmptyLines.getValue() != null) {
            builder.setIgnoreEmptyLines(withIgnoreEmptyLines.getValue().booleanValue());
        }
        if ((withIgnoreSurroundingSpaces = this.getBooleanProperty(properties, CSV_WITH_IGNORE_SURROUNDING_SPACES)) != null && withIgnoreSurroundingSpaces.getValue() != null) {
            builder.setIgnoreSurroundingSpaces(withIgnoreSurroundingSpaces.getValue().booleanValue());
        }
        if ((withNullString = this.getProperty(properties, CSV_WITH_NULL_STRING)) != null) {
            builder.setNullString(withNullString);
        }
        if ((withQuote = this.getCharProperty(properties, CSV_WITH_QUOTE)) != null) {
            builder.setQuote(withQuote);
        }
        if ((withQuoteMode = this.getProperty(properties, CSV_WITH_QUOTE_MODE)) != null) {
            QuoteMode[] q = QuoteMode.values();
            boolean found = false;
            for (int i = 0; i < q.length; ++i) {
                if (!q[i].toString().equalsIgnoreCase(withQuoteMode)) continue;
                builder.setQuoteMode(q[i]);
                found = true;
                break;
            }
            if (!found) {
                throw new UtilsException("Quote Mode property [quoteMode] with wrong value [" + withQuoteMode + "]. Excpected values: " + ArrayUtils.toString((Object)QuoteMode.values()));
            }
        }
        if ((withRecordSeparator = this.getCharProperty(properties, CSV_WITH_RECORD_SEPARATOR)) != null) {
            builder.setRecordSeparator(withRecordSeparator.charValue());
        }
        if ((withSkipHeaderRecord = this.getBooleanProperty(properties, CSV_WITH_SKIP_HEADER_RECORD)) != null && withSkipHeaderRecord.getValue() != null) {
            builder.setSkipHeaderRecord(withSkipHeaderRecord.getValue().booleanValue());
        }
        if ((skipEmptyRecord = this.getBooleanProperty(properties, CSV_SKIP_EMPTY_RECORD)) != null && skipEmptyRecord.getValue() != null) {
            this.skipEmptyRecord = skipEmptyRecord.getValue();
        }
        this.format = builder.get();
    }

    public Format getFormat() {
        Format format = new Format();
        format.setCsvFormat(this.format);
        format.setSkipEmptyRecord(this.skipEmptyRecord);
        return format;
    }

    private String[] getArrayStringProperty(Properties properties, String name) throws UtilsException {
        String tmp;
        if (properties.containsKey(name) && (tmp = properties.getProperty(name)) != null) {
            String[] ret = (tmp = tmp.trim()).split(",");
            if (ret != null && ret.length >= 1) {
                return ret;
            }
            throw new UtilsException("Valore della propriet\u00e0 [" + name + "] deve essere una lista di valori separati da ','; trovato invece [" + tmp + "]");
        }
        return null;
    }

    private BooleanNullable getBooleanProperty(Properties properties, String name) throws UtilsException {
        String tmp;
        if (properties.containsKey(name) && (tmp = properties.getProperty(name)) != null) {
            if ("true".equalsIgnoreCase(tmp = tmp.trim())) {
                return BooleanNullable.TRUE();
            }
            if ("false".equalsIgnoreCase(tmp)) {
                return BooleanNullable.FALSE();
            }
            throw new UtilsException("Valore della propriet\u00e0 [" + name + "] deve essere un valore booleano, trovato invece [" + tmp + "]");
        }
        return BooleanNullable.NULL();
    }

    private Character getCharProperty(Properties properties, String name) throws UtilsException {
        String tmp;
        if (properties.containsKey(name) && (tmp = properties.getProperty(name)) != null) {
            if ((tmp = tmp.trim()).length() == 1) {
                return Character.valueOf(tmp.charAt(0));
            }
            throw new UtilsException("Valore della propriet\u00e0 [" + name + "] deve essere un singolo carattere, trovato invece [" + tmp + "]");
        }
        return null;
    }

    private String getProperty(Properties properties, String name) throws UtilsException {
        String tmp;
        if (properties.containsKey(name) && (tmp = properties.getProperty(name)) != null) {
            tmp = tmp.trim();
            return tmp;
        }
        return null;
    }
}

