/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.csv.test;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.csv.Format;
import org.openspcoop2.utils.csv.FormatReader;
import org.openspcoop2.utils.csv.Parser;
import org.openspcoop2.utils.csv.ParserMappingRecord;
import org.openspcoop2.utils.csv.ParserRegexpNotFound;
import org.openspcoop2.utils.csv.ParserResult;
import org.openspcoop2.utils.csv.Printer;
import org.openspcoop2.utils.csv.Record;

public class CSVTest {
    public static void main(String[] args) throws Exception {
        CSVTest.test();
    }

    public static void test() throws Exception {
        FormatReader formatReader = new FormatReader(CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.format.properties"));
        Format format = formatReader.getFormat();
        CSVTest.testMappingFilePosizionamentoCSV(format);
        CSVTest.testMappingFileNomiColonneCSV(format);
        CSVTest.testMappingProgrammazione(format);
        FormatReader formatWriter = new FormatReader(CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.formatWriter.properties"));
        Format formatW = formatWriter.getFormat();
        CSVTest.testScrittura(formatW, "csv");
        FormatReader formatWriterExcel = new FormatReader(CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.formatWriterExcel.properties"));
        Format formatWExcel = formatWriterExcel.getFormat();
        CSVTest.testScrittura(formatWExcel, "xls");
    }

    private static void testScrittura(Format format, String ext) throws Exception {
        System.out.println("============================================================");
        System.out.println("Printer.testScrittura (" + ext + ")");
        System.out.println("============================================================");
        String file = "/tmp/prova." + ext;
        Printer printer = new Printer(format, new File(file));
        ArrayList<String> header = new ArrayList<String>();
        header.add("Valore1");
        header.add("Valore2");
        header.add("Valore3");
        ArrayList<String> valori = new ArrayList<String>();
        valori.add("V1");
        valori.add("V2");
        valori.add("V3,AltroValoreConVirgola");
        if (!"xls".equals(ext)) {
            printer.printComment("Intestazione");
            printer.printRecord(header);
        }
        printer.println();
        printer.printComment("Valori");
        printer.printRecord(valori);
        printer.printRecord(valori);
        printer.printRecord(valori);
        printer.printRecord(valori);
        ArrayList<String> valoriWithNull = new ArrayList<String>();
        valoriWithNull.add("V1");
        valoriWithNull.add("");
        valoriWithNull.add(null);
        printer.printRecord(valoriWithNull);
        printer.close();
        System.out.println("File scritto in [" + file + "]");
        System.out.println("\n\n");
    }

    private static void testMappingFilePosizionamentoCSV(Format format) throws Exception {
        System.out.println("============================================================");
        System.out.println("Parser.testMappingFilePosizionamentoCSV");
        System.out.println("============================================================");
        Parser parser = new Parser(CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.mapping.properties"), true);
        ParserResult pr = parser.parseCsvFile(format, CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.csv"));
        CSVTest.print(pr);
        System.out.println("\n\n");
    }

    private static void testMappingFileNomiColonneCSV(Format format) throws Exception {
        System.out.println("============================================================");
        System.out.println("Parser.testMappingFileNomiColonneCSV");
        System.out.println("============================================================");
        Parser parser = new Parser(CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.mappingNames.properties"), false);
        ParserResult pr = parser.parseCsvFile(format, CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.csv"));
        CSVTest.print(pr);
        System.out.println("\n\n");
    }

    private static void testMappingProgrammazione(Format format) throws Exception {
        ArrayList<ParserMappingRecord> listParserInstruction = new ArrayList<ParserMappingRecord>();
        listParserInstruction.add(ParserMappingRecord.newCsvConstantRecord("tipologia", "Fruizione"));
        ParserMappingRecord pmcNomeServizio = ParserMappingRecord.newCsvColumnPositionRecord("nomeServizio", 0);
        pmcNomeServizio.setRequired(true);
        listParserInstruction.add(pmcNomeServizio);
        listParserInstruction.add(ParserMappingRecord.newCsvColumnPositionRecord("nomeAccordo", 1));
        listParserInstruction.add(ParserMappingRecord.newCsvColumnPositionRecord("nomeSoggettoErogatore", 2));
        listParserInstruction.add(ParserMappingRecord.newCsvColumnPositionRecord("nomeSoggettoFruitore", (Integer)3, "FruitoreNonDisponibile"));
        listParserInstruction.add(ParserMappingRecord.newCsvColumnNameRecord("saFruitoreUsername", "SA FRUITORE", ParserRegexpNotFound.ORIGINAL, "(.*)MatchCheNonFunziona/.*", "(.*)/.*", "(.*)AltroMatchCheNonFunziona/.*"));
        listParserInstruction.add(ParserMappingRecord.newCsvColumnPositionRecord("saFruitorePassword", (Integer)4, new String[]{".*/([^/?]*).*"}));
        listParserInstruction.add(ParserMappingRecord.newCsvColumnNameRecord("saErogatore", "SA EROGATORE"));
        System.out.println("============================================================");
        System.out.println("Parser.testMappingProgrammazione");
        System.out.println("============================================================");
        Parser parser = new Parser(listParserInstruction);
        ParserResult pr = parser.parseCsvFile(format, CSVTest.class.getResourceAsStream("/org/openspcoop2/utils/csv/test/example.csv"));
        CSVTest.print(pr);
        System.out.println("\n\n");
    }

    private static void print(ParserResult pr) throws Exception {
        System.out.println("ExistsHeader [" + pr.existsHeader() + "]");
        if (pr.existsHeader()) {
            for (String key : pr.getHeaderMap().keySet()) {
                System.out.println("Header [" + key + "] [" + String.valueOf(pr.getHeaderMap().get(key)) + "]");
            }
        }
        List<Record> results = pr.getRecords();
        for (Record record : results) {
            if (record.getComment() != null) {
                System.out.println("CommentLine[" + record.getCsvLine() + "] -> [" + record.getComment() + "]");
            }
            System.out.println("CsvLine[" + record.getCsvLine() + "] tipologia[" + record.getMap().get("tipologia") + "] nomeServizio[" + record.getMap().get("nomeServizio") + "] nomeAccordo[" + record.getMap().get("nomeAccordo") + "] nomeSoggettoErogatore[" + record.getMap().get("nomeSoggettoErogatore") + "] nomeSoggettoFruitore[" + record.getMap().get("nomeSoggettoFruitore") + "] saFruitoreUsername[" + record.getMap().get("saFruitoreUsername") + "] saFruitorePassword[" + record.getMap().get("saFruitorePassword") + "] saErogatore[" + record.getMap().get("saErogatore") + "]");
        }
    }
}

