/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.date.test;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.DateUtils;
import org.openspcoop2.utils.date.test.TestDate;

public class DateFormatTest {
    public static void main(String[] args) throws ParseException {
        DateFormatTest.test();
    }

    public static void test() throws ParseException {
        Date nowDate = DateManager.getDate();
        ZonedDateTime nowDateTime = ZonedDateTime.now();
        DateTime jodaDateTime = DateTime.now();
        boolean threads = false;
        boolean DATE_TIME = true;
        boolean TIME = true;
        boolean DATE = true;
        int N = 777777;
        String formato = null;
        formato = "yyyy MM dd HH mm s";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "dd-MM-yyyy HH:mm:ss.SSS";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyyMMddHHmmssSSS";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyyMMdd_HHmmssSSS";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyyMMddHHmm";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyyMMdd";
        DateFormatTest.test(formato, N, !DATE_TIME, DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HH:mm:ss.SSS";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HH:mm:ss.SSSX";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HH:mm:ss";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HH:mm:ssX";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HH:mm";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HH:mmX";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HH";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd_HHX";
        DateFormatTest.test(formato, N, DATE_TIME, !DATE, !TIME, threads);
        formato = "yyyy-MM-dd";
        DateFormatTest.test(formato, N, !DATE_TIME, DATE, !TIME, threads);
        formato = "yyyy-MM-ddX";
        DateFormatTest.test(formato, N, !DATE_TIME, DATE, !TIME, threads);
        formato = "HH:mm:ss.SSS";
        DateFormatTest.test(formato, N, !DATE_TIME, !DATE, TIME, threads);
    }

    private static void test(String formato, int N, boolean dateTime, boolean date, boolean time, boolean threadsEnabled) throws ParseException {
        boolean tmpTerminated;
        int i;
        int i2;
        System.out.println("==============================================");
        System.out.println("Formato: " + formato);
        java.time.format.DateTimeFormatter dateTimeFormatter = DateUtils.getDateTimeFormatter(formato);
        DateTimeFormatter jodaDateTimeFormatter = DateUtils.getJodaDateTimeFormatter(formato);
        Date nowDate = DateManager.getDate();
        ZonedDateTime nowDateTime = ZonedDateTime.now();
        DateTime jodaDateTime = DateTime.now();
        String sJava = new SimpleDateFormat(formato).format(nowDate);
        System.out.println("SimpleDateFormat normale  :              " + sJava);
        Date ds = new SimpleDateFormat(formato).parse(sJava);
        System.out.println("SimpleDateFormat reversed :              " + new SimpleDateFormat(formato).format(ds));
        String sTime = dateTimeFormatter.format(nowDateTime);
        System.out.println("DateTimeFormatter normale  :             " + sTime);
        ds = dateTime ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDateTime(formato, sTime)) : (time ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalTime(formato, sTime)) : DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDate(formato, sTime)));
        System.out.println("DateTimeFormatter reversed :             " + dateTimeFormatter.format(DateUtils.convertToZonedDateTimeViaInstant(ds)));
        ds = dateTime ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDateTime(formato, sJava)) : (time ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalTime(formato, sJava)) : DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDate(formato, sJava)));
        System.out.println("DateTimeFormatter reverseJ :             " + dateTimeFormatter.format(DateUtils.convertToZonedDateTimeViaInstant(ds)));
        System.out.println("DateTimeFormatter (converted):           " + dateTimeFormatter.format(nowDate.toInstant().atZone(ZoneId.systemDefault())));
        String sJoda = jodaDateTime.toString(jodaDateTimeFormatter);
        System.out.println("JodaDateTimeFormatter normale  :         " + sJoda);
        ds = DateUtils.convertToDate(DateUtils.parseToJodaDateTime(formato, sJoda));
        System.out.println("JodaDateTimeFormatter reversed :         " + DateUtils.convertToJodaDateTime(ds).toString(jodaDateTimeFormatter));
        ds = DateUtils.convertToDate(DateUtils.parseToJodaDateTime(formato, sJava));
        System.out.println("JodaDateTimeFormatter reverseJ :         " + DateUtils.convertToJodaDateTime(ds).toString(jodaDateTimeFormatter));
        ds = DateUtils.convertToDate(DateUtils.parseToJodaDateTime(formato, sTime));
        System.out.println("JodaDateTimeFormatter reverseT :         " + DateUtils.convertToJodaDateTime(ds).toString(jodaDateTimeFormatter));
        System.out.println("JodaDateTime (converted):                " + new DateTime((Object)nowDate).toString(jodaDateTimeFormatter));
        ds = dateTime ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDateTime(formato, sJoda)) : (time ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalTime(formato, sJoda)) : DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDate(formato, sJoda)));
        System.out.println("DateTimeFormatter reversJO :             " + dateTimeFormatter.format(DateUtils.convertToZonedDateTimeViaInstant(ds)));
        long now = System.currentTimeMillis();
        for (int i3 = 0; i3 < N; ++i3) {
            sJava = new SimpleDateFormat(formato).format(nowDate);
            ds = new SimpleDateFormat(formato).parse(sJava);
        }
        long end = System.currentTimeMillis();
        System.out.println("SimpleDateFormat: " + (end - now));
        now = System.currentTimeMillis();
        for (int i22 = 0; i22 < N; ++i22) {
            sTime = dateTimeFormatter.format(nowDateTime);
            ds = dateTime ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDateTime(formato, sTime)) : (time ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalTime(formato, sTime)) : DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDate(formato, sTime)));
        }
        end = System.currentTimeMillis();
        System.out.println("DateTimeFormatter: " + (end - now));
        now = System.currentTimeMillis();
        for (i2 = 0; i2 < N; ++i2) {
            sTime = dateTimeFormatter.format(DateUtils.convertToZonedDateTimeViaInstant(nowDate));
            ds = dateTime ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDateTime(formato, sTime)) : (time ? DateUtils.convertToDateViaInstant(DateUtils.parseToLocalTime(formato, sTime)) : DateUtils.convertToDateViaInstant(DateUtils.parseToLocalDate(formato, sTime)));
        }
        end = System.currentTimeMillis();
        System.out.println("DateTimeFormatter (origDate converted): " + (end - now));
        now = System.currentTimeMillis();
        for (i2 = 0; i2 < N; ++i2) {
            sJoda = jodaDateTime.toString(jodaDateTimeFormatter);
            ds = DateUtils.convertToDate(DateUtils.parseToJodaDateTime(formato, sJoda));
        }
        end = System.currentTimeMillis();
        System.out.println("JODA DateTimeFormatter: " + (end - now));
        now = System.currentTimeMillis();
        for (i2 = 0; i2 < N; ++i2) {
            sJoda = DateUtils.convertToJodaDateTime(nowDate).toString(jodaDateTimeFormatter);
            ds = DateUtils.convertToDate(DateUtils.parseToJodaDateTime(formato, sJoda));
        }
        end = System.currentTimeMillis();
        System.out.println("JODA DateTimeFormatter (origDate converted): " + (end - now));
        if (!threadsEnabled) {
            return;
        }
        int threads = 100;
        ExecutorService threadsPool = Executors.newFixedThreadPool(threads);
        now = System.currentTimeMillis();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i4 = 0; i4 < threads; ++i4) {
            TestDate thread2 = new TestDate(N, formato, false, false, false);
            threadsPool.execute(thread2);
            list.add(thread2);
        }
        boolean terminated = false;
        while (!terminated) {
            boolean tmpTerminated2 = true;
            for (TestDate testDate : list) {
                if (testDate.isFinished()) continue;
                tmpTerminated2 = false;
                break;
            }
            if (!tmpTerminated2) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
                continue;
            }
            terminated = true;
        }
        end = System.currentTimeMillis();
        System.out.println("SimpleDateFormat: " + (end - now));
        threadsPool = Executors.newFixedThreadPool(threads);
        now = System.currentTimeMillis();
        list = new ArrayList();
        for (i = 0; i < threads; ++i) {
            TestDate thread3 = new TestDate(N, formato, true, false, false);
            threadsPool.execute(thread3);
            list.add(thread3);
        }
        terminated = false;
        while (!terminated) {
            tmpTerminated = true;
            for (TestDate testDate : list) {
                if (testDate.isFinished()) continue;
                tmpTerminated = false;
                break;
            }
            if (!tmpTerminated) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception thread3) {}
                continue;
            }
            terminated = true;
        }
        end = System.currentTimeMillis();
        System.out.println("DateTimeFormatter: " + (end - now));
        threadsPool = Executors.newFixedThreadPool(threads);
        now = System.currentTimeMillis();
        list = new ArrayList();
        for (i = 0; i < threads; ++i) {
            TestDate thread4 = new TestDate(N, formato, true, false, true);
            threadsPool.execute(thread4);
            list.add(thread4);
        }
        terminated = false;
        while (!terminated) {
            tmpTerminated = true;
            for (TestDate testDate : list) {
                if (testDate.isFinished()) continue;
                tmpTerminated = false;
                break;
            }
            if (!tmpTerminated) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception thread4) {}
                continue;
            }
            terminated = true;
        }
        end = System.currentTimeMillis();
        System.out.println("DateTimeFormatter (converted): " + (end - now));
        threadsPool = Executors.newFixedThreadPool(threads);
        now = System.currentTimeMillis();
        list = new ArrayList();
        for (i = 0; i < threads; ++i) {
            TestDate thread5 = new TestDate(N, formato, false, true, false);
            threadsPool.execute(thread5);
            list.add(thread5);
        }
        terminated = false;
        while (!terminated) {
            tmpTerminated = true;
            for (TestDate testDate : list) {
                if (testDate.isFinished()) continue;
                tmpTerminated = false;
                break;
            }
            if (!tmpTerminated) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception thread5) {}
                continue;
            }
            terminated = true;
        }
        end = System.currentTimeMillis();
        System.out.println("JodaDateTimeFormatter: " + (end - now));
        threadsPool = Executors.newFixedThreadPool(threads);
        now = System.currentTimeMillis();
        list = new ArrayList();
        for (i = 0; i < threads; ++i) {
            TestDate thread = new TestDate(N, formato, false, true, true);
            threadsPool.execute(thread);
            list.add(thread);
        }
        terminated = false;
        while (!terminated) {
            tmpTerminated = true;
            for (TestDate testDate : list) {
                if (testDate.isFinished()) continue;
                tmpTerminated = false;
                break;
            }
            if (!tmpTerminated) {
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
                continue;
            }
            terminated = true;
        }
        end = System.currentTimeMillis();
        System.out.println("JodaDateTimeFormatter (converted): " + (end - now));
        System.out.println("FINITO");
    }
}

