/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.dch;

import jakarta.activation.CommandInfo;
import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.slf4j.Logger;

public class DataContentHandlerManager {
    private Logger log;

    public DataContentHandlerManager(Logger log) {
        this.log = log;
    }

    private void logInfo(String msg) {
        this.log.info(msg);
    }

    public void initMailcap() {
        byte[] tmp;
        URL url;
        Enumeration<URL> en;
        try {
            this.logInfo("Search mailcap.default ...");
            en = DataContentHandlerManager.class.getClassLoader().getResources("/META-INF/mailcap.default");
            if (en != null) {
                while (en.hasMoreElements()) {
                    url = en.nextElement();
                    this.logInfo("Find mailcap.default [" + url.toString() + "]");
                    this.logInfo("Read mailcap.default [" + url.toString() + "] ...");
                    tmp = Utilities.getAsByteArray(url);
                    this.logInfo("Read mailcap.default [" + url.toString() + "]: " + new String(tmp));
                    this.addMimeTypesIntoMailcap(tmp);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Mailcap.default search error: " + e.getMessage(), (Throwable)e);
        }
        try {
            this.logInfo("Search mailcap ...");
            en = DataContentHandlerManager.class.getClassLoader().getResources("/META-INF/mailcap");
            if (en != null) {
                while (en.hasMoreElements()) {
                    url = en.nextElement();
                    this.logInfo("Find mailcap [" + url.toString() + "]");
                    this.logInfo("Read mailcap [" + url.toString() + "] ...");
                    tmp = Utilities.getAsByteArray(url);
                    this.logInfo("Read mailcap [" + url.toString() + "]: " + new String(tmp));
                    this.addMimeTypesIntoMailcap(tmp);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Mailcap search error: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<String> readMimeTypesRegistrati() {
        return this.readMimeTypesRegistrati(true);
    }

    public List<String> readMimeTypesRegistrati(boolean debug) {
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        String[] gestiti = mcap.getMimeTypes();
        ArrayList<String> gestitiAsList = new ArrayList<String>();
        if (gestiti != null) {
            if (debug) {
                this.logInfo("MimeTypes registrati: [" + gestiti.length + "]");
            }
            for (int i = 0; i < gestiti.length; ++i) {
                this.processMimeType(debug, gestiti, i, gestitiAsList, mcap);
            }
        } else if (debug) {
            this.logInfo("Non risultano registrati MimeTypes");
        }
        return gestitiAsList;
    }

    private void processMimeType(boolean debug, String[] gestiti, int i, List<String> gestitiAsList, MailcapCommandMap mcap) {
        if (debug) {
            this.logInfo("MimeType registrato: [" + gestiti[i] + "]");
        }
        gestitiAsList.add(gestiti[i]);
        CommandInfo[] cis = mcap.getAllCommands(gestiti[i]);
        for (int j = 0; j < cis.length; ++j) {
            if (!debug) continue;
            this.logInfo("\t[" + j + "] " + cis[j].getCommandName() + " = " + cis[j].getCommandClass());
        }
    }

    public Map<String, String> readMimeTypesContentHandler() {
        return this.readMimeTypesContentHandler(true);
    }

    public Map<String, String> readMimeTypesContentHandler(boolean debug) {
        return this.readMimeTypesClassEngine(debug, "content-handler");
    }

    public Map<String, String> readMimeTypesView() {
        return this.readMimeTypesView(true);
    }

    public Map<String, String> readMimeTypesView(boolean debug) {
        return this.readMimeTypesClassEngine(debug, "view");
    }

    public Map<String, String> readMimeTypesEdit() {
        return this.readMimeTypesEdit(true);
    }

    public Map<String, String> readMimeTypesEdit(boolean debug) {
        return this.readMimeTypesClassEngine(debug, "edit");
    }

    private Map<String, String> readMimeTypesClassEngine(boolean debug, String commandName) {
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        String[] gestiti = mcap.getMimeTypes();
        HashMap<String, String> map = new HashMap<String, String>();
        if (gestiti != null) {
            if (debug) {
                this.logInfo("MimeTypes (" + commandName + ") registrati: [" + gestiti.length + "]");
            }
            for (int i = 0; i < gestiti.length; ++i) {
                this.processMimeTypeClass(debug, commandName, gestiti, i, map, mcap);
            }
        } else if (debug) {
            this.logInfo("Non risultano registrati MimeTypes (" + commandName + ")");
        }
        return map;
    }

    private void processMimeTypeClass(boolean debug, String commandName, String[] gestiti, int i, Map<String, String> map, MailcapCommandMap mcap) {
        CommandInfo[] cis;
        if (debug) {
            this.logInfo("MimeType (" + commandName + ") registrato: [" + gestiti[i] + "]");
        }
        if ((cis = mcap.getAllCommands(gestiti[i])) != null && cis.length > 0) {
            for (int j = 0; j < cis.length; ++j) {
                if (debug) {
                    this.logInfo("\t[" + j + "] " + cis[j].getCommandName() + " = " + cis[j].getCommandClass());
                }
                if (!commandName.equalsIgnoreCase(cis[j].getCommandName())) continue;
                map.put(gestiti[i], cis[j].getCommandClass());
            }
        }
    }

    public void addMimeTypeIntoMailcap(String commandInfo) throws UtilsException {
        if (!commandInfo.contains(";;")) {
            throw new UtilsException("Formato non corretto, non \u00e8 stato riscontrato il carattere ';;'");
        }
        String[] split = commandInfo.split(";;");
        if (split == null || split.length != 2) {
            throw new UtilsException("Formato non corretto");
        }
        MailcapCommandMap mcap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mcap.addMailcap(commandInfo);
        CommandMap.setDefaultCommandMap((CommandMap)mcap);
        this.logInfo("Registrato in Mailcap il mimetype [" + split[0] + "]: " + commandInfo);
    }

    public void addMimeTypesIntoMailcap(byte[] mailcap) throws IOException, UtilsException {
        List<String> gestitiAsList = this.readMimeTypesRegistrati(false);
        try (ByteArrayInputStream bin = new ByteArrayInputStream(mailcap);
             InputStreamReader isr = new InputStreamReader(bin);
             BufferedReader br = new BufferedReader(isr);){
            String strLine;
            while ((strLine = br.readLine()) != null) {
                String[] split;
                if (strLine.startsWith("#") || !strLine.contains(";;") || gestitiAsList.contains((split = strLine.split(";;"))[0])) continue;
                gestitiAsList.add(split[0]);
                this.addMimeTypeIntoMailcap(strLine);
            }
        }
    }
}

