/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.digest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.digest.DigestType;

public class DigestConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DIGEST_TYPE = "digest.type";
    private static final String DIGEST_SALT_LENGTH = "digest.salt.length";
    private static final String DIGEST_SALT_SECURE_RANDOM_ALGORITHM = "digest.salt.secureRandomAlgorithm";
    private static final String DIGEST_BASE64_ENCODE = "digest.base64Encode";
    private static final String DIGEST_HASH_COMPOSITION = "digest.composition";
    private DigestType digestType;
    private Integer saltLength;
    private String algorithmSecureRandom;
    private String hashComposition;
    private boolean base64Encode;
    private static final Pattern COMPOSITION_VAR_PATTERN = Pattern.compile("\\$\\{([^\\}]*)\\}");
    private static final String SALT_LABEL = "salt";
    private static final String MESSAGE_LABEL = "message";

    public DigestConfig() {
        this.digestType = null;
        this.saltLength = null;
        this.algorithmSecureRandom = "SHA1PRNG";
        this.hashComposition = "${message}${salt}";
        this.base64Encode = false;
    }

    public DigestConfig(String resource) throws UtilsException {
        block9: {
            this.digestType = null;
            this.saltLength = null;
            this.algorithmSecureRandom = "SHA1PRNG";
            this.hashComposition = "${message}${salt}";
            this.base64Encode = false;
            try (InputStream is = this.getInputStream(resource);){
                if (is != null) {
                    Properties p = new Properties();
                    p.load(is);
                    this.initEngine(p);
                    break block9;
                }
                throw new UtilsException("Resource [" + resource + "] not found");
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
    }

    private InputStream getInputStream(String resource) throws FileNotFoundException {
        File f = new File(resource);
        InputStream is = null;
        is = f.exists() ? new FileInputStream(f) : DigestConfig.class.getResourceAsStream(resource);
        if (is == null) {
            is = DigestConfig.class.getResourceAsStream("/org/openspcoop2/utils/crypt/digest.properties");
        }
        return is;
    }

    public DigestConfig(InputStream is) throws UtilsException {
        this.digestType = null;
        this.saltLength = null;
        this.algorithmSecureRandom = "SHA1PRNG";
        this.hashComposition = "${message}${salt}";
        this.base64Encode = false;
        try {
            Properties p = new Properties();
            p.load(is);
            this.initEngine(p);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public DigestConfig(Properties p) throws UtilsException {
        this.digestType = null;
        this.saltLength = null;
        this.algorithmSecureRandom = "SHA1PRNG";
        this.hashComposition = "${message}${salt}";
        this.base64Encode = false;
        this.initEngine(p);
    }

    private void initEngine(Properties p) throws UtilsException {
        String digestHashComposition;
        String digestBase64Encode;
        String secureRandomAlgo;
        String saltLengthProp;
        String NOT_CORRECT_PROPERTY = "Property: '%s' value: '%s' not correct: %s";
        String tipo = DigestConfig.getProperty(p, DIGEST_TYPE, true);
        if (StringUtils.isNotEmpty((CharSequence)tipo)) {
            DigestType digestTypeProp = null;
            try {
                digestTypeProp = DigestType.valueOf(tipo);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new UtilsException(String.format("Property: '%s' value: '%s' not correct: %s", DIGEST_TYPE, tipo, e.getMessage()), e);
            }
            this.digestType = digestTypeProp;
        }
        if (StringUtils.isNotEmpty((CharSequence)(saltLengthProp = DigestConfig.getProperty(p, DIGEST_SALT_LENGTH, false)))) {
            try {
                this.saltLength = Integer.valueOf(saltLengthProp);
            }
            catch (NumberFormatException e) {
                throw new UtilsException(String.format("Property: '%s' value: '%s' not correct: %s", DIGEST_SALT_LENGTH, saltLengthProp, e.getMessage()), e);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(secureRandomAlgo = DigestConfig.getProperty(p, DIGEST_SALT_SECURE_RANDOM_ALGORITHM, false)))) {
            this.algorithmSecureRandom = secureRandomAlgo;
        }
        if (StringUtils.isNotEmpty((CharSequence)(digestBase64Encode = DigestConfig.getProperty(p, DIGEST_BASE64_ENCODE, false)))) {
            this.base64Encode = Boolean.valueOf(digestBase64Encode);
        }
        if (StringUtils.isNotEmpty((CharSequence)(digestHashComposition = DigestConfig.getProperty(p, DIGEST_HASH_COMPOSITION, false)))) {
            this.hashComposition = digestHashComposition;
        }
    }

    protected static String getProperty(Properties p, String name, boolean required) throws UtilsException {
        String pValue = p.getProperty(name);
        if (pValue == null) {
            if (required) {
                throw new UtilsException("Property '" + name + "' not found");
            }
            return null;
        }
        return pValue.trim();
    }

    public byte[] composeMessage(byte[] input, byte[] salt) {
        String scheme = this.getHashComposition();
        Pattern pattern = COMPOSITION_VAR_PATTERN;
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        Matcher matcher = pattern.matcher(scheme);
        int lastIndex = 0;
        int size = 0;
        while (matcher.find(lastIndex)) {
            if (lastIndex < matcher.start()) {
                bytes.add(scheme.substring(lastIndex, matcher.start()).getBytes());
                size += matcher.start() - lastIndex;
            }
            lastIndex = matcher.end();
            byte[] sub = null;
            if (matcher.group(1).equals(MESSAGE_LABEL)) {
                sub = input;
            }
            if (matcher.group(1).equals(SALT_LABEL)) {
                sub = salt;
            }
            if (sub == null) continue;
            size += sub.length;
            bytes.add(sub);
        }
        if (lastIndex < scheme.length()) {
            bytes.add(scheme.substring(lastIndex).getBytes());
            size += scheme.length() - lastIndex;
        }
        byte[] buf = new byte[size];
        lastIndex = 0;
        for (byte[] src : bytes) {
            System.arraycopy(src, 0, buf, lastIndex, src.length);
            lastIndex += src.length;
        }
        return buf;
    }

    public DigestType getDigestType() {
        return this.digestType;
    }

    public void setDigestType(DigestType digestType) {
        this.digestType = digestType;
    }

    public Integer getSaltLength() {
        return this.saltLength;
    }

    public void setSaltLength(Integer saltLength) {
        this.saltLength = saltLength;
    }

    public String getAlgorithmSecureRandom() {
        return this.algorithmSecureRandom;
    }

    public void setAlgorithmSecureRandom(String algorithmSecureRandom) {
        this.algorithmSecureRandom = algorithmSecureRandom;
    }

    public boolean isBase64Encode() {
        return this.base64Encode;
    }

    public void setBase64Encode(boolean base64Encode) {
        this.base64Encode = base64Encode;
    }

    public String getHashComposition() {
        return this.hashComposition;
    }

    public void setHashComposition(String hashComposition) {
        this.hashComposition = hashComposition;
    }
}

