/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.digest;

import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.digest.DigestEncoding;
import org.openspcoop2.utils.digest.MessageDigestFactory;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;

public class DigestUtils {
    private DigestUtils() {
    }

    private static UtilsException newUtilsExceptionDigestEncodingUndefined() {
        return new UtilsException("Digest encoding undefined");
    }

    public static byte[] getDigestValue(byte[] content, String algorithm) throws UtilsException {
        if (content == null) {
            throw new UtilsException("Digest content undefined");
        }
        if (algorithm == null) {
            throw new UtilsException("Digest algorithm undefined");
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigestFactory.getMessageDigest(algorithm);
        }
        catch (Exception e) {
            throw new UtilsException("Message digest (algorithm: '" + algorithm + "') initialization failed: " + e.getMessage(), e);
        }
        try {
            return digest.digest(content);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static String getDigestValue(byte[] content, String algorithm, DigestEncoding digestEncoding) throws UtilsException {
        return DigestUtils.getDigestValue(content, algorithm, digestEncoding, false);
    }

    public static String getDigestValue(byte[] content, String algorithm, DigestEncoding digestEncoding, boolean rfc3230) throws UtilsException {
        byte[] md5Data = DigestUtils.getDigestValue(content, algorithm);
        if (digestEncoding == null) {
            throw DigestUtils.newUtilsExceptionDigestEncodingUndefined();
        }
        return DigestUtils.encode(md5Data, digestEncoding, rfc3230, algorithm);
    }

    public static Map<DigestEncoding, String> getDigestValues(byte[] content, String algorithm, DigestEncoding ... digestEncoding) throws UtilsException {
        return DigestUtils.getDigestValues(content, algorithm, false, digestEncoding);
    }

    public static Map<DigestEncoding, String> getDigestValues(byte[] content, String algorithm, boolean rfc3230, DigestEncoding ... digestEncoding) throws UtilsException {
        byte[] md5Data = DigestUtils.getDigestValue(content, algorithm);
        if (digestEncoding == null || digestEncoding.length <= 0) {
            throw DigestUtils.newUtilsExceptionDigestEncodingUndefined();
        }
        HashMap<DigestEncoding, String> map = new HashMap<DigestEncoding, String>();
        for (DigestEncoding de : digestEncoding) {
            try {
                String digestValue = DigestUtils.encode(md5Data, de, rfc3230, algorithm);
                map.put(de, digestValue);
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        return map;
    }

    private static String encode(byte[] md5Data, DigestEncoding digestEncoding, boolean rfc3230, String algorithm) throws UtilsException {
        if (digestEncoding == null) {
            throw DigestUtils.newUtilsExceptionDigestEncodingUndefined();
        }
        try {
            String digestValue = null;
            if (DigestEncoding.HEX.equals((Object)digestEncoding)) {
                digestValue = HexBinaryUtilities.encodeAsString(md5Data);
            } else if (DigestEncoding.BASE64.equals((Object)digestEncoding)) {
                digestValue = Base64Utilities.encodeAsString(md5Data);
            } else {
                throw new UtilsException("DigestEncoding '" + String.valueOf((Object)digestEncoding) + "' unsupported");
            }
            if (rfc3230) {
                return algorithm + "=" + digestValue;
            }
            return digestValue;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

