/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;

public class MessageDigestFactory {
    private static boolean useBouncyCastleProvider = false;
    private static Provider provider = null;

    public static boolean isUseBouncyCastleProvider() {
        return useBouncyCastleProvider;
    }

    public static void setUseBouncyCastleProvider(boolean useBouncyCastleProvider) {
        MessageDigestFactory.useBouncyCastleProvider = useBouncyCastleProvider;
    }

    private static synchronized Provider _getProvider() {
        if (provider == null) {
            provider = Security.getProvider("BC");
        }
        return provider;
    }

    private static Provider getProvider() {
        if (!useBouncyCastleProvider) {
            return null;
        }
        if (provider == null) {
            return MessageDigestFactory._getProvider();
        }
        return provider;
    }

    public static MessageDigest getMessageDigest(String algoritmo) throws NoSuchAlgorithmException {
        MessageDigest digest = null;
        digest = useBouncyCastleProvider ? MessageDigest.getInstance(algoritmo, MessageDigestFactory.getProvider()) : MessageDigest.getInstance(algoritmo);
        return digest;
    }
}

