/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.serial;

import java.sql.Connection;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorBuffer;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorParameter;
import org.openspcoop2.utils.id.serial.IDSerialGeneratorType;
import org.openspcoop2.utils.id.serial.IDSerialGenerator_alphanumeric;
import org.openspcoop2.utils.id.serial.IDSerialGenerator_mysql;
import org.openspcoop2.utils.id.serial.IDSerialGenerator_numeric;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.slf4j.Logger;

public class IDSerialGenerator {
    private InfoStatistics infoStatistics;

    public IDSerialGenerator(InfoStatistics infoStatistics) {
        this.infoStatistics = infoStatistics;
    }

    public IDSerialGenerator() {
    }

    public void clearBuffer() {
        IDSerialGeneratorBuffer.clearBuffer();
    }

    public void clearBuffer(IDSerialGeneratorParameter param) {
        IDSerialGeneratorType tipo = param.getTipo();
        if (IDSerialGeneratorType.ALFANUMERICO.equals((Object)tipo) || IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo)) {
            if (IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo)) {
                IDSerialGeneratorBuffer.clearBuffer(IDSerialGenerator_numeric.class);
            } else {
                IDSerialGeneratorBuffer.clearBuffer(IDSerialGenerator_alphanumeric.class);
            }
        }
    }

    public long buildIDAsNumber(IDSerialGeneratorParameter param, Connection con, TipiDatabase tipoDatabase, Logger log) throws UtilsException {
        try {
            if (param != null && param.getTipo() != null && IDSerialGeneratorType.ALFANUMERICO.equals((Object)param.getTipo())) {
                throw new UtilsException("IDSerialGeneratorType[" + String.valueOf((Object)param.getTipo()) + "] prevede anche caratteri alfanumerici");
            }
            String sId = this.buildID(param, con, tipoDatabase, log);
            if (sId == null) {
                throw new UtilsException("IDSerialGeneratorType[" + String.valueOf(param != null ? param.getTipo() : "null") + "] build Id failed");
            }
            return Long.parseLong(sId);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buildID(IDSerialGeneratorParameter param, Connection con, TipiDatabase tipoDatabase, Logger log) throws UtilsException {
        if (param == null) {
            throw new UtilsException("IDSerialGeneratorParameter non fornito");
        }
        IDSerialGeneratorType tipo = param.getTipo();
        if (con == null) {
            throw new UtilsException("Connessione non fornita");
        }
        try {
            if (con.isClosed()) {
                throw new UtilsException("Connessione risulta gi\u00e0 chiusa");
            }
        }
        catch (Exception e) {
            throw new UtilsException("Test Connessione non riuscito: " + e.getMessage(), e);
        }
        boolean originalConnectionAutocommit = false;
        boolean autoCommitModificato = false;
        try {
            originalConnectionAutocommit = con.getAutoCommit();
        }
        catch (Exception e) {
            throw new UtilsException("Verifica AutoCommit Connessione non riuscito: " + e.getMessage(), e);
        }
        if (!originalConnectionAutocommit) {
            throw new UtilsException("Creazione serial [" + tipo.name() + "] non riuscita (Non e' possibile fornire una connessione con autocommit disabilitato poiche' l'utility ha necessita' di effettuare operazioni di commit/rollback)");
        }
        int originalConnectionTransactionIsolation = -1;
        boolean transactionIsolationModificato = false;
        try {
            originalConnectionTransactionIsolation = con.getTransactionIsolation();
        }
        catch (Exception e) {
            throw new UtilsException("Lettura livello di isolamento transazione della Connessione non riuscito: " + e.getMessage(), e);
        }
        String identificativoUnivoco = null;
        try {
            if (IDSerialGeneratorType.MYSQL.equals((Object)tipo)) {
                identificativoUnivoco = IDSerialGenerator_mysql.generate(con, param, log, this.infoStatistics);
            } else if (IDSerialGeneratorType.ALFANUMERICO.equals((Object)tipo) || IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo)) {
                try {
                    try {
                        con.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (param.isSerializableLevel()) {
                        JDBCUtilities.setTransactionIsolationSerializable(tipoDatabase, con);
                        transactionIsolationModificato = true;
                    }
                    if (originalConnectionAutocommit) {
                        con.setAutoCommit(false);
                        autoCommitModificato = true;
                    }
                }
                catch (Exception er) {
                    log.error("Creazione serial non riuscita (impostazione transazione): " + er.getMessage(), (Throwable)er);
                    throw new UtilsException("Creazione serial non riuscita (impostazione transazione): " + er.getMessage(), er);
                }
                identificativoUnivoco = IDSerialGeneratorType.NUMERIC.equals((Object)tipo) || IDSerialGeneratorType.DEFAULT.equals((Object)tipo) ? IDSerialGenerator_numeric.generate(con, tipoDatabase, param, log, this.infoStatistics) : IDSerialGenerator_alphanumeric.generate(con, tipoDatabase, param, log, this.infoStatistics);
            } else {
                throw new UtilsException("Tipo di generazione [" + String.valueOf((Object)tipo) + "] non supportata");
            }
            String string = identificativoUnivoco;
            return string;
        }
        finally {
            try {
                if (transactionIsolationModificato) {
                    con.setTransactionIsolation(originalConnectionTransactionIsolation);
                }
                if (autoCommitModificato) {
                    con.setAutoCommit(originalConnectionAutocommit);
                }
            }
            catch (Exception er) {
                log.error("Creazione serial (ripristino transazione): " + er.getMessage());
            }
        }
    }
}

