/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.test;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.id.test.UUIDTest;

class ClientTestThread
implements Runnable {
    private List<String> check = new ArrayList<String>();
    private boolean valoriDuplicati = false;
    private List<String> valoriGenerati = new ArrayList<String>();
    private int index;
    private boolean debug;
    private boolean finished = false;
    private boolean error = false;
    private Exception exception = null;

    private void put(String v, boolean rilevaValoriDuplicati) throws Exception {
        if (!this.check.contains(v)) {
            this.check.add(v);
        } else {
            if (rilevaValoriDuplicati) {
                throw new Exception("Valore [" + v + "] gia generato");
            }
            this.valoriDuplicati = true;
        }
    }

    public List<String> getValoriDistintiGenerati() {
        return this.check;
    }

    public void reset() {
        this.check.clear();
        this.valoriDuplicati = false;
    }

    public int count() {
        return this.check.size();
    }

    public boolean isValoriDuplicati() {
        return this.valoriDuplicati;
    }

    public List<String> getValoriGenerati() {
        return this.valoriGenerati;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ClientTestThread(int index, boolean debug) {
        this.index = index;
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String v = null;
            boolean rilevaValoriDuplicati = true;
            for (int i = 0; i < UUIDTest.ID_GENERATI_PER_THREAD; ++i) {
                if (this.debug && i % 10 == 0) {
                    UUIDTest.log.info("[Thread-" + this.index + "] Generati " + i + " ids");
                }
                v = UniqueIdentifierManager.newUniqueIdentifier().getAsString();
                this.valoriGenerati.add(v);
                this.put(v, rilevaValoriDuplicati);
            }
        }
        catch (Exception e) {
            this.error = true;
            this.exception = e;
        }
        finally {
            this.finished = true;
        }
    }
}

