/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.id.test;

import com.fasterxml.uuid.EthernetAddress;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.id.UniqueIdentifierManager;
import org.openspcoop2.utils.id.UniversallyUniqueIdentifierGenerator;
import org.openspcoop2.utils.id.UniversallyUniqueIdentifierV1Generator;
import org.openspcoop2.utils.id.UniversallyUniqueIdentifierV4Generator;
import org.openspcoop2.utils.id.UniversallyUniqueIdentifierV4GeneratorSecureRandom;
import org.openspcoop2.utils.id.test.ClientTestThread;
import org.slf4j.Logger;

public class UUIDTest {
    private static boolean systemOut = true;
    static int ID_GENERATI_PER_THREAD = 10000;
    static int THREADS = 200;
    static boolean DEBUG = false;
    static Logger log = null;

    public static void main(String[] args) throws Exception {
        String debugParam;
        String numIdsForThread;
        String numThreads;
        if (args != null && args.length > 0 && !"${threads}".equals(numThreads = args[0].trim())) {
            try {
                THREADS = Integer.parseInt(numThreads);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'threads' with wrong format (value:" + numThreads + "): " + e.getMessage(), e);
            }
        }
        if (args != null && args.length > 1 && !"${idsForThread}".equals(numIdsForThread = args[1].trim())) {
            try {
                ID_GENERATI_PER_THREAD = Integer.parseInt(numIdsForThread);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'idsForThread' with wrong format (value:" + numIdsForThread + "): " + e.getMessage(), e);
            }
        }
        if (args != null && args.length > 2 && !"${printDebug}".equals(debugParam = args[2].trim())) {
            try {
                DEBUG = Boolean.parseBoolean(debugParam);
            }
            catch (Exception e) {
                throw new Exception("Parameter 'printDebug' with wrong format (value:" + debugParam + "): " + e.getMessage(), e);
            }
        }
        UUIDTest.test();
    }

    public static void test() throws Exception {
        File logFile = File.createTempFile("runTestUUID_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%m %n");
        log = LoggerWrapperFactory.getLogger(UUIDTest.class);
        DateManager.initializeDataManager(SystemDate.class.getName(), new Properties(), log);
        System.out.println("Threads:" + THREADS);
        System.out.println("Id generati per thread:" + ID_GENERATI_PER_THREAD);
        System.out.println("Debug:" + DEBUG);
        EthernetAddress ethAddrFounded = null;
        Enumeration<NetworkInterface> enumNetworkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (enumNetworkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = enumNetworkInterfaces.nextElement();
            System.out.println("\n============");
            System.out.println("Network: " + networkInterface.getDisplayName());
            if (networkInterface.getHardwareAddress() != null) {
                EthernetAddress ethAddr = new EthernetAddress(networkInterface.getHardwareAddress());
                if (ethAddrFounded == null) {
                    ethAddrFounded = ethAddr;
                }
                System.out.println("ethAddr: " + ethAddr.toString());
            }
            Enumeration<InetAddress> enumInetAddresses = networkInterface.getInetAddresses();
            while (enumInetAddresses.hasMoreElements()) {
                InetAddress inetAddress = enumInetAddresses.nextElement();
                System.out.println("getInetAddresses: " + String.valueOf(inetAddress));
            }
        }
        boolean USE_THREAD_LOCAL = true;
        boolean v4 = true;
        boolean v1 = true;
        if (v4) {
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv4 UUID.randomUUID() (NoThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, !USE_THREAD_LOCAL, UniversallyUniqueIdentifierGenerator.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv4 UUID.randomUUID() (ThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, USE_THREAD_LOCAL, UniversallyUniqueIdentifierGenerator.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv4 com.fasterxml.uuid.impl.RandomBasedGenerator (NoThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, !USE_THREAD_LOCAL, UniversallyUniqueIdentifierV4Generator.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv4 com.fasterxml.uuid.impl.RandomBasedGenerator (ThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, USE_THREAD_LOCAL, UniversallyUniqueIdentifierV4Generator.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv4 com.fasterxml.uuid.impl.RandomBasedGenerator con SecureRandom (NoThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, !USE_THREAD_LOCAL, UniversallyUniqueIdentifierV4GeneratorSecureRandom.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv4 com.fasterxml.uuid.impl.RandomBasedGenerator con SecureRandom (ThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, USE_THREAD_LOCAL, UniversallyUniqueIdentifierV4GeneratorSecureRandom.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
        }
        if (v1) {
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv1 com.fasterxml.uuid.impl.TimeBasedGenerator (NoThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, !USE_THREAD_LOCAL, UniversallyUniqueIdentifierV1Generator.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
            UUIDTest.info(log, systemOut, "\n\n==========================================");
            UUIDTest.info(log, systemOut, "Test UUIDv1 com.fasterxml.uuid.impl.TimeBasedGenerator (ThreadLocal)");
            UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, USE_THREAD_LOCAL, UniversallyUniqueIdentifierV1Generator.class.getName(), new Object[0]);
            UUIDTest.test(THREADS, log, DEBUG);
            if (ethAddrFounded != null) {
                UUIDTest.info(log, systemOut, "\n\n==========================================");
                UUIDTest.info(log, systemOut, "Test UUIDv1 com.fasterxml.uuid.impl.TimeBasedGenerator (NoThreadLocal) con ethernet card '" + ethAddrFounded.toString() + "'");
                UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, !USE_THREAD_LOCAL, UniversallyUniqueIdentifierV1Generator.class.getName(), ethAddrFounded.toString());
                UUIDTest.test(THREADS, log, DEBUG);
                UUIDTest.info(log, systemOut, "\n\n==========================================");
                UUIDTest.info(log, systemOut, "Test UUIDv1 com.fasterxml.uuid.impl.TimeBasedGenerator (ThreadLocal) con ethernet card '" + ethAddrFounded.toString() + "'");
                UniqueIdentifierManager.inizializzaUniqueIdentifierManager(true, USE_THREAD_LOCAL, UniversallyUniqueIdentifierV1Generator.class.getName(), ethAddrFounded.toString());
                UUIDTest.test(THREADS, log, DEBUG);
            }
        }
    }

    private static void info(Logger log, boolean systemOut, String msg) {
        log.info(msg);
        if (systemOut) {
            System.out.println(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test(int threadsNum, Logger log, boolean debug) throws Exception {
        Date inizio = DateManager.getDate();
        ExecutorService threadsPool = Executors.newFixedThreadPool(threadsNum);
        HashMap<CallSite, ClientTestThread> threads = new HashMap<CallSite, ClientTestThread>();
        boolean error = false;
        Exception exception = null;
        try {
            for (int i = 0; i < threadsNum; ++i) {
                ClientTestThread c = new ClientTestThread(i, debug);
                threadsPool.execute(c);
                if (debug) {
                    log.info("Lanciato thread " + i);
                }
                threads.put((CallSite)((Object)("Thread-" + i)), c);
            }
            boolean terminated = false;
            while (!terminated) {
                if (debug) {
                    log.info("Attendo terminazione ...");
                }
                boolean tmpTerminated = true;
                for (int i = 0; i < threadsNum; ++i) {
                    ClientTestThread c = (ClientTestThread)threads.get("Thread-" + i);
                    if (c.isError()) {
                        error = true;
                        exception = c.getException();
                    }
                    if (c.isFinished()) continue;
                    tmpTerminated = false;
                    break;
                }
                if (!tmpTerminated) {
                    Utilities.sleep(250L);
                    continue;
                }
                terminated = true;
            }
        }
        finally {
            log.info("Shutdown pool ...");
            threadsPool.shutdown();
            log.info("Shutdown pool ok");
        }
        Date fine = DateManager.getDate();
        long diff = fine.getTime() - inizio.getTime();
        UUIDTest.info(log, true, "Tempo impiegato: " + Utilities.convertSystemTimeIntoStringMillisecondi(diff, true));
        boolean isDuplicati = false;
        HashSet<String> identificativi = new HashSet<String>();
        for (int i = 0; i < threadsNum; ++i) {
            ClientTestThread c = (ClientTestThread)threads.get("Thread-" + i);
            if (c.getValoriGenerati().size() > 0) {
                log.info("[Thread-" + i + "] ha generato " + c.getValoriGenerati().size() + " id (duplicati: " + c.isValoriDuplicati() + "). Ultimo: " + c.getValoriGenerati().get(c.getValoriGenerati().size() - 1));
                if (c.isValoriDuplicati()) {
                    isDuplicati = true;
                } else {
                    identificativi.addAll(c.getValoriGenerati());
                }
            } else {
                log.info("[Thread-" + i + "] non ha generato id.");
            }
            if (!debug) continue;
            log.info("[Thread-" + i + "] ids generati: " + c.getValoriGenerati().toString());
        }
        int attesi = ID_GENERATI_PER_THREAD * THREADS;
        if (identificativi.size() != attesi) {
            isDuplicati = true;
            log.info("Identificativi generati '" + identificativi.size() + "', attesi '" + attesi + "'");
        }
        UUIDTest.info(log, true, "Duplicati rilevati: " + isDuplicati);
        UUIDTest.info(log, true, "Identificativi distinti complessivi generati: " + identificativi.size());
        if (identificativi.size() > 0) {
            Iterator it = identificativi.iterator();
            for (int index = 0; it.hasNext() && index <= 3; ++index) {
                UUIDTest.info(log, true, "Esempio di un uuid generato: " + (String)it.next());
            }
        }
        if (error) {
            throw new Exception("Error occurs in threads: " + exception.getMessage(), exception);
        }
        if (isDuplicati) {
            throw new Exception("Duplicate ids occurs in threads: " + exception.getMessage(), exception);
        }
    }
}

