/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.io.test;

import java.io.File;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openspcoop2.utils.io.ZipUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class ZipTest {
    public static void main(String[] args) throws Exception {
        ZipTest.test();
    }

    public static void test() throws Exception {
        ZipEntry zipEntry;
        String contenuto = "Hello World";
        byte[] test = ZipUtilities.zip(contenuto.getBytes(), "prova");
        File f = File.createTempFile("test", ".zip");
        FileSystemUtilities.writeFile(f, test);
        System.out.println("Zip File scritto in [" + f.getAbsolutePath() + "]");
        byte[] zipCompress = FileSystemUtilities.readBytesFromFile(f);
        byte[] decompress = ZipUtilities.unzip(zipCompress);
        String letto = new String(decompress);
        System.out.println("SCRITTO [\t" + contenuto + "]");
        System.out.println("LETTO   [" + letto + "]");
        if (!letto.equals(contenuto)) {
            System.out.println("DIVERSO");
            throw new Exception("Diverso!");
        }
        System.out.println("UGUALI");
        ZipFile zipFile = new ZipFile(new File(ZipTest.class.getResource("/org/openspcoop2/utils/io/test.zip").toURI()));
        System.out.println("=============================================");
        Enumeration<? extends ZipEntry> en = zipFile.entries();
        while (en.hasMoreElements()) {
            ZipEntry zipEntry2 = en.nextElement();
            System.out.println("- " + zipEntry2.getName());
        }
        System.out.println("\n\n\n============= ASC ================================");
        Iterator<ZipEntry> it = ZipUtilities.entries(zipFile, true);
        while (it.hasNext()) {
            zipEntry = it.next();
            System.out.println("- " + zipEntry.getName());
        }
        System.out.println("\n\n\n============= DESC ================================");
        it = ZipUtilities.entries(zipFile, false);
        while (it.hasNext()) {
            zipEntry = it.next();
            System.out.println("- " + zipEntry.getName());
        }
    }
}

