/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jaxrs;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.ParamConverter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JodaDateTimeConverter
implements ParamConverter<DateTime> {
    private static final Logger log = LoggerFactory.getLogger(JodaDateTimeConverter.class);
    private DateTimeZone timeZone = null;

    public JodaDateTimeConverter(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public DateTime fromString(String date) {
        try {
            DateTimeFormatter formatter = ISODateTimeFormat.dateOptionalTimeParser().withZone(this.timeZone);
            return formatter.parseDateTime(date);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new WebApplicationException("Converter org.joda.time.DateTime to String failed: " + String.valueOf(ex), (Throwable)ex, 400);
        }
    }

    public String toString(DateTime t) {
        try {
            DateTimeFormatter formatter = ISODateTimeFormat.dateOptionalTimeParser().withZone(this.timeZone);
            return formatter.print((ReadableInstant)t);
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new WebApplicationException("Converter org.joda.time.DateTime to String failed: " + String.valueOf(ex), (Throwable)ex, 400);
        }
    }
}

