/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.jdbc.test;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.date.SystemDate;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.resources.ClassLoaderUtilities;
import org.slf4j.Logger;

public class KeyGeneratorTest {
    private static boolean systemOut = true;
    private static Logger log = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String driverJdbcCustom;
        String passwordCustom;
        String usernameCustom;
        String urlCustom;
        File logFile = File.createTempFile("runKeyGeneratorTest_", ".log");
        System.out.println("LogMessages write in " + logFile.getAbsolutePath());
        LoggerWrapperFactory.setDefaultLogConfiguration(Level.ALL, false, null, logFile, "%m %n");
        log = LoggerWrapperFactory.getLogger(KeyGeneratorTest.class);
        DateManager.initializeDataManager(SystemDate.class.getName(), new Properties(), log);
        String url = null;
        String driver = null;
        String userName = null;
        String password = null;
        TipiDatabase tipoDatabase = TipiDatabase.toEnumConstant(args[0].trim());
        CustomKeyGeneratorObject keyGeneratorObject = null;
        switch (tipoDatabase) {
            case POSTGRESQL: {
                url = "jdbc:postgresql://localhost/prova";
                driver = "org.postgresql.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                keyGeneratorObject = new CustomKeyGeneratorObject("prova", "id", "seq_prova", "prova_init_seq");
                break;
            }
            case MYSQL: {
                url = "jdbc:mysql://localhost/prova";
                driver = "com.mysql.jdbc.Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                keyGeneratorObject = new CustomKeyGeneratorObject("prova", "id", "seq_prova", "prova_init_seq");
                break;
            }
            case ORACLE: {
                url = "jdbc:oracle:thin:@localhost:1521:XE";
                driver = "oracle.jdbc.OracleDriver";
                userName = "prova";
                password = "prova";
                keyGeneratorObject = new CustomKeyGeneratorObject("prova", "id", "seq_prova", "prova_init_seq");
                break;
            }
            case HSQL: {
                url = "jdbc:hsqldb:hsql://localhost:9001/";
                driver = "org.hsqldb.jdbcDriver";
                userName = "sa";
                password = "";
                keyGeneratorObject = new CustomKeyGeneratorObject("prova", "id", "seq_prova", "prova_init_seq");
                break;
            }
            case SQLSERVER: {
                url = "jdbc:sqlserver://localhost:1433;databaseName=prova";
                driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
                userName = "openspcoop2";
                password = "openspcoop2";
                keyGeneratorObject = new CustomKeyGeneratorObject("prova", "id", "seq_prova", "prova_init_seq");
                break;
            }
            case DB2: {
                url = "jdbc:db2://127.0.0.1:50000/prova";
                driver = "com.ibm.db2.jcc.DB2Driver";
                userName = "openspcoop2";
                password = "openspcoop2";
                keyGeneratorObject = new CustomKeyGeneratorObject("prova", "id", "seq_prova", "prova_init_seq");
                break;
            }
        }
        if (args.length > 1 && !"${url}".equals(urlCustom = args[1].trim())) {
            url = urlCustom;
        }
        if (args.length > 2 && !"${username}".equals(usernameCustom = args[2].trim())) {
            userName = usernameCustom;
        }
        if (args.length > 3 && !"${password}".equals(passwordCustom = args[3].trim())) {
            password = passwordCustom;
        }
        if (args.length > 4 && !"${driverJdbc}".equals(driverJdbcCustom = args[4].trim())) {
            driver = driverJdbcCustom;
        }
        System.out.println("URL:" + url);
        System.out.println("UserName:" + userName);
        System.out.println("Password:" + password);
        System.out.println("DriverJDBC:" + driver);
        ClassLoaderUtilities.newInstance(driver);
        Connection con = null;
        Statement stmtDelete = null;
        Statement stmtQuery = null;
        ResultSet rsQuery = null;
        try {
            con = DriverManager.getConnection(url, userName, password);
            String delete = "delete from prova";
            stmtDelete = con.createStatement();
            stmtDelete.execute(delete);
            long id1 = InsertAndGeneratedKey.insertAndReturnGeneratedKey(con, tipoDatabase, keyGeneratorObject, new InsertAndGeneratedKeyObject("descrizione", "esempio1", InsertAndGeneratedKeyJDBCType.STRING));
            if (id1 <= 0L) {
                throw new Exception("Prima insert non effettuata?? Return id is [" + id1 + "]");
            }
            long id2 = InsertAndGeneratedKey.insertAndReturnGeneratedKey(con, tipoDatabase, keyGeneratorObject, new InsertAndGeneratedKeyObject("descrizione", "esempio2", InsertAndGeneratedKeyJDBCType.STRING));
            if (id2 <= 0L) {
                throw new Exception("Seconda insert non effettuata?? Return id is [" + id2 + "]");
            }
            if (id1 == id2) {
                throw new Exception("Successive insert hanno prodotto lo stesso primary key id?? [" + id1 + "]");
            }
            String count = "select count(*) from prova";
            stmtQuery = con.createStatement();
            rsQuery = stmtQuery.executeQuery(count);
            if (rsQuery.next()) {
                long conteggio = rsQuery.getLong(1);
                if (conteggio != 2L) {
                    throw new Exception("Risultato (" + conteggio + ") differente da quello atteso (2)");
                }
            } else {
                throw new Exception("Nessuna insert effettuata");
            }
            KeyGeneratorTest.info(log, systemOut, "Test effettuato correttamente (id generati: first[" + id1 + "] second[" + id2 + "])");
        }
        finally {
            try {
                stmtDelete.close();
            }
            catch (Exception exception) {}
            try {
                rsQuery.close();
            }
            catch (Exception exception) {}
            try {
                stmtQuery.close();
            }
            catch (Exception exception) {}
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void info(Logger log, boolean systemOut, String msg) {
        log.info(msg);
        if (systemOut) {
            System.out.println(msg);
        }
    }
}

