/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.json;

import java.io.InputStream;
import java.util.Properties;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.slf4j.Logger;
import org.yaml.snakeyaml.LoaderOptions;

public class YamlSnakeLimits {
    private static boolean DEBUG = false;
    private static Logger log = LoggerWrapperFactory.getLogger(YamlSnakeLimits.class);
    private static boolean initialized = false;

    public static boolean isDEBUG() {
        return DEBUG;
    }

    public static void setDEBUG(boolean dEBUG) {
        DEBUG = dEBUG;
    }

    public static void initialize() {
        YamlSnakeLimits._initialize();
    }

    private static synchronized void _initialize() {
        if (!initialized) {
            try (InputStream is = YamlSnakeLimits.class.getResourceAsStream("/org/openspcoop2/utils/json/yamlSnakeLimits.properties");){
                Properties p = new Properties();
                p.load(is);
                YamlSnakeLimits.initialize(log, p);
            }
            catch (Throwable t) {
                log.error(t.getMessage(), t);
            }
            initialized = true;
        }
    }

    public static void initialize(Logger logger, Properties p) {
        if (p != null) {
            int v;
            String tmp;
            String pName = "allowDuplicateKeys";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Boolean.parseBoolean(tmp);
                    LoaderOptions.getDefaultValues().setAllowDuplicateKeys(v != 0);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isAllowDuplicateKeys());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isAllowDuplicateKeys());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            pName = "wrappedToRootException";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Boolean.parseBoolean(tmp);
                    LoaderOptions.getDefaultValues().setWrappedToRootException(v != 0);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isWrappedToRootException());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isWrappedToRootException());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            pName = "maxAliasesForCollections";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Integer.valueOf(tmp);
                    LoaderOptions.getDefaultValues().setMaxAliasesForCollections(v);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().getMaxAliasesForCollections());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().getMaxAliasesForCollections());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            pName = "allowRecursiveKeys";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Boolean.parseBoolean(tmp) ? 1 : 0;
                    LoaderOptions.getDefaultValues().setAllowRecursiveKeys(v != 0);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isAllowRecursiveKeys());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isAllowRecursiveKeys());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            pName = "processComments";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Boolean.parseBoolean(tmp);
                    LoaderOptions.getDefaultValues().setProcessComments(v != 0);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isProcessComments());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isProcessComments());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            pName = "enumCaseSensitive";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Boolean.parseBoolean(tmp);
                    LoaderOptions.getDefaultValues().setEnumCaseSensitive(v != 0);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isEnumCaseSensitive());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().isEnumCaseSensitive());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            pName = "nestingDepthLimit";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Integer.valueOf(tmp);
                    LoaderOptions.getDefaultValues().setNestingDepthLimit(v);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().getNestingDepthLimit());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().getNestingDepthLimit());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            pName = "codePointLimit";
            try {
                tmp = p.getProperty(pName);
                if (tmp != null) {
                    tmp = tmp.trim();
                    v = Integer.valueOf(tmp);
                    LoaderOptions.getDefaultValues().setCodePointLimit(v);
                    logger.info("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().getCodePointLimit());
                    if (DEBUG) {
                        System.out.println("[YamlSnakeLimits] " + pName + "=" + LoaderOptions.getDefaultValues().getCodePointLimit());
                    }
                }
            }
            catch (Throwable t) {
                logger.error("[" + pName + "] Invalid limit value: " + t.getMessage(), t);
            }
            initialized = true;
        }
    }
}

