/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.logger;

import java.lang.reflect.Constructor;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.logger.IContext;
import org.openspcoop2.utils.logger.ILogger;

public class LoggerFactory {
    private static Class<ILogger> loggerImpl = null;
    private static Object[] parameters = null;
    private static Class<?>[] parameterTypes = null;

    public static void initialize(String implementationClassName, Object ... pars) throws UtilsException, ClassNotFoundException {
        Class<ILogger> c = Class.forName(implementationClassName);
        LoggerFactory.initialize(c, pars);
    }

    public static void initialize(Class<ILogger> implementationClass, Object ... pars) throws UtilsException {
        try {
            loggerImpl = implementationClass;
            parameters = pars;
            if (parameters != null) {
                parameterTypes = new Class[parameters.length];
                for (int i = 0; i < parameters.length; ++i) {
                    LoggerFactory.parameterTypes[i] = parameters[i].getClass();
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Expected class assignable from " + ILogger.class.getName() + ". Found: " + implementationClass.getName() + " . Error: " + e.getMessage(), e);
        }
    }

    public static ILogger newLogger() throws UtilsException {
        return LoggerFactory._newLogger(null);
    }

    public static ILogger newLogger(IContext context) throws UtilsException {
        return LoggerFactory._newLogger(context);
    }

    private static ILogger _newLogger(IContext context) throws UtilsException {
        if (loggerImpl == null) {
            throw new UtilsException("LoggerFactory not Initialized");
        }
        try {
            Constructor<ILogger> c = loggerImpl.getConstructor(parameterTypes);
            ILogger logger = c.newInstance(parameters);
            if (context != null) {
                logger.initLogger(context);
            } else {
                logger.initLogger();
            }
            return logger;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public static ILogger newLogger(String implementationClassName) throws UtilsException {
        return LoggerFactory._newLogger(implementationClassName, null);
    }

    public static ILogger newLogger(String implementationClassName, IContext context) throws UtilsException {
        return LoggerFactory._newLogger(implementationClassName, context);
    }

    private static ILogger _newLogger(String implementationClassName, IContext context) throws UtilsException {
        Class<?> c = null;
        try {
            c = Class.forName(implementationClassName);
        }
        catch (Exception e) {
            throw new UtilsException("Expected class assignable from " + ILogger.class.getName() + ". Found: " + implementationClassName + " . Error: " + e.getMessage(), e);
        }
        return LoggerFactory._newLogger(c, context);
    }

    public static ILogger newLogger(Class<? extends ILogger> implementationClass) throws UtilsException {
        return LoggerFactory._newLogger(implementationClass, null);
    }

    public static ILogger newLogger(Class<? extends ILogger> implementationClass, IContext context) throws UtilsException {
        return LoggerFactory._newLogger(implementationClass, context);
    }

    private static ILogger _newLogger(Class<? extends ILogger> implementationClass, IContext context) throws UtilsException {
        try {
            Constructor<? extends ILogger> c = implementationClass.getConstructor(parameterTypes);
            ILogger logger = c.newInstance(parameters);
            if (context != null) {
                logger.initLogger(context);
            } else {
                logger.initLogger();
            }
            return logger;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

