/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.logger.test;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.logger.IContext;
import org.openspcoop2.utils.logger.ILogger;
import org.openspcoop2.utils.logger.LoggerFactory;
import org.openspcoop2.utils.logger.beans.Attachment;
import org.openspcoop2.utils.logger.beans.Event;
import org.openspcoop2.utils.logger.beans.Message;
import org.openspcoop2.utils.logger.beans.Property;
import org.openspcoop2.utils.logger.beans.context.application.ApplicationContext;
import org.openspcoop2.utils.logger.beans.context.application.ApplicationTransaction;
import org.openspcoop2.utils.logger.beans.context.batch.BatchContext;
import org.openspcoop2.utils.logger.beans.context.batch.BatchTransaction;
import org.openspcoop2.utils.logger.beans.context.core.AbstractContext;
import org.openspcoop2.utils.logger.beans.context.core.AbstractContextWithClient;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransaction;
import org.openspcoop2.utils.logger.beans.context.core.AbstractTransactionWithClient;
import org.openspcoop2.utils.logger.beans.context.core.Actor;
import org.openspcoop2.utils.logger.beans.context.core.ConnectionMessage;
import org.openspcoop2.utils.logger.beans.context.core.HttpClient;
import org.openspcoop2.utils.logger.beans.context.core.HttpServer;
import org.openspcoop2.utils.logger.beans.context.core.Identifier;
import org.openspcoop2.utils.logger.beans.context.core.Operation;
import org.openspcoop2.utils.logger.beans.context.core.Role;
import org.openspcoop2.utils.logger.beans.context.core.Service;
import org.openspcoop2.utils.logger.beans.context.proxy.ProxyContext;
import org.openspcoop2.utils.logger.beans.context.proxy.ProxyTransaction;
import org.openspcoop2.utils.logger.config.DiagnosticConfig;
import org.openspcoop2.utils.logger.config.Log4jConfig;
import org.openspcoop2.utils.logger.config.MultiLoggerConfig;
import org.openspcoop2.utils.logger.constants.LowSeverity;
import org.openspcoop2.utils.logger.constants.MessageType;
import org.openspcoop2.utils.logger.constants.Severity;
import org.openspcoop2.utils.logger.constants.context.FlowMode;
import org.openspcoop2.utils.logger.constants.context.Result;
import org.openspcoop2.utils.logger.constants.context.ServerEndpointType;
import org.openspcoop2.utils.logger.log4j.Log4JLoggerWithBatchContext;
import org.openspcoop2.utils.logger.log4j.Log4JLoggerWithProxyContext;
import org.openspcoop2.utils.logger.log4j.Log4jLoggerWithApplicationContext;
import org.openspcoop2.utils.logger.test.Contenitore;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;

public class Test {
    public static void main(String[] args) throws Exception {
        String tipo = null;
        if (args != null && args.length > 0) {
            tipo = args[0];
        }
        DiagnosticConfig diagnosticConfig = new DiagnosticConfig();
        diagnosticConfig.setDiagnosticConfigURL(Test.class.getResource("/org/openspcoop2/utils/logger/test/example.msgDiagnostici.properties"));
        diagnosticConfig.setThrowExceptionPlaceholderFailedResolution(true);
        Log4jConfig log4jConfig = new Log4jConfig();
        boolean exampleWithProperties = true;
        if (exampleWithProperties) {
            log4jConfig.setLog4jConfigURL(Test.class.getResource("/org/openspcoop2/utils/logger/test/example.log4j2.properties"));
        } else {
            log4jConfig.setLog4jConfigURL(Test.class.getResource("/org/openspcoop2/utils/logger/test/example.log4j2.xml"));
        }
        MultiLoggerConfig mConfig = new MultiLoggerConfig();
        mConfig.setDiagnosticConfig(diagnosticConfig);
        mConfig.setDiagnosticSeverityFilter(Severity.DEBUG_HIGH);
        mConfig.setLog4jLoggerEnabled(true);
        mConfig.setLog4jConfig(log4jConfig);
        mConfig.setDbLoggerEnabled(false);
        if (tipo == null || "proxy".equalsIgnoreCase(tipo)) {
            System.out.println("*** Test Proxy ***");
            LoggerFactory.initialize(Log4JLoggerWithProxyContext.class.getName(), mConfig);
            Test.test(LoggerFactory.newLogger(), "PROXY");
        }
        if (tipo == null || "application".equalsIgnoreCase(tipo)) {
            System.out.println("*** Test Application ***");
            Test.test(LoggerFactory.newLogger(Log4jLoggerWithApplicationContext.class.getName()), "APPLICATION");
        }
        if (tipo == null || "batch".equalsIgnoreCase(tipo)) {
            System.out.println("*** Test Batch ***");
            Test.test(LoggerFactory.newLogger(Log4JLoggerWithBatchContext.class), "BATCH");
        }
    }

    private static void test(ILogger logger, String tipo) throws Exception {
        logger.log("================= " + tipo + " ===================", LowSeverity.DEBUG_HIGH);
        logger.log("Prova altro log con messaggio inserito qua", LowSeverity.DEBUG_HIGH);
        logger.log("Prova altro log con messaggio inserito qua con function", LowSeverity.DEBUG_MEDIUM, "core");
        logger.log("000002");
        logger.log("core.inizializzazione");
        logger.log("001001", "21 Ottobre 2015", "GovPay");
        IContext context = logger.getContext();
        AbstractTransaction transaction = ((AbstractContext)context).getTransaction();
        AbstractTransactionWithClient transactionWithClient = null;
        AbstractContextWithClient contextWithClient = null;
        ProxyContext proxyContext = null;
        if (context instanceof ProxyContext) {
            proxyContext = (ProxyContext)context;
            transactionWithClient = (AbstractTransactionWithClient)transaction;
            contextWithClient = (AbstractContextWithClient)context;
        }
        ApplicationContext applicationContext = null;
        if (context instanceof ApplicationContext) {
            applicationContext = (ApplicationContext)context;
            transactionWithClient = (AbstractTransactionWithClient)transaction;
            contextWithClient = (AbstractContextWithClient)context;
        }
        BatchContext batchContext = null;
        if (context instanceof BatchContext) {
            batchContext = (BatchContext)context;
        }
        transaction.setClusterId("Cluster1-TIPO-" + tipo);
        logger.log("000003", transaction);
        try {
            Attachment att;
            Property header2;
            Property header1;
            byte[] content;
            boolean dump;
            long httpRequestSize = 2345L;
            if (contextWithClient != null) {
                contextWithClient.getRequest().setDate(new Date());
                contextWithClient.getRequest().setSize(httpRequestSize);
            }
            if (dump = true) {
                byte[] content2 = "<prova>CIAO</PROVA>".getBytes();
                Message message = new Message();
                message.setIdMessage("TIPO-" + tipo);
                message.setType(MessageType.REQUEST_IN);
                message.setContent(content2);
                message.setContentType("text/xml");
                Property header12 = new Property("Transfer-Encoding", "Chunked");
                message.addHeader(header12);
                Property header22 = new Property("WebClient", "Firefox");
                message.addHeader(header22);
                Property xpath1 = new Property("RisorsaNome", "Rossi");
                message.addResource(xpath1);
                Attachment att2 = new Attachment();
                att2.setContent("HELLO WORLD".getBytes());
                att2.setContentType("text/plain");
                att2.setContentId("cid:XXX");
                message.addAttachment(att2);
                logger.log(message);
            }
            HttpClient client = null;
            if (transactionWithClient != null) {
                client = new HttpClient();
                client.setPrincipal("C=IT,O=ComuneRoma");
                client.setName("ServizioApplicativoAutenticato");
                transactionWithClient.setClient(client);
            }
            if (transactionWithClient != null) {
                transactionWithClient.getClient().setInvocationEndpoint("/govway/out/NomePortaDelegta?prova=si");
                transactionWithClient.getClient().setInterfaceName("NomePortaDelegata");
            }
            transaction.setDomain("GovPayFunction");
            transaction.setRole(Role.CLIENT);
            Actor from = new Actor();
            from.setType("SPC");
            from.setName("MinisteroFruitore");
            from.setAddress("http://pddMinisteroFruitore");
            transaction.setFrom(from);
            Actor to = new Actor();
            to.setType("SPC");
            to.setName("MinisteroErogatore");
            to.setAddress("http://pddMinisteroErogatore");
            transaction.setTo(to);
            Service service = new Service();
            service.setType("SPC");
            service.setName("VariazioneAnagrafica");
            service.setVersion(1);
            transaction.setService(service);
            Operation operation = new Operation();
            operation.setName("aggiornamento");
            operation.setMode(FlowMode.INPUT_OUTPUT);
            transaction.setOperation(operation);
            Identifier idRequest = null;
            if (contextWithClient != null) {
                logger.log("001002");
                idRequest = new Identifier();
                idRequest.setId("Prova_238231232_3232");
                contextWithClient.getRequest().setIdentifier(idRequest);
                contextWithClient.getRequest().setCorrelationIdentifier("ID_CORRELAZIONE_APPLICATIVA");
                Property p1 = new Property("Prova", "TestProva");
                Property p2 = new Property("Prova2", "TestProva2");
                Property p3 = new Property("Prova3", "TestProva3");
                contextWithClient.getRequest().addGenericProperty(p1);
                contextWithClient.getRequest().addGenericProperty(p2);
                contextWithClient.getRequest().addGenericProperty(p3);
                logger.log("002001");
            }
            Contenitore c = new Contenitore();
            ArrayList<String> listPrimitive = new ArrayList<String>();
            listPrimitive.add("EsempioListPrimitiveValue1");
            listPrimitive.add("EsempioListPrimitiveValue2");
            c.setListPrimitive(listPrimitive);
            ArrayList<Property> listProperty = new ArrayList<Property>();
            Property p1 = new Property("Prova", "TestProva");
            Property p2 = new Property("Prova2", "TestProva2");
            Property p3 = new Property("Prova3", "TestProva3");
            listProperty.add(p1);
            listProperty.add(p2);
            listProperty.add(p3);
            c.setListProperty(listProperty);
            Integer[] arrayPrimitive = new Integer[]{11, 22, 33};
            c.setArrayPrimitive(arrayPrimitive);
            Property[] arrayProperty = new Property[]{p1, p2, p3};
            c.setArrayProperty(arrayProperty);
            HashMap<String, Long> mapPrimitive = new HashMap<String, Long>();
            mapPrimitive.put("K1", 555L);
            mapPrimitive.put("K2", 666L);
            mapPrimitive.put("K3", 777L);
            c.setMapPrimitive(mapPrimitive);
            HashMap<String, Property> mapProperty = new HashMap<String, Property>();
            mapProperty.put("K1", p1);
            mapProperty.put("K2", p2);
            mapProperty.put("K3", p3);
            c.setMapProperty(mapProperty);
            logger.log("002002", c);
            logger.log("002003", c);
            logger.log("002004", c);
            ArrayList<String> servers = new ArrayList<String>();
            if (proxyContext != null) {
                servers.add("ApplicativoServer");
            } else {
                servers.add("ApplicativoServer1");
                servers.add("ApplicativoServer2");
            }
            for (String serverName : servers) {
                String idOperation = "OperationXX";
                if (dump) {
                    content = "<prova>CIAO</PROVA>".getBytes();
                    Message message = new Message();
                    message.setType(MessageType.REQUEST_OUT);
                    message.setContent(content);
                    message.setContentType("text/xml");
                    message.setIdServer(serverName);
                    message.setIdOperation(idOperation);
                    if (idRequest != null) {
                        message.setIdMessage(idRequest.getId());
                    }
                    header1 = new Property("Transfer-Encoding", "Chunked");
                    message.addHeader(header1);
                    header2 = new Property("WebClient", "Firefox");
                    message.addHeader(header2);
                    Property xpath1 = new Property("RisorsaNome", "Rossi");
                    message.addResource(xpath1);
                    att = new Attachment();
                    att.setContent("HELLO WORLD".getBytes());
                    att.setContentType("text/plain");
                    att.setContentId("cid:XXX");
                    message.addAttachment(att);
                    logger.log(message);
                }
                HttpServer server = new HttpServer();
                server.setEndpoint("http://127.0.0.1:8080/server");
                server.setEndpointType(ServerEndpointType.HTTP.name());
                server.setName(serverName);
                server.setIdOperation(idOperation);
                if (proxyContext != null) {
                    ((ProxyTransaction)transaction).setServer(server);
                } else if (applicationContext != null) {
                    ((ApplicationTransaction)transaction).addServer(server);
                } else if (batchContext != null) {
                    ((BatchTransaction)transaction).addServer(server);
                }
                if (proxyContext != null) {
                    logger.log("003001");
                } else if (applicationContext != null) {
                    logger.log("003011", server);
                } else {
                    logger.log("003021", server);
                }
                long httpRequestModifySize = 231232L;
                ConnectionMessage requestConnection = new ConnectionMessage();
                requestConnection.setDate(new Date());
                requestConnection.setSize(httpRequestModifySize);
                requestConnection.setIdMessage("ID-SERVER-REQ");
                server.setRequest(requestConnection);
                int returnCode = 500;
                server.setResponseStatusCode(returnCode);
                server.setTransportRequestMethod(HttpRequestMethod.POST);
                if (returnCode == 200) {
                    if (proxyContext != null) {
                        logger.log("003002");
                    } else if (applicationContext != null) {
                        logger.log("003012", server);
                    } else {
                        logger.log("003022", server);
                    }
                } else if (proxyContext != null) {
                    logger.log("003003");
                } else if (applicationContext != null) {
                    logger.log("003013", server);
                } else {
                    logger.log("003023", server);
                }
                ConnectionMessage responseConnection = new ConnectionMessage();
                responseConnection.setDate(new Date());
                responseConnection.setSize(httpRequestSize);
                responseConnection.setIdMessage("ID-SERVER-RESP");
                server.setResponse(responseConnection);
                if (dump) {
                    byte[] content3 = "<prova>CIAO</PROVA>".getBytes();
                    Message message = new Message();
                    message.setType(MessageType.RESPONSE_IN);
                    message.setContent(content3);
                    message.setContentType("text/xml");
                    message.setIdServer(serverName);
                    message.setIdOperation(idOperation);
                    Property header13 = new Property("Transfer-Encoding", "Chunked");
                    message.addHeader(header13);
                    Property header23 = new Property("WebClient", "Firefox");
                    message.addHeader(header23);
                    Property xpath1 = new Property("RisorsaNome", "Rossi");
                    message.addResource(xpath1);
                    Attachment att3 = new Attachment();
                    att3.setContent("HELLO WORLD".getBytes());
                    att3.setContentType("text/plain");
                    att3.setContentId("cid:XXX");
                    message.addAttachment(att3);
                    logger.log(message);
                }
                Property pServer1 = new Property("Prova-" + serverName, "TestProva" + serverName);
                Property pServer2 = new Property("Prova2" + serverName, "TestProva2" + serverName);
                Property pServer3 = new Property("Prova3", "TestProva3" + serverName);
                server.addGenericProperty(pServer1);
                server.addGenericProperty(pServer2);
                server.addGenericProperty(pServer3);
            }
            if (proxyContext != null) {
                logger.log("003004");
            } else if (applicationContext != null) {
                logger.log("003014");
            } else {
                logger.log("003024");
            }
            boolean fault = true;
            Identifier idResponse = null;
            if (contextWithClient != null) {
                idResponse = new Identifier();
                idResponse.setId("ProvaResponse_238231232_3232");
                contextWithClient.getResponse().setIdentifier(idResponse);
                contextWithClient.getResponse().setCorrelationIdentifier("ID_CORRELAZIONE_APPLICATIVA_RISP");
                int returnCodeClient = 200;
                if (fault) {
                    returnCodeClient = 500;
                }
                if (dump) {
                    content = "<prova>CIAO</PROVA>".getBytes();
                    Message message = new Message();
                    message.setType(MessageType.RESPONSE_OUT);
                    message.setContent(content);
                    message.setContentType("text/xml");
                    header1 = new Property("Transfer-Encoding", "Chunked");
                    message.addHeader(header1);
                    header2 = new Property("WebClient", "Firefox");
                    message.addHeader(header2);
                    Property xpath1 = new Property("RisorsaNome", "Rossi");
                    message.addResource(xpath1);
                    att = new Attachment();
                    att.setContent("HELLO WORLD".getBytes());
                    att.setContentType("text/plain");
                    att.setContentId("cid:XXX");
                    message.addAttachment(att);
                    logger.log(message);
                }
                if (fault) {
                    byte[] faultRicevuto = null;
                    contextWithClient.getResponse().setFault(faultRicevuto);
                }
                ((HttpClient)transactionWithClient.getClient()).setResponseStatusCode(returnCodeClient);
                ((HttpClient)transactionWithClient.getClient()).setTransportRequestMethod(HttpRequestMethod.POST);
                ((HttpClient)transactionWithClient.getClient()).setSocketClientAddress("127.0.0.1");
                ((HttpClient)transactionWithClient.getClient()).setTransportClientAddress("10.0.0.1");
                transactionWithClient.getClient().addGenericProperty(p1);
                transactionWithClient.getClient().addGenericProperty(p2);
                transactionWithClient.getClient().addGenericProperty(p3);
            }
            if (fault) {
                transaction.setResult(Result.SERVER_ERROR);
            } else {
                transaction.setResult(Result.SUCCESS);
            }
            if (contextWithClient != null) {
                if (fault) {
                    logger.log("001004");
                } else {
                    logger.log("001003");
                }
                contextWithClient.getResponse().setDate(new Date());
                contextWithClient.getResponse().setSize(httpRequestSize);
            }
            logger.log();
            Event event = new Event();
            event.setDate(DateManager.getDate());
            event.setClusterId("ClusteId-TIPO-" + tipo);
            event.setCode("XXX");
            event.setSource("ModuloControllo");
            event.setSeverity(Severity.ERROR);
            logger.log(event);
        }
        catch (Exception e) {
            logger.log("000001", e.getMessage() != null ? e.getMessage() : "NullPointer");
            e.printStackTrace(System.out);
        }
    }
}

