/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.mail;

import org.openspcoop2.utils.mime.MimeTypes;
import org.slf4j.Logger;

public abstract class MailAttach {
    private String name;
    private String contentType;

    protected MailAttach(String name, String contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContentType(Logger log) {
        if (this.contentType != null) {
            return this.contentType;
        }
        MimeTypes mimeTypes = null;
        try {
            mimeTypes = MimeTypes.getInstance();
            if (this.name != null && this.name.contains(".")) {
                String ext = this.name.substring(this.name.lastIndexOf(46) + 1, this.name.length());
                return mimeTypes.getMimeType(ext);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (mimeTypes != null) {
            return mimeTypes.getMimeType("bin");
        }
        return "application/octet-stream";
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

