/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.oauth2;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.Properties;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.oauth2.OAuth2Token;
import org.openspcoop2.utils.oauth2.OAuth2Utilities;
import org.openspcoop2.utils.oauth2.Oauth2BaseResponse;
import org.openspcoop2.utils.oauth2.Oauth2UserInfo;
import org.openspcoop2.utils.transport.http.credential.IPrincipalReader;
import org.openspcoop2.utils.transport.http.credential.PrincipalReaderException;
import org.slf4j.Logger;

public class OAuth2PrincipalReader
implements IPrincipalReader {
    private transient Logger log = null;
    private Properties properties = null;
    private static final long serialVersionUID = 1L;

    public OAuth2PrincipalReader(Logger log) {
        this.log = log;
        this.log.debug("OAuth2PrincipalReader inizializzato.");
    }

    @Override
    public String getPrincipal(HttpServletRequest request) throws PrincipalReaderException {
        boolean loggedIn;
        this.log.debug("Estrazione principal in corso...");
        HttpSession session = request.getSession(false);
        String principalClaim = this.properties.getProperty("oauth2.principalClaim");
        boolean bl = loggedIn = session != null && session.getAttribute("oauth2UserInfo") != null;
        if (loggedIn) {
            Oauth2UserInfo userInfo = (Oauth2UserInfo)session.getAttribute("oauth2UserInfo");
            String principal = (String)((Object)userInfo.getMap().get(principalClaim));
            if (principal == null) {
                this.log.warn("Principal claim [{}] non trovato in userInfo: {}", (Object)principalClaim, userInfo.getMap());
                return null;
            }
            Long expiresAt = (Long)session.getAttribute("oauthExpiresAt");
            String refreshToken = (String)session.getAttribute("oauthRefreshToken");
            if (expiresAt == null || expiresAt < DateManager.getTimeMillis()) {
                this.log.debug("Username collegato: [{}]", (Object)principal);
                return principal;
            }
            if (refreshToken == null) {
                this.log.warn("Token scaduto e non \u00e8 disponibile un refresh token. L'utente deve effettuare nuovamente il login.");
                request.setAttribute("oauth2ErrorCode", (Object)"access_denied");
                request.setAttribute("oauth2ErrorDetail", (Object)"Token scaduto e non disponibile un refresh token.");
                return null;
            }
            OAuth2Token oAuth2Token = this.refreshToken(request, refreshToken);
            Oauth2BaseResponse jwksResponse = OAuth2Utilities.getCertificati(this.log, this.properties);
            if (jwksResponse.getReturnCode() != 200) {
                request.setAttribute("oauth2ErrorCode", (Object)jwksResponse.getError());
                request.setAttribute("oauth2ErrorDetail", (Object)jwksResponse.getDescription());
                return null;
            }
            boolean valida = OAuth2Utilities.isValidToken(this.log, this.properties, jwksResponse, oAuth2Token);
            if (!valida) {
                OAuth2PrincipalReader.logError(this.log, "Token ricevuto non valido");
                request.setAttribute("oauth2ErrorCode", (Object)"Token ricevuto non valido");
                request.setAttribute("oauth2ErrorDetail", (Object)"Token ricevuto non valido");
                return null;
            }
            Oauth2UserInfo oauth2UserInfo = OAuth2Utilities.getUserInfo(this.log, this.properties, oAuth2Token);
            if (oauth2UserInfo.getReturnCode() != 200) {
                request.setAttribute("oauth2ErrorCode", (Object)oauth2UserInfo.getError());
                request.setAttribute("oauth2ErrorDetail", (Object)oauth2UserInfo.getDescription());
                return null;
            }
            session.setAttribute("oauthAccessToken", (Object)oAuth2Token.getAccessToken());
            session.setAttribute("oauthIdToken", (Object)oAuth2Token.getIdToken());
            session.setAttribute("oauthTokenObj", (Object)oAuth2Token);
            session.setAttribute("oauthRefreshToken", (Object)oAuth2Token.getRefreshToken());
            session.setAttribute("oauthExpiresAt", (Object)oAuth2Token.getExpiresAt());
            session.setAttribute("oauth2UserInfo", (Object)oauth2UserInfo);
            this.log.debug("Username collegato: [{}]", (Object)principal);
            return principal;
        }
        this.log.warn("Utenza non autenticata");
        return null;
    }

    private OAuth2Token refreshToken(HttpServletRequest request, String refreshToken) {
        OAuth2Token oAuth2Token = OAuth2Utilities.refreshToken(this.log, this.properties, refreshToken);
        if (oAuth2Token.getReturnCode() != 200) {
            request.setAttribute("oauth2ErrorCode", (Object)oAuth2Token.getError());
            request.setAttribute("oauth2ErrorDetail", (Object)oAuth2Token.getDescription());
        }
        return oAuth2Token;
    }

    @Override
    public void init(Object ... parametri) throws PrincipalReaderException {
        Object pObject;
        if (parametri != null && parametri.length > 0 && (pObject = parametri[0]) instanceof Properties) {
            this.properties = (Properties)pObject;
        }
    }

    private static void logError(Logger log, String msg) {
        OAuth2PrincipalReader.logError(log, msg, null);
    }

    private static void logError(Logger log, String msg, Throwable e) {
        if (e != null) {
            log.error(msg, e);
        } else {
            log.error(msg);
        }
    }
}

