/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf;

import java.io.ByteArrayOutputStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDXFAResource;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XFADocument {
    public static final String XFA_DATA_NAMESPACE = "http://www.xfa.org/schema/xfa-data/1.0/";
    public static final String XFA_DATASETS_LOCAL_NAME = "datasets";
    public static final String XFA_DATA_LOCAL_NAME = "data";
    private PDXFAResource xfa;
    private Document document;
    private byte[] content;

    public static byte[] addXfaDatasets(byte[] content) throws UtilsException {
        try {
            String xmlPrefix = "<xfa:datasets xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\">\n<xfa:data>\n";
            String xmlSuffix = "</xfa:data>\n</xfa:datasets>";
            ByteArrayOutputStream bout = null;
            bout = new ByteArrayOutputStream();
            bout.write(xmlPrefix.getBytes());
            bout.write(content);
            bout.write(xmlSuffix.getBytes());
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public PDXFAResource getXfa() {
        return this.xfa;
    }

    public void setXfa(PDXFAResource xfa) {
        this.xfa = xfa;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public boolean isXfaDataContent() {
        Node n = this.getXfaDataContentNode();
        return n != null;
    }

    public Node getXfaDataContentNode() {
        XMLUtils xmlUtils;
        Node nData;
        Element rootElement;
        if (this.document != null && this.document.getDocumentElement() != null && XFA_DATA_NAMESPACE.equals((rootElement = this.document.getDocumentElement()).getNamespaceURI()) && XFA_DATASETS_LOCAL_NAME.equals(rootElement.getLocalName()) && XFA_DATA_NAMESPACE.equals((nData = (xmlUtils = XMLUtils.getInstance()).getFirstNotEmptyChildNode(rootElement, false)).getNamespaceURI()) && XFA_DATA_LOCAL_NAME.equals(nData.getLocalName())) {
            return xmlUtils.getFirstNotEmptyChildNode(nData, false);
        }
        return null;
    }

    public byte[] getXfaDataContent() throws UtilsException {
        try {
            byte[] contentData = null;
            Node n = this.getXfaDataContentNode();
            if (n != null) {
                XMLUtils xmlUtils = XMLUtils.getInstance();
                contentData = xmlUtils.toByteArray(n, true);
            }
            return contentData;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

