/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.pdf.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.certificate.test.KeystoreTest;
import org.openspcoop2.utils.pdf.PDFSigner;
import org.openspcoop2.utils.pdf.PDFWriter;
import org.openspcoop2.utils.pdf.test.PDFReaderTest;
import org.openspcoop2.utils.resources.FileSystemUtilities;

public class PDFWriterTest {
    public static void main(String[] args) throws Exception {
        PDFWriterTest.testEmbedded();
        PDFWriterTest.testMultipleEmbedded();
        PDFWriterTest.testEmbeddedKid();
        PDFWriterTest.testMultipleEmbeddedKids();
        PDFWriterTest.testAnnotation();
        PDFWriterTest.testMultipleAnnotation();
        PDFWriterTest.testXFAFile(false);
        PDFWriterTest.testXFAFile(true);
        PDFWriterTest.testSignature();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testEmbedded() throws Exception {
        FileInputStream fin;
        PDFWriter w;
        InputStream isXML;
        InputStream isPDF;
        System.out.println("=====================");
        System.out.println("test add embeddedFile");
        File fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    w.addEmbeddedFile("EsempioFile.xml", isXML);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    try (FileInputStream fin2 = new FileInputStream(fileOUTPUT);){
                        PDFReaderTest.verificaFileEmbedded(fin2);
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- inputStream");
        fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    byte[] content = Utilities.getAsByteArray(isXML);
                    w.addEmbeddedFile("EsempioFile.xml", content);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    fin = new FileInputStream(fileOUTPUT);
                    try {
                        PDFReaderTest.verificaFileEmbedded(fin);
                    }
                    finally {
                        fin.close();
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- byte []");
        fileOUTPUT = null;
        File fTest = null;
        try (InputStream isPDF2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
             InputStream isXML2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");){
            PDFWriter w2 = new PDFWriter(isPDF2);
            fTest = new File("/tmp/EsempioFile.xml");
            FileSystemUtilities.writeFile(fTest, Utilities.getAsByteArray(isXML2));
            w2.addEmbeddedFile(fTest);
            fileOUTPUT = File.createTempFile("output", ".pdf");
            w2.writeTo(fileOUTPUT);
            fin = new FileInputStream(fileOUTPUT);
            try {
                PDFReaderTest.verificaFileEmbedded(fin);
            }
            finally {
                fin.close();
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
            if (fTest != null) {
                Files.delete(fTest.toPath());
            }
        }
        System.out.println("\t- file");
        System.out.println("test add embeddedFile completed");
        System.out.println("=====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testMultipleEmbedded() throws Exception {
        System.out.println("=====================");
        System.out.println("test multiple add embeddedFile");
        File fileOUTPUT = null;
        try (InputStream isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
             InputStream isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
             InputStream isZIP = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.zip");
             InputStream isDOC = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.doc");){
            PDFWriter w = new PDFWriter(isPDF);
            w.addEmbeddedFile("EsempioContenutoXML.xml", isXML, "application/xml");
            w.addEmbeddedFile("EsempioArchivio.zip", isZIP, "application/zip");
            w.addEmbeddedFile("README.doc", isDOC, "text/plain");
            fileOUTPUT = File.createTempFile("output", ".pdf");
            w.writeTo(fileOUTPUT);
            try (FileInputStream fin = new FileInputStream(fileOUTPUT);){
                PDFReaderTest.verificaFileMultipleEmbedded(fin);
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("test multiple add embeddedFile completed");
        System.out.println("=====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testEmbeddedKid() throws Exception {
        FileInputStream fin;
        PDFWriter w;
        InputStream isXML;
        InputStream isPDF;
        System.out.println("=====================");
        System.out.println("test add embeddedFile (kid)");
        File fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    w.addEmbeddedFileAsKid("EsempioFileKid.xml", isXML);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    try (FileInputStream fin2 = new FileInputStream(fileOUTPUT);){
                        PDFReaderTest.verificaFileEmbeddedKid(fin2);
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- inputStream");
        fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    byte[] content = Utilities.getAsByteArray(isXML);
                    w.addEmbeddedFileAsKid("EsempioFileKid.xml", content);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    fin = new FileInputStream(fileOUTPUT);
                    try {
                        PDFReaderTest.verificaFileEmbeddedKid(fin);
                    }
                    finally {
                        fin.close();
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- byte []");
        fileOUTPUT = null;
        File fTest = null;
        try (InputStream isPDF2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
             InputStream isXML2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");){
            PDFWriter w2 = new PDFWriter(isPDF2);
            fTest = new File("/tmp/EsempioFileKid.xml");
            FileSystemUtilities.writeFile(fTest, Utilities.getAsByteArray(isXML2));
            w2.addEmbeddedFileAsKid(fTest);
            fileOUTPUT = File.createTempFile("output", ".pdf");
            w2.writeTo(fileOUTPUT);
            fin = new FileInputStream(fileOUTPUT);
            try {
                PDFReaderTest.verificaFileEmbeddedKid(fin);
            }
            finally {
                fin.close();
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
            if (fTest != null) {
                Files.delete(fTest.toPath());
            }
        }
        System.out.println("\t- file");
        System.out.println("test add embeddedFile (kid) completed");
        System.out.println("=====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testMultipleEmbeddedKids() throws Exception {
        System.out.println("=====================");
        System.out.println("test multiple add embeddedFile (kids)");
        File fileOUTPUT = null;
        try (InputStream isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
             InputStream isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
             InputStream isZIP = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.zip");
             InputStream isDOC = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.doc");){
            PDFWriter w = new PDFWriter(isPDF);
            w.addEmbeddedFileAsKid("EsempioContenutoXML_kid.xml", isXML, "application/xml");
            w.addEmbeddedFileAsKid("EsempioArchivio_kid.zip", isZIP, "application/zip");
            w.addEmbeddedFileAsKid("README_kid.doc", isDOC, "text/plain");
            fileOUTPUT = File.createTempFile("output", ".pdf");
            w.writeTo(fileOUTPUT);
            try (FileInputStream fin = new FileInputStream(fileOUTPUT);){
                PDFReaderTest.verificaFileMultipleEmbeddedKids(fin);
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("test multiple add embeddedFile (kids) completed");
        System.out.println("=====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testAnnotation() throws Exception {
        FileInputStream fin;
        PDFWriter w;
        InputStream isXML;
        InputStream isPDF;
        System.out.println("=====================");
        System.out.println("test add annotationFile");
        File fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    w.addAnnotationFile("EsempioAnnotation.xml", isXML);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    try (FileInputStream fin2 = new FileInputStream(fileOUTPUT);){
                        PDFReaderTest.verificaFileAnnotation(fin2);
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- inputStream");
        fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    byte[] content = Utilities.getAsByteArray(isXML);
                    w.addAnnotationFile("EsempioAnnotation.xml", content);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    fin = new FileInputStream(fileOUTPUT);
                    try {
                        PDFReaderTest.verificaFileAnnotation(fin);
                    }
                    finally {
                        fin.close();
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- byte []");
        fileOUTPUT = null;
        File fTest = null;
        try (InputStream isPDF2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
             InputStream isXML2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");){
            PDFWriter w2 = new PDFWriter(isPDF2);
            fTest = new File("/tmp/EsempioAnnotation.xml");
            FileSystemUtilities.writeFile(fTest, Utilities.getAsByteArray(isXML2));
            w2.addAnnotationFile(fTest);
            fileOUTPUT = File.createTempFile("output", ".pdf");
            w2.writeTo(fileOUTPUT);
            fin = new FileInputStream(fileOUTPUT);
            try {
                PDFReaderTest.verificaFileAnnotation(fin);
            }
            finally {
                fin.close();
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
            if (fTest != null) {
                Files.delete(fTest.toPath());
            }
        }
        System.out.println("\t- file");
        System.out.println("test add annotationFile completed");
        System.out.println("=====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testMultipleAnnotation() throws Exception {
        System.out.println("=====================");
        System.out.println("test multiple add annotationFile");
        File fileOUTPUT = null;
        try (InputStream isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
             InputStream isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
             InputStream isZIP = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.zip");
             InputStream isDOC = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.doc");){
            PDFWriter w = new PDFWriter(isPDF);
            w.addAnnotationFile("EsempioContenutoXML_annotation.xml", isXML, "application/xml");
            w.addAnnotationFile("EsempioArchivio_annotation.zip", isZIP, "application/zip");
            w.addAnnotationFile("README_annotation.doc", isDOC, "text/plain");
            fileOUTPUT = File.createTempFile("output", ".pdf");
            w.writeTo(fileOUTPUT);
            try (FileInputStream fin = new FileInputStream(fileOUTPUT);){
                PDFReaderTest.verificaFileMultipleAnnotations(fin);
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("test multiple add annotationFile completed");
        System.out.println("=====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testXFAFile(boolean xfaDataSets) throws Exception {
        FileInputStream fin;
        PDFWriter w;
        InputStream isXML;
        InputStream isPDF;
        System.out.println("=====================");
        System.out.println("test add xfaFile (datasets:" + xfaDataSets + ")");
        File fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    w.setXFAFile(isXML, xfaDataSets);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    try (FileInputStream fin2 = new FileInputStream(fileOUTPUT);){
                        PDFReaderTest.verificaFileXFA(fin2, xfaDataSets);
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- inputStream");
        fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                isXML = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");
                try {
                    w = new PDFWriter(isPDF);
                    byte[] content = Utilities.getAsByteArray(isXML);
                    w.setXFAFile(content, xfaDataSets);
                    fileOUTPUT = File.createTempFile("output", ".pdf");
                    w.writeTo(fileOUTPUT);
                    fin = new FileInputStream(fileOUTPUT);
                    try {
                        PDFReaderTest.verificaFileXFA(fin, xfaDataSets);
                    }
                    finally {
                        fin.close();
                    }
                }
                finally {
                    if (isXML != null) {
                        isXML.close();
                    }
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- byte []");
        fileOUTPUT = null;
        File fTest = null;
        try (InputStream isPDF2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
             InputStream isXML2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.xml");){
            PDFWriter w2 = new PDFWriter(isPDF2);
            fTest = new File("/tmp/EsempioXFA.xml");
            FileSystemUtilities.writeFile(fTest, Utilities.getAsByteArray(isXML2));
            w2.setXFAFile(fTest, xfaDataSets);
            fileOUTPUT = File.createTempFile("output", ".pdf");
            w2.writeTo(fileOUTPUT);
            fin = new FileInputStream(fileOUTPUT);
            try {
                PDFReaderTest.verificaFileXFA(fin, xfaDataSets);
            }
            finally {
                fin.close();
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
            if (fTest != null) {
                Files.delete(fTest.toPath());
            }
        }
        System.out.println("\t- file");
        System.out.println("test add xfaFile (datasets:" + xfaDataSets + ") completed");
        System.out.println("=====================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testSignature() throws Exception {
        PDFSigner pdfSigner;
        InputStream isPDF;
        System.out.println("=====================");
        System.out.println("test signature");
        KeyStore keystore = new KeyStore(Utilities.getAsByteArray(KeystoreTest.class.getResourceAsStream("/org/openspcoop2/utils/certificate/test/govway_test.jks")), ArchiveType.JKS.name(), "123456");
        File fileOUTPUT = null;
        try {
            isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
            try {
                PDFSigner pdfSigner2 = new PDFSigner(isPDF, "SignatureTest", PDFReaderTest.SIGNATURE_FILTER, PDFReaderTest.SIGNATURE_SUBFILTER, "Pisa", "Test Signature", "Esempio informazione di conjtatto");
                fileOUTPUT = File.createTempFile("output", ".pdf");
                pdfSigner2.sign(keystore, "govway_test", "123456", fileOUTPUT);
                try (FileInputStream fin = new FileInputStream(fileOUTPUT);){
                    PDFReaderTest.verificaFileSignature(fin);
                }
            }
            finally {
                if (isPDF != null) {
                    isPDF.close();
                }
            }
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
        }
        System.out.println("\t- inputStream");
        isPDF = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");
        try {
            byte[] content = Utilities.getAsByteArray(isPDF);
            pdfSigner = new PDFSigner(content, "SignatureTest", PDFReaderTest.SIGNATURE_FILTER, PDFReaderTest.SIGNATURE_SUBFILTER, "Pisa", "Test Signature", "Esempio informazione di conjtatto");
            byte[] contentSigned = pdfSigner.sign(keystore, "govway_test", "123456");
            PDFReaderTest.verificaFileSignature(contentSigned);
        }
        finally {
            if (isPDF != null) {
                isPDF.close();
            }
        }
        System.out.println("\t- byte []");
        fileOUTPUT = null;
        File fTest = null;
        try (InputStream isPDF2 = PDFWriterTest.class.getResourceAsStream("/org/openspcoop2/utils/pdf/test/HelloWorld.pdf");){
            fTest = new File("/tmp/EsempioFile.xml");
            FileSystemUtilities.writeFile(fTest, Utilities.getAsByteArray(isPDF2));
            pdfSigner = new PDFSigner(fTest, "SignatureTest", PDFReaderTest.SIGNATURE_FILTER, PDFReaderTest.SIGNATURE_SUBFILTER, "Pisa", "Test Signature", "Esempio informazione di conjtatto");
            fileOUTPUT = File.createTempFile("output", ".pdf");
            pdfSigner.sign(keystore, "govway_test", "123456", fileOUTPUT);
            PDFReaderTest.verificaFileSignature(fileOUTPUT);
        }
        finally {
            if (fileOUTPUT != null) {
                Files.delete(fileOUTPUT.toPath());
            }
            if (fTest != null) {
                Files.delete(fTest.toPath());
            }
        }
        System.out.println("\t- file");
        System.out.println("test signature completed");
        System.out.println("=====================");
    }
}

