/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.properties;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.SortedMap;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.properties.PropertiesReader;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.slf4j.Logger;

public class MapProperties {
    public static final String FILE_NAME = "govway.map.properties";
    public static final String ENV_PREFIX = "env.";
    public static final String JAVA_PREFIX = "java.";
    public static final String OBFUSCATED_ENV_KEYS = "obfuscated.env.keys";
    public static final String OBFUSCATED_JAVA_KEYS = "obfuscated.java.keys";
    public static final String OBFUSCATED_MODE = "obfuscated.mode";
    public static final String OBFUSCATED_MODE_NON_INIZIALIZZATO = "not initialized";
    public static final String OBFUSCATED_MODE_NONE = "none";
    public static final String OBFUSCATED_MODE_DIGEST = "digest";
    public static final String OBFUSCATED_MODE_STATIC = "static";
    public static final String OBFUSCATED_DIGEST = "obfuscated.digest";
    public static final String OBFUSCATED_DIGEST_DEFAULT = "SHA-256";
    public static final String OBFUSCATED_STATIC = "obfuscated.static";
    public static final String OBFUSCATED_STATIC_DEFAULT = "******";
    protected Logger log = null;
    protected PropertiesReader reader;
    protected String content;
    private static MapProperties mapProperties = null;
    protected SortedMap<String> envMap = new SortedMap();
    protected SortedMap<String> javaMap = new SortedMap();

    public SortedMap<String> getEnvMap() {
        return this.envMap;
    }

    public SortedMap<String> getJavaMap() {
        return this.javaMap;
    }

    protected MapProperties(Logger log, String fileName, boolean throwNotFound) throws UtilsException {
        this.init(log, fileName, throwNotFound);
    }

    protected void init(Logger log, String fileName, boolean throwNotFound) throws UtilsException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(MapProperties.class) : log;
        Properties propertiesReader = this.readProperties(fileName);
        if (propertiesReader != null) {
            this.reader = new PropertiesReader(propertiesReader, true);
        } else if (throwNotFound) {
            throw new UtilsException("Config '" + fileName + "' not found");
        }
    }

    private Properties readProperties(String fileName) throws UtilsException {
        Closeable properties;
        File fCheck = new File(fileName);
        if (fCheck.exists()) {
            if (!fCheck.canRead()) {
                throw new UtilsException("File '" + fCheck.getAbsolutePath() + "' cannot read");
            }
            try {
                this.content = FileSystemUtilities.readFile(fCheck);
            }
            catch (Exception e) {
                throw new UtilsException("File '" + fCheck.getAbsolutePath() + "' read failed: " + e.getMessage(), e);
            }
        }
        Object uri = fileName;
        if (!fileName.startsWith("/")) {
            uri = "/" + fileName;
        }
        try {
            properties = MapProperties.class.getResourceAsStream((String)uri);
            try {
                if (properties != null) {
                    this.content = Utilities.getAsString((InputStream)properties, Charset.UTF_8.getValue());
                }
            }
            finally {
                if (properties != null) {
                    ((InputStream)properties).close();
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Uri '" + (String)uri + "' access failed: " + e.getMessage(), e);
        }
        Properties props = null;
        if (this.content != null) {
            props = new Properties();
            try {
                properties = new StringReader(this.content);
                try {
                    props.load((Reader)properties);
                }
                finally {
                    ((Reader)properties).close();
                }
            }
            catch (Exception e) {
                throw new UtilsException("Config '" + fileName + "' access failed: " + e.getMessage(), e);
            }
        }
        return props;
    }

    public static boolean initialize(Logger log, String fileName, boolean throwNotFound) {
        try {
            mapProperties = new MapProperties(log, fileName, throwNotFound);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MapProperties getInstance() {
        if (mapProperties != null) return mapProperties;
        Class<MapProperties> clazz = MapProperties.class;
        synchronized (MapProperties.class) {
            if (mapProperties != null) return mapProperties;
            // ** MonitorExit[var0] (shouldn't be in output)
            return null;
        }
    }

    public void initEnvironment() throws UtilsException {
        List<String> keys;
        SortedMap<String> convertTextToProperties;
        if (this.content != null && (convertTextToProperties = PropertiesUtilities.convertTextToSortedMap(this.content, false)) != null && !convertTextToProperties.isEmpty() && (keys = convertTextToProperties.keys()) != null && !keys.isEmpty()) {
            for (String key : keys) {
                this.loadPropertyInEnvironment(key);
            }
        }
    }

    public void loadPropertyInEnvironment(String key) throws UtilsException {
        if (key.startsWith(ENV_PREFIX) && key.length() > ENV_PREFIX.length()) {
            String envKey = key.substring(ENV_PREFIX.length());
            String value = this.reader.getValue_convertEnvProperties(key);
            this.setEnvProperty(envKey, value);
        } else if (key.startsWith(JAVA_PREFIX) && key.length() > JAVA_PREFIX.length()) {
            String envKey = key.substring(JAVA_PREFIX.length());
            String value = this.reader.getValue_convertEnvProperties(key);
            this.setJavaProperty(envKey, value);
        }
    }

    protected void setJavaProperty(String envKey, String value) throws UtilsException {
        if (value != null) {
            System.setProperty(envKey, value);
            if (this.javaMap.containsKey(envKey)) {
                this.javaMap.remove(envKey);
            }
            this.javaMap.put(envKey, value);
        }
    }

    protected void setEnvProperty(String envKey, String value) throws UtilsException {
        if (value != null) {
            Utilities.setEnvProperty(envKey, value);
            if (this.envMap.containsKey(envKey)) {
                this.envMap.remove(envKey);
            }
            this.envMap.put(envKey, value);
        }
    }

    public List<String> getObfuscatedEnvKeys() throws UtilsException {
        return this.getObfuscatedKeys(OBFUSCATED_ENV_KEYS);
    }

    public List<String> getObfuscatedJavaKeys() throws UtilsException {
        return this.getObfuscatedKeys(OBFUSCATED_JAVA_KEYS);
    }

    private List<String> getObfuscatedKeys(String pName) throws UtilsException {
        String value;
        ArrayList<String> l = new ArrayList<String>();
        if (this.reader == null) {
            return l;
        }
        if (this.isObfuscatedModeEnabled() && (value = this.reader.getValue_convertEnvProperties(pName)) != null && StringUtils.isNotEmpty((CharSequence)value.trim())) {
            if ((value = value.trim()).contains(",")) {
                this.fillObfuscatedKeys(value, l);
            } else {
                l.add(value);
            }
        }
        return l;
    }

    private void fillObfuscatedKeys(String value, List<String> l) {
        String[] tmp = value.split(",");
        if (tmp != null && tmp.length > 0) {
            for (String t : tmp) {
                if (t == null || !StringUtils.isNotEmpty((CharSequence)t.trim())) continue;
                l.add(t);
            }
        }
    }

    public boolean isObfuscatedModeEnabled() throws UtilsException {
        if (this.reader == null) {
            return false;
        }
        String value = this.reader.getValue_convertEnvProperties(OBFUSCATED_MODE);
        if (value != null && StringUtils.isNotEmpty((CharSequence)value.trim())) {
            if (OBFUSCATED_MODE_DIGEST.equals(value = value.trim()) || OBFUSCATED_MODE_STATIC.equals(value)) {
                return true;
            }
            if (OBFUSCATED_MODE_NONE.equals(value)) {
                return false;
            }
            throw new UtilsException("[obfuscated.mode] unknown mode '" + value + "'");
        }
        return true;
    }

    public String getObfuscateModeDescription() throws UtilsException {
        if (this.reader == null) {
            return OBFUSCATED_MODE_NON_INIZIALIZZATO;
        }
        Object obfuscateMode = OBFUSCATED_MODE_NONE;
        if (this.isObfuscatedModeStatic()) {
            obfuscateMode = "static (" + this.getObfuscatedModeStaticValue() + ")";
        } else if (this.isObfuscatedModeDigest()) {
            obfuscateMode = "digest (" + this.getObfuscatedModeDigestAlgo() + ")";
        }
        return obfuscateMode;
    }

    public boolean isObfuscatedModeStatic() throws UtilsException {
        return this.getObfuscatedModeStaticValue() != null;
    }

    public String getObfuscatedModeStaticValue() throws UtilsException {
        if (this.reader == null) {
            return null;
        }
        String value = this.reader.getValue_convertEnvProperties(OBFUSCATED_MODE);
        if (value != null && StringUtils.isNotEmpty((CharSequence)value.trim())) {
            if (OBFUSCATED_MODE_STATIC.equals(value = value.trim())) {
                String s = this.reader.getValue_convertEnvProperties(OBFUSCATED_STATIC);
                if (s != null && StringUtils.isNotEmpty((CharSequence)s.trim())) {
                    return s.trim();
                }
                return OBFUSCATED_STATIC_DEFAULT;
            }
            if (OBFUSCATED_MODE_DIGEST.equals(value) || OBFUSCATED_MODE_NONE.equals(value)) {
                return null;
            }
            throw new UtilsException("[obfuscated.mode] unknown property value '" + value + "'");
        }
        return null;
    }

    public boolean isObfuscatedModeDigest() throws UtilsException {
        return this.getObfuscatedModeDigestAlgo() != null;
    }

    public String getObfuscatedModeDigestAlgo() throws UtilsException {
        if (this.reader == null) {
            return null;
        }
        String value = this.reader.getValue_convertEnvProperties(OBFUSCATED_MODE);
        if (value != null && StringUtils.isNotEmpty((CharSequence)value.trim())) {
            if (OBFUSCATED_MODE_DIGEST.equals(value = value.trim())) {
                String s = this.reader.getValue_convertEnvProperties(OBFUSCATED_DIGEST);
                if (s != null && StringUtils.isNotEmpty((CharSequence)s.trim())) {
                    return s.trim();
                }
                return OBFUSCATED_DIGEST_DEFAULT;
            }
            if (OBFUSCATED_MODE_STATIC.equals(value) || OBFUSCATED_MODE_NONE.equals(value)) {
                return null;
            }
            throw new UtilsException("[obfuscated.mode] unknown property value '" + value + "'");
        }
        return OBFUSCATED_DIGEST_DEFAULT;
    }

    protected boolean obfuscate(boolean java, String key) {
        if (java || key != null) {
            // empty if block
        }
        return true;
    }

    public String obfuscateJavaProperty(String key, String value) throws UtilsException {
        return this.obfuscate(true, key, value);
    }

    public String obfuscateEnvProperty(String key, String value) throws UtilsException {
        return this.obfuscate(false, key, value);
    }

    protected String obfuscate(boolean java, String key, String value) throws UtilsException {
        if (!this.obfuscate(java, key)) {
            return value;
        }
        if (!this.isObfuscatedModeEnabled() || value == null || StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (this.isObfuscatedModeStatic()) {
            return this.getObfuscatedModeStaticValue();
        }
        if (this.isObfuscatedModeDigest()) {
            try {
                return Base64Utilities.encodeAsString(MessageDigest.getInstance(this.getObfuscatedModeDigestAlgo()).digest(value.getBytes()));
            }
            catch (Exception e) {
                throw new UtilsException(e.getMessage(), e);
            }
        }
        throw new UtilsException("[obfuscated.mode] unsupported mode");
    }

    public static String obfuscateByDigest(String value) throws UtilsException {
        try {
            return Base64Utilities.encodeAsString(MessageDigest.getInstance(OBFUSCATED_DIGEST_DEFAULT).digest(value.getBytes()));
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

