/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.regexp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.regexp.RegularExpressionPatternCompileMode;

public class RegularExpressionEngine {
    private static final String CONTENUTO_NON_FORNITO = "Contenuto su cui effettuare una ricerca non fornita";
    private static final String NESSUN_MATCH_TROVATO = "nessun match trovato";

    private RegularExpressionEngine() {
    }

    private static RegExpException getErrorMessage(String method, String contenuto, String pattern, Exception e) {
        return new RegExpException(method + " contenuto[" + contenuto + "] pattern[" + pattern + "] error: " + e.getMessage(), e);
    }

    public static List<String> getAllStringMatchPattern(String contenuto, String pattern) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getAllStringPatternEngine(contenuto, pattern, true, null);
    }

    public static List<String> getAllStringMatchPattern(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getAllStringPatternEngine(contenuto, pattern, true, compileModes);
    }

    public static List<String> getAllStringMatchPattern(String contenuto, Pattern pattern) throws RegExpException, RegExpNotFoundException {
        return RegularExpressionEngine.getAllStringPatternEngine(contenuto, pattern, true);
    }

    public static List<String> getAllStringFindPattern(String contenuto, String pattern) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getAllStringPatternEngine(contenuto, pattern, false, null);
    }

    public static List<String> getAllStringFindPattern(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getAllStringPatternEngine(contenuto, pattern, false, compileModes);
    }

    public static List<String> getAllStringFindPattern(String contenuto, Pattern pattern) throws RegExpException, RegExpNotFoundException {
        return RegularExpressionEngine.getAllStringPatternEngine(contenuto, pattern, false);
    }

    private static List<String> getAllStringPatternEngine(String contenuto, String pattern, boolean usingMatch, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        Pattern p = RegularExpressionEngine.validateEngine(pattern, compileModes);
        return RegularExpressionEngine.getAllStringPatternEngine(contenuto, p, usingMatch);
    }

    private static List<String> getAllStringPatternEngine(String contenuto, Pattern p, boolean usingMatch) throws RegExpException, RegExpNotFoundException {
        if (contenuto == null || contenuto.length() == 0) {
            throw new RegExpNotFoundException(CONTENUTO_NON_FORNITO);
        }
        try {
            Matcher matcher = p.matcher(contenuto);
            if (usingMatch) {
                return RegularExpressionEngine.getAllStringPatternEngineMatch(matcher);
            }
            return RegularExpressionEngine.getAllStringPatternEngineFind(matcher);
        }
        catch (RegExpNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw RegularExpressionEngine.getErrorMessage("getAllStringMatchPattern", contenuto, p.toString(), e);
        }
    }

    private static List<String> getAllStringPatternEngineMatch(Matcher matcher) throws RegExpNotFoundException {
        String[] result = null;
        if (matcher.matches()) {
            result = new String[matcher.groupCount()];
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                result[i - 1] = matcher.group(i);
            }
        } else {
            throw new RegExpNotFoundException(NESSUN_MATCH_TROVATO);
        }
        if (result.length > 0) {
            ArrayList<String> l = new ArrayList<String>();
            l.addAll(Arrays.asList(result));
            return l;
        }
        throw new RegExpNotFoundException(NESSUN_MATCH_TROVATO);
    }

    private static List<String> getAllStringPatternEngineFind(Matcher matcher) throws RegExpNotFoundException {
        ArrayList<String> l = new ArrayList<String>();
        while (matcher.find()) {
            String varname = matcher.group(1);
            l.add(varname);
        }
        if (!l.isEmpty()) {
            return l;
        }
        throw new RegExpNotFoundException(NESSUN_MATCH_TROVATO);
    }

    public static String getStringMatchPattern(String contenuto, String pattern) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getStringPatternEngine(contenuto, pattern, true, null);
    }

    public static String getStringMatchPattern(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getStringPatternEngine(contenuto, pattern, true, compileModes);
    }

    public static String getStringMatchPattern(String contenuto, Pattern pattern) throws RegExpException, RegExpNotFoundException {
        return RegularExpressionEngine.getStringPatternEngine(contenuto, pattern, true);
    }

    public static String getStringFindPattern(String contenuto, String pattern) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getStringPatternEngine(contenuto, pattern, false, null);
    }

    public static String getStringFindPattern(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.getStringPatternEngine(contenuto, pattern, false, compileModes);
    }

    public static String getStringFindPattern(String contenuto, Pattern pattern) throws RegExpException, RegExpNotFoundException {
        return RegularExpressionEngine.getStringPatternEngine(contenuto, pattern, false);
    }

    private static String getStringPatternEngine(String contenuto, String pattern, boolean usingMatch, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        Pattern p = RegularExpressionEngine.validateEngine(pattern, compileModes);
        return RegularExpressionEngine.getStringPatternEngine(contenuto, p, usingMatch);
    }

    private static String getStringPatternEngine(String contenuto, Pattern p, boolean usingMatch) throws RegExpException, RegExpNotFoundException {
        if (contenuto == null || contenuto.length() == 0) {
            throw new RegExpNotFoundException(CONTENUTO_NON_FORNITO);
        }
        try {
            Matcher matcher = p.matcher(contenuto);
            String result = null;
            boolean esito = false;
            esito = usingMatch ? matcher.matches() : matcher.find();
            if (!esito) {
                throw new RegExpNotFoundException(NESSUN_MATCH_TROVATO);
            }
            result = matcher.group(1);
            if ("".equals(result)) {
                throw new RegExpNotFoundException(NESSUN_MATCH_TROVATO);
            }
            return result;
        }
        catch (RegExpNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw RegularExpressionEngine.getErrorMessage("getStringMatchPattern", contenuto, p.toString(), e);
        }
    }

    public static boolean isMatch(String contenuto, String pattern) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.isMatchEngine(contenuto, pattern, true, null);
    }

    public static boolean isMatch(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.isMatchEngine(contenuto, pattern, true, compileModes);
    }

    public static boolean isFind(String contenuto, String pattern) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.isMatchEngine(contenuto, pattern, false, null);
    }

    public static boolean isFind(String contenuto, String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        return RegularExpressionEngine.isMatchEngine(contenuto, pattern, false, compileModes);
    }

    private static boolean isMatchEngine(String contenuto, String pattern, boolean usingMatch, RegularExpressionPatternCompileMode ... compileModes) throws RegExpException, RegExpNotValidException, RegExpNotFoundException {
        Pattern p = RegularExpressionEngine.validateEngine(pattern, compileModes);
        if (contenuto == null || contenuto.length() == 0) {
            throw new RegExpNotFoundException(CONTENUTO_NON_FORNITO);
        }
        try {
            Matcher matcher = p.matcher(contenuto);
            if (usingMatch) {
                return matcher.matches();
            }
            return matcher.find();
        }
        catch (Exception e) {
            throw RegularExpressionEngine.getErrorMessage("isMatch", contenuto, pattern, e);
        }
    }

    public static void validate(String pattern) throws RegExpNotValidException {
        RegularExpressionEngine.validateEngine(pattern, new RegularExpressionPatternCompileMode[0]);
    }

    public static void validate(String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpNotValidException {
        RegularExpressionEngine.validateEngine(pattern, compileModes);
    }

    private static Pattern validateEngine(String pattern, RegularExpressionPatternCompileMode ... compileModes) throws RegExpNotValidException {
        if (pattern == null || pattern.length() == 0) {
            throw new RegExpNotValidException("Pattern di ricerca non fornito");
        }
        try {
            pattern = pattern.trim();
            return RegularExpressionEngine.createPatternEngine(pattern, compileModes);
        }
        catch (Exception e) {
            throw new RegExpNotValidException("Validazione del pattern indicato [" + pattern + "] fallita: " + e.getMessage(), e);
        }
    }

    public static Pattern createPatternEngine(String pattern, RegularExpressionPatternCompileMode ... compileModes) {
        Pattern p = null;
        if (compileModes != null && compileModes.length > 0) {
            int mode = compileModes[0].getPatternCompileMode();
            for (int i = 1; i < compileModes.length; ++i) {
                mode |= compileModes[i].getPatternCompileMode();
            }
            p = Pattern.compile(pattern, mode);
        } else {
            p = Pattern.compile(pattern);
        }
        return p;
    }
}

