/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.regexp.test;

import java.util.List;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;

public class RegexpTest {
    public static void main(String[] args) throws Exception {
        RegexpTest.test();
    }

    public static void test() throws Exception {
        String atteso = "uuid23";
        String url = "/govway/out/ENTE/PubblicoAmministratore/TEST/v1/uuid23/altroContesto";
        String relativeExpression = "/([^/]+)/altroContesto";
        String absoluteExpression = ".*/([^/]+)/altroContesto";
        String atteso2 = "uuid27";
        String urlMultipla = "/govway/out/ENTE/PubblicoAmministratore/TEST/v1/uuid23/altroContesto/altro/uuid27/altroContesto";
        try {
            System.out.println("SINGLE [MATCH] RELATIVE: " + RegularExpressionEngine.getStringMatchPattern(url, relativeExpression));
            throw new Exception("Attesa eccezione");
        }
        catch (RegExpNotFoundException notFound) {
            String s;
            System.out.println("SINGLE [MATCH] RELATIVE NOT FOUND: " + notFound.getMessage());
            try {
                s = RegularExpressionEngine.getStringMatchPattern(url, absoluteExpression);
                System.out.println("SINGLE [MATCH] ABSOLUTE: " + s);
                if (!atteso.equals(s)) {
                    throw new Exception("Atteso come risultato la stringa '" + s + "'");
                }
            }
            catch (RegExpNotFoundException notFound2) {
                throw new Exception("Non attesa eccezione: " + notFound2.getMessage());
            }
            try {
                s = RegularExpressionEngine.getStringFindPattern(url, relativeExpression);
                System.out.println("SINGLE [FIND] RELATIVE: " + s);
                if (!atteso.equals(s)) {
                    throw new Exception("Atteso come risultato la stringa '" + s + "'");
                }
            }
            catch (RegExpNotFoundException notFound3) {
                throw new Exception("Non attesa eccezione: " + notFound3.getMessage());
            }
            try {
                s = RegularExpressionEngine.getStringFindPattern(url, absoluteExpression);
                System.out.println("SINGLE [FIND] ABSOLUTE: " + s);
                if (!atteso.equals(s)) {
                    throw new Exception("Atteso come risultato la stringa '" + s + "'");
                }
            }
            catch (RegExpNotFoundException notFound4) {
                throw new Exception("Non attesa eccezione: " + notFound4.getMessage());
            }
            try {
                System.out.println("ALL [MATCH] RELATIVE: " + String.valueOf(RegularExpressionEngine.getAllStringMatchPattern(url, relativeExpression)));
                throw new Exception("Attesa eccezione");
            }
            catch (RegExpNotFoundException notFound5) {
                List<String> l;
                System.out.println("ALL [MATCH] RELATIVE NOT FOUND: " + notFound5.getMessage());
                try {
                    l = RegularExpressionEngine.getAllStringMatchPattern(url, absoluteExpression);
                    System.out.println("ALL [MATCH] ABSOLUTE: " + String.valueOf(l));
                    if (l == null || l.size() != 1 || !("[" + atteso + "]").equals(l.toString())) {
                        throw new Exception("Attesa lista di 1 elemento '" + atteso + "'");
                    }
                }
                catch (RegExpNotFoundException notFound6) {
                    throw new Exception("Non attesa eccezione: " + notFound6.getMessage());
                }
                try {
                    l = RegularExpressionEngine.getAllStringFindPattern(url, relativeExpression);
                    System.out.println("ALL [FIND] RELATIVE: " + String.valueOf(l));
                    if (l == null || l.size() != 1 || !("[" + atteso + "]").equals(l.toString())) {
                        throw new Exception("Attesa lista di 1 elemento '" + atteso + "'");
                    }
                }
                catch (RegExpNotFoundException notFound7) {
                    throw new Exception("Non attesa eccezione: " + notFound7.getMessage());
                }
                try {
                    l = RegularExpressionEngine.getAllStringFindPattern(url, absoluteExpression);
                    System.out.println("ALL [FIND] ABSOLUTE: " + String.valueOf(l));
                    if (l == null || l.size() != 1 || !("[" + atteso + "]").equals(l.toString())) {
                        throw new Exception("Attesa lista di 1 elemento '" + atteso + "'");
                    }
                }
                catch (RegExpNotFoundException notFound8) {
                    throw new Exception("Non attesa eccezione: " + notFound8.getMessage());
                }
                try {
                    System.out.println("ALL [MATCH] RELATIVE 'MULTIPLE RESULTS': " + String.valueOf(RegularExpressionEngine.getAllStringMatchPattern(urlMultipla, relativeExpression)));
                    throw new Exception("Attesa eccezione");
                }
                catch (RegExpNotFoundException notFound9) {
                    boolean b;
                    List<String> l2;
                    System.out.println("ALL [MATCH] RELATIVE NOT FOUND 'MULTIPLE RESULTS': " + notFound9.getMessage());
                    try {
                        l2 = RegularExpressionEngine.getAllStringMatchPattern(urlMultipla, absoluteExpression);
                        System.out.println("ALL [MATCH] ABSOLUTE 'MULTIPLE RESULTS': " + String.valueOf(l2));
                        if (l2 == null || l2.size() != 1 || !("[" + atteso2 + "]").equals(l2.toString())) {
                            throw new Exception("Attesa lista di 1 elemento '" + atteso2 + "'");
                        }
                    }
                    catch (RegExpNotFoundException notFound10) {
                        throw new Exception("Non attesa eccezione 'MULTIPLE RESULTS': " + notFound10.getMessage());
                    }
                    try {
                        l2 = RegularExpressionEngine.getAllStringFindPattern(urlMultipla, relativeExpression);
                        System.out.println("ALL [FIND] RELATIVE 'MULTIPLE RESULTS': " + String.valueOf(l2));
                        if (l2 == null || l2.size() != 2 || !("[" + atteso + ", " + atteso2 + "]").equals(l2.toString())) {
                            throw new Exception("Attesa lista di 2 elementi '" + atteso + ", " + atteso2 + "'");
                        }
                    }
                    catch (RegExpNotFoundException notFound11) {
                        throw new Exception("Non attesa eccezione 'MULTIPLE RESULTS': " + notFound11.getMessage());
                    }
                    try {
                        l2 = RegularExpressionEngine.getAllStringFindPattern(urlMultipla, absoluteExpression);
                        System.out.println("ALL [FIND] ABSOLUTE 'MULTIPLE RESULTS': " + String.valueOf(l2));
                        if (l2 == null || l2.size() != 1 || !("[" + atteso2 + "]").equals(l2.toString())) {
                            throw new Exception("Attesa lista di 1 elemento '" + atteso2 + "'");
                        }
                    }
                    catch (RegExpNotFoundException notFound12) {
                        throw new Exception("Non attesa eccezione 'MULTIPLE RESULTS': " + notFound12.getMessage());
                    }
                    try {
                        b = RegularExpressionEngine.isMatch(url, relativeExpression);
                        System.out.println("BOOLEAN [MATCH] RELATIVE: " + b);
                        if (b) {
                            throw new Exception("Atteso false");
                        }
                    }
                    catch (RegExpNotFoundException notFound13) {
                        throw new Exception("Non attesa eccezione: " + notFound13.getMessage());
                    }
                    try {
                        b = RegularExpressionEngine.isMatch(url, absoluteExpression);
                        System.out.println("BOOLEAN [MATCH] ABSOLUTE: " + b);
                        if (!b) {
                            throw new Exception("Atteso true");
                        }
                    }
                    catch (RegExpNotFoundException notFound14) {
                        throw new Exception("Non attesa eccezione: " + notFound14.getMessage());
                    }
                    try {
                        b = RegularExpressionEngine.isFind(url, relativeExpression);
                        System.out.println("BOOLEAN [FIND] RELATIVE: " + b);
                        if (!b) {
                            throw new Exception("Atteso true");
                        }
                    }
                    catch (RegExpNotFoundException notFound15) {
                        throw new Exception("Non attesa eccezione: " + notFound15.getMessage());
                    }
                    try {
                        b = RegularExpressionEngine.isFind(url, absoluteExpression);
                        System.out.println("BOOLEAN [FIND] ABSOLUTE: " + b);
                        if (!b) {
                            throw new Exception("Atteso true");
                        }
                    }
                    catch (RegExpNotFoundException notFound16) {
                        throw new Exception("Non attesa eccezione: " + notFound16.getMessage());
                    }
                    return;
                }
            }
        }
    }
}

