/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.rest.problem;

import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.rest.problem.ProblemRFC7807;

public abstract class AbstractDeserializer {
    protected boolean generateTypeBlank = false;

    public AbstractDeserializer() {
        this(false);
    }

    public AbstractDeserializer(boolean generateTypeBlank) {
        this.generateTypeBlank = generateTypeBlank;
    }

    public boolean isGenerateTypeBlank() {
        return this.generateTypeBlank;
    }

    public void setGenerateTypeBlank(boolean generateTypeBlank) {
        this.generateTypeBlank = generateTypeBlank;
    }

    protected void set(ProblemRFC7807 problem, String name, Object value, boolean throwExceptionIfUnsupportedCustomClaim) throws UtilsException {
        if ("type".equals(name)) {
            String type = this.getAsString(value);
            if ("about:blank".equals(type)) {
                if (this.generateTypeBlank) {
                    problem.setType(type);
                }
            } else {
                problem.setType(type);
            }
        } else if ("title".equals(name)) {
            problem.setTitle(this.getAsString(value));
        } else if ("status".equals(name)) {
            problem.setStatus(this.getAsInt(value));
        } else if ("detail".equals(name)) {
            problem.setDetail(this.getAsString(value));
        } else if ("instance".equals(name)) {
            problem.setInstance(this.getAsString(value));
        } else if (value != null) {
            if (value instanceof String) {
                problem.getCustom().put(name, value);
            } else if (value instanceof TextNode) {
                TextNode textNode = (TextNode)value;
                problem.getCustom().put(name, textNode.asText());
            } else if (value instanceof Integer) {
                problem.getCustom().put(name, value);
            } else if (value instanceof IntNode) {
                IntNode intNode = (IntNode)value;
                problem.getCustom().put(name, intNode.asInt());
            } else if (value instanceof Long) {
                problem.getCustom().put(name, value);
            } else if (value instanceof LongNode) {
                LongNode longNode = (LongNode)value;
                problem.getCustom().put(name, longNode.asInt());
            } else if (value instanceof Boolean) {
                problem.getCustom().put(name, value);
            } else if (value instanceof BooleanNode) {
                BooleanNode booleanNode = (BooleanNode)value;
                problem.getCustom().put(name, booleanNode.asBoolean());
            } else if (throwExceptionIfUnsupportedCustomClaim) {
                throw new UtilsException("Custom claim with type [" + value.getClass().getName() + "] unsupported");
            }
        } else {
            problem.getCustom().put(name, null);
        }
    }

    private String getAsString(Object value) {
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            if (value instanceof TextNode) {
                TextNode text = (TextNode)value;
                return text.asText();
            }
            return value.toString();
        }
        return null;
    }

    private Integer getAsInt(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            if (value instanceof IntNode) {
                IntNode intNode = (IntNode)value;
                return intNode.asInt();
            }
            if (value instanceof Long) {
                return ((Long)value).intValue();
            }
            if (value instanceof LongNode) {
                LongNode longNode = (LongNode)value;
                return (int)longNode.asLong();
            }
            return Integer.parseInt(value.toString());
        }
        return null;
    }
}

