/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Key;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.random.RandomUtilities;

public abstract class AbstractCipher {
    protected Key key;
    protected IvParameterSpec ivParameterSpec;
    protected Certificate certificate;
    private int mode;

    protected AbstractCipher(int mode) {
        this.mode = mode;
    }

    protected AbstractCipher(int mode, Key key) {
        this.mode = mode;
        this.key = key;
    }

    protected AbstractCipher(int mode, Key key, IvParameterSpec ivParameterSpec) {
        this.mode = mode;
        this.key = key;
        this.ivParameterSpec = ivParameterSpec;
    }

    protected AbstractCipher(int mode, Key key, byte[] ivParameterSpec) {
        this.mode = mode;
        this.key = key;
        if (ivParameterSpec != null && ivParameterSpec.length > 0) {
            this.ivParameterSpec = new IvParameterSpec(ivParameterSpec);
        }
    }

    protected AbstractCipher(int mode, KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this.mode = mode;
        this.key = keystore.getPrivateKey(alias, passwordPrivateKey);
    }

    protected AbstractCipher(int mode, byte[] secretKey, String algorithm) {
        this.mode = mode;
        this.key = new SecretKeySpec(secretKey, algorithm);
    }

    protected AbstractCipher(int mode, byte[] secretKey, String algorithm, IvParameterSpec ivParameterSpec) {
        this.mode = mode;
        this.key = new SecretKeySpec(secretKey, algorithm);
        this.ivParameterSpec = ivParameterSpec;
    }

    protected AbstractCipher(int mode, byte[] secretKey, String algorithm, byte[] ivParameterSpec) {
        this.mode = mode;
        this.key = new SecretKeySpec(secretKey, algorithm);
        if (ivParameterSpec != null && ivParameterSpec.length > 0) {
            this.ivParameterSpec = new IvParameterSpec(ivParameterSpec);
        }
    }

    protected AbstractCipher(int mode, Certificate certificate) {
        this.mode = mode;
        this.certificate = certificate;
    }

    protected AbstractCipher(int mode, KeyStore keystore, String alias) throws UtilsException {
        this.mode = mode;
        this.certificate = keystore.getCertificate(alias);
    }

    protected AbstractCipher(int mode, KeyStore keystore) throws UtilsException {
        this.mode = mode;
        this.certificate = keystore.getCertificate();
    }

    protected byte[] process(String data, String charsetName, String algorithm) throws UtilsException {
        try {
            return this.process(data.getBytes(charsetName), algorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected byte[] process(byte[] data, String algorithm) throws UtilsException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            if (this.key != null) {
                if (this.ivParameterSpec != null) {
                    cipher.init(this.mode, this.key, this.ivParameterSpec);
                } else {
                    cipher.init(this.mode, this.key);
                }
            } else {
                cipher.init(this.mode, this.certificate);
            }
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public void initIV(String algorithm) throws UtilsException {
        try {
            Cipher cipher = Cipher.getInstance(algorithm);
            byte[] ivBytes = new byte[cipher.getBlockSize()];
            SecureRandom random = RandomUtilities.getSecureRandom();
            random.nextBytes(ivBytes);
            this.ivParameterSpec = new IvParameterSpec(ivBytes);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] getIV() {
        return this.ivParameterSpec.getIV();
    }

    public byte[] getIVBase64() {
        return Base64Utilities.encode(this.getIV());
    }

    public String getIVBase64AsString() {
        return Base64Utilities.encodeAsString(this.getIV());
    }

    public char[] getIVHexBinary() throws UtilsException {
        return HexBinaryUtilities.encode(this.getIV());
    }

    public String getIVHexBinaryAsString() throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.getIV());
    }
}

