/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.spec.IvParameterSpec;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.AbstractCipher;

public class Decrypt
extends AbstractCipher {
    public Decrypt(byte[] secretKey, String algorithm) {
        super(2, secretKey, algorithm);
    }

    public Decrypt(byte[] secretKey, String algorithm, IvParameterSpec ivParameterSpec) {
        super(2, secretKey, algorithm, ivParameterSpec);
    }

    public Decrypt(byte[] secretKey, String algorithm, byte[] ivParameterSpec) {
        super(2, secretKey, algorithm, ivParameterSpec);
    }

    public Decrypt(Certificate certificate) {
        super(2, certificate);
    }

    public Decrypt(Key key) {
        super(2, key);
    }

    public Decrypt(Key key, IvParameterSpec ivParameterSpec) {
        super(2, key, ivParameterSpec);
    }

    public Decrypt(Key key, byte[] ivParameterSpec) {
        super(2, key, ivParameterSpec);
    }

    public Decrypt(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(2, keystore, alias, passwordPrivateKey);
    }

    public Decrypt(KeyStore keystore, String alias) throws UtilsException {
        super(2, keystore, alias);
    }

    public Decrypt(KeyStore keystore) throws UtilsException {
        super(2, keystore);
    }

    public byte[] decrypt(byte[] data, String algorithm) throws UtilsException {
        return super.process(data, algorithm);
    }

    public byte[] decryptBase64(byte[] data, String algorithm) throws UtilsException {
        return super.process(Base64Utilities.decode(data), algorithm);
    }

    public byte[] decryptBase64(String data, String algorithm) throws UtilsException {
        return super.process(Base64Utilities.decode(data), algorithm);
    }

    public byte[] decryptHexBinary(char[] data, String algorithm) throws UtilsException {
        return super.process(HexBinaryUtilities.decode(data), algorithm);
    }

    public byte[] decryptHexBinary(String data, String algorithm) throws UtilsException {
        return super.process(HexBinaryUtilities.decode(data), algorithm);
    }
}

