/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Key;
import java.security.cert.Certificate;
import javax.crypto.Cipher;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.io.HexBinaryUtilities;
import org.openspcoop2.utils.security.Decrypt;

public class DecryptWrapKey {
    private Key key;
    private Certificate certificate;

    public DecryptWrapKey(Certificate certificate) {
        this.certificate = certificate;
    }

    public DecryptWrapKey(Key key) {
        this.key = key;
    }

    public DecryptWrapKey(KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        this.key = keystore.getPrivateKey(alias, passwordPrivateKey);
    }

    public DecryptWrapKey(KeyStore keystore, String alias) throws UtilsException {
        this.certificate = keystore.getCertificate(alias);
    }

    public DecryptWrapKey(KeyStore keystore) throws UtilsException {
        this.certificate = keystore.getCertificate();
    }

    protected byte[] process(String data, String charsetName, byte[] wrappedKey, byte[] iv, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        try {
            return this.process(data.getBytes(charsetName), wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    protected byte[] process(byte[] data, byte[] wrappedKey, byte[] iv, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        try {
            Cipher cipher = Cipher.getInstance(wrappedKeyAlgorithm);
            if (this.certificate != null) {
                cipher.init(4, this.certificate);
            } else {
                cipher.init(4, this.key);
            }
            Key secretKey = cipher.unwrap(wrappedKey, "AES", 3);
            Decrypt decrypt = new Decrypt(secretKey, iv);
            return decrypt.decrypt(data, contentAlgorithm);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    public byte[] decrypt(String data, byte[] wrappedKey, byte[] iv, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return this.process(data, charsetName, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm);
    }

    public byte[] decrypt(byte[] data, byte[] wrappedKey, byte[] iv, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return this.process(data, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm);
    }

    public byte[] decryptBase64(String data, byte[] wrappedKey, byte[] iv, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encode(this.process(data, charsetName, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public byte[] decryptBase64(byte[] data, byte[] wrappedKey, byte[] iv, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encode(this.process(data, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String decryptBase64AsString(String data, byte[] wrappedKey, byte[] iv, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encodeAsString(this.process(data, charsetName, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String decryptBase64AsString(byte[] data, byte[] wrappedKey, byte[] iv, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return Base64Utilities.encodeAsString(this.process(data, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public char[] decryptHexBinary(String data, byte[] wrappedKey, byte[] iv, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encode(this.process(data, charsetName, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public char[] decryptHexBinary(byte[] data, byte[] wrappedKey, byte[] iv, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encode(this.process(data, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String decryptHexBinaryAsString(String data, byte[] wrappedKey, byte[] iv, String charsetName, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.process(data, charsetName, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }

    public String decryptHexBinaryAsString(byte[] data, byte[] wrappedKey, byte[] iv, String wrappedKeyAlgorithm, String contentAlgorithm) throws UtilsException {
        return HexBinaryUtilities.encodeAsString(this.process(data, wrappedKey, iv, wrappedKeyAlgorithm, contentAlgorithm));
    }
}

