/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.json.JSONUtils;

public class JWTParser {
    private String token;
    private String jweDecodedPayload;
    private Map<String, String> readClaimsHeader = null;
    private Map<String, String> readClaimsPayload = null;

    public JWTParser(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public String getHeader() {
        String[] split;
        if (this.token != null && (split = this.token.split("\\.")) != null && split.length > 0) {
            return split[0];
        }
        return null;
    }

    public String getDecodedHeader() {
        String hdr = this.getHeader();
        if (hdr != null) {
            return new String(Base64Utilities.decode(hdr));
        }
        return null;
    }

    public Map<String, String> getHeaderClaims() throws UtilsException {
        Map<String, String> m = null;
        if (this.token != null) {
            if (this.readClaimsHeader == null) {
                this.initReadClaimsHeader();
            }
            return this.readClaimsHeader;
        }
        return m;
    }

    public String getHeaderClaim(String claim) throws UtilsException {
        if (this.token != null) {
            if (this.readClaimsHeader == null) {
                this.initReadClaimsHeader();
            }
            if (this.readClaimsHeader != null) {
                return this.readClaimsHeader.get(claim);
            }
        }
        return null;
    }

    public String getPayload() {
        String[] split;
        if (this.jweDecodedPayload != null) {
            return this.jweDecodedPayload;
        }
        if (this.token != null && (split = this.token.split("\\.")) != null && split.length > 1) {
            return split[1];
        }
        return null;
    }

    public String getDecodedPayload() {
        if (this.jweDecodedPayload != null) {
            return this.jweDecodedPayload;
        }
        String payload = this.getPayload();
        if (payload != null) {
            this.jweDecodedPayload = new String(Base64Utilities.decode(payload));
            return this.jweDecodedPayload;
        }
        return null;
    }

    public Map<String, String> getPayloadClaims() throws UtilsException {
        Map<String, String> m = null;
        if (this.token != null) {
            if (this.readClaimsPayload == null) {
                this.initReadClaimsPayload();
            }
            return this.readClaimsPayload;
        }
        return m;
    }

    public String getPayloadClaim(String claim) throws UtilsException {
        if (this.token != null) {
            if (this.readClaimsPayload == null) {
                this.initReadClaimsPayload();
            }
            if (this.readClaimsPayload != null) {
                return this.readClaimsPayload.get(claim);
            }
        }
        return null;
    }

    private synchronized void initReadClaimsHeader() throws UtilsException {
        if (this.readClaimsHeader == null) {
            this.readClaimsHeader = new HashMap<String, String>();
            String hdr = this.getDecodedHeader();
            JSONUtils jsonUtils = JSONUtils.getInstance();
            if (jsonUtils.isJson(hdr)) {
                JsonNode root = jsonUtils.getAsNode(hdr);
                Map<String, Serializable> readClaims = jsonUtils.convertToSimpleMap(root);
                this.initReadClaimsHeader(readClaims);
            }
        }
    }

    private void initReadClaimsHeader(Map<String, Serializable> readClaims) {
        if (readClaims != null && readClaims.size() > 0) {
            for (Map.Entry<String, Serializable> entry : readClaims.entrySet()) {
                String claim = entry.getKey();
                Serializable o = readClaims.get(claim);
                this.putClaimHeader(claim, o);
            }
        }
    }

    private void putClaimHeader(String claim, Serializable o) {
        String v;
        List<String> lClaimValues;
        if (o != null && (lClaimValues = JWTParser.getClaimValues(o)) != null && !lClaimValues.isEmpty() && (v = JWTParser.getClaimValuesAsString(lClaimValues)) != null) {
            this.readClaimsHeader.put(claim, v);
        }
    }

    private synchronized void initReadClaimsPayload() throws UtilsException {
        if (this.readClaimsPayload == null) {
            this.readClaimsPayload = new HashMap<String, String>();
            String payload = this.getDecodedPayload();
            JSONUtils jsonUtils = JSONUtils.getInstance();
            if (jsonUtils.isJson(payload)) {
                JsonNode root = jsonUtils.getAsNode(payload);
                Map<String, Serializable> readClaims = jsonUtils.convertToSimpleMap(root);
                this.initReadClaimsPayload(readClaims);
            }
        }
    }

    private void initReadClaimsPayload(Map<String, Serializable> readClaims) {
        if (readClaims != null && readClaims.size() > 0) {
            for (Map.Entry<String, Serializable> entry : readClaims.entrySet()) {
                String claim = entry.getKey();
                Serializable o = readClaims.get(claim);
                this.putClaimPayload(claim, o);
            }
        }
    }

    private void putClaimPayload(String claim, Serializable o) {
        String v;
        List<String> lClaimValues;
        if (o != null && (lClaimValues = JWTParser.getClaimValues(o)) != null && !lClaimValues.isEmpty() && (v = JWTParser.getClaimValuesAsString(lClaimValues)) != null) {
            this.readClaimsPayload.put(claim, v);
        }
    }

    public static List<String> getClaimValues(Object value) {
        List<String> lreturn = null;
        if (value != null) {
            if (value instanceof List) {
                List l = (List)value;
                List<String> lString = JWTParser.convertTo(l);
                if (lString != null) {
                    return lString;
                }
            } else {
                String sValue = value.toString();
                ArrayList<String> l = new ArrayList<String>();
                l.add(sValue);
                return l;
            }
        }
        return lreturn;
    }

    private static List<String> convertTo(List<?> l) {
        List<String> lreturn = null;
        if (!l.isEmpty()) {
            ArrayList<String> lString = new ArrayList<String>();
            for (Object o : l) {
                if (o == null) continue;
                lString.add(o.toString());
            }
            if (!lString.isEmpty()) {
                return lString;
            }
        }
        return lreturn;
    }

    private static String getClaimValuesAsString(List<String> claimValues) {
        String claimValue = null;
        if (claimValues == null || claimValues.isEmpty()) {
            return null;
        }
        if (claimValues.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (String c : claimValues) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(c);
            }
            claimValue = sb.toString();
        } else {
            claimValue = claimValues.get(0);
        }
        return claimValue;
    }
}

