/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.JWKSet;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.security.CertificateValidityCheck;
import org.openspcoop2.utils.security.JWTOptions;
import org.openspcoop2.utils.security.JsonUtils;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.transport.http.IOCSPValidator;

public class JsonDecrypt {
    private JweDecryptionProvider provider;
    private JWTOptions options;
    private Properties properties;
    private boolean dynamicProvider;
    private String decodedPayload;
    private byte[] decodedPayloadAsByte;
    private JsonWebKeys jsonWebKeys;
    private org.openspcoop2.utils.certificate.KeyStore keyStore;
    private Map<String, String> keystoreMapAliasPassword;
    private org.openspcoop2.utils.certificate.KeyStore trustStoreVerificaCertificatiX509;
    private org.openspcoop2.utils.certificate.KeyStore trustStoreHttps;
    private CertStore crlHttps;
    private IOCSPValidator ocspValidatorHttps;
    private CertStore crlX509;
    private IOCSPValidator ocspValidatorX509;
    private CertificateValidityCheck validityCheck = CertificateValidityCheck.ENABLED;
    private boolean jksPasswordRequired = true;
    private boolean pkcs12PasswordRequired = true;
    private X509Certificate x509Certificate;
    private RSAPublicKey rsaPublicKey;
    private String kid;

    public void setTrustStoreVerificaCertificatiX509(org.openspcoop2.utils.certificate.KeyStore trustStoreVerificaCertificatiX509) {
        this.trustStoreVerificaCertificatiX509 = trustStoreVerificaCertificatiX509;
    }

    public org.openspcoop2.utils.certificate.KeyStore getTrustStoreVerificaCertificatiX509() {
        return this.trustStoreVerificaCertificatiX509;
    }

    public org.openspcoop2.utils.certificate.KeyStore getTrustStoreHttps() {
        return this.trustStoreHttps;
    }

    public void setCrlHttps(CertStore crlHttps) {
        this.crlHttps = crlHttps;
    }

    public void setOcspValidatorHttps(IOCSPValidator ocspValidator) {
        this.ocspValidatorHttps = ocspValidator;
    }

    public void setCrlX509(CertStore crlX509) {
        this.crlX509 = crlX509;
    }

    public void setOcspValidatorX509(IOCSPValidator ocspValidator) {
        this.ocspValidatorX509 = ocspValidator;
    }

    public void setValidityCheck(CertificateValidityCheck validityCheck) {
        this.validityCheck = validityCheck;
    }

    public void setJksPasswordRequired(boolean jksPasswordRequired) {
        this.jksPasswordRequired = jksPasswordRequired;
    }

    public void setPkcs12PasswordRequired(boolean pkcs12PasswordRequired) {
        this.pkcs12PasswordRequired = pkcs12PasswordRequired;
    }

    public JsonDecrypt(Properties props, JWTOptions options) throws UtilsException {
        this(props, options, true, true);
    }

    public JsonDecrypt(Properties props, JWTOptions options, boolean jksPasswordRequired, boolean pkcs12PasswordRequired) throws UtilsException {
        try {
            this.jksPasswordRequired = jksPasswordRequired;
            this.pkcs12PasswordRequired = pkcs12PasswordRequired;
            this.dynamicProvider = JsonUtils.isDynamicProvider(props);
            if (this.dynamicProvider) {
                this.properties = props;
            } else {
                this.provider = this.loadProviderFromProperties(props, null);
            }
            this.options = options;
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), false, false, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JweDecryptionProvider loadProviderFromProperties(Properties props, ContentAlgorithm contentAlgorithm) throws UtilsException {
        File fTmp = null;
        try {
            fTmp = JsonUtils.normalizeProperties(props);
            JweDecryptionProvider providerBuild = this.buildProviderFromProperties(props, contentAlgorithm);
            try {
                Certificate cert = JsonUtils.getCertificateKey(this.jksPasswordRequired, this.pkcs12PasswordRequired, props);
                if (cert instanceof X509Certificate) {
                    this.x509Certificate = (X509Certificate)cert;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            JweDecryptionProvider jweDecryptionProvider = providerBuild;
            return jweDecryptionProvider;
        }
        finally {
            FileSystemUtilities.deleteFile(fTmp);
        }
    }

    private JweDecryptionProvider buildProviderFromProperties(Properties props, ContentAlgorithm contentAlgorithm) throws UtilsException {
        JweDecryptionProvider providerBuild = null;
        providerBuild = contentAlgorithm != null ? JsonUtils.getJweDecryptionProvider(props, contentAlgorithm) : JsonUtils.getJweDecryptionProvider(props);
        if (providerBuild == null) {
            providerBuild = this.buildProviderFromProperties(props);
        }
        if (providerBuild == null) {
            throw new UtilsException("JweDecryptionProvider provider not found");
        }
        return providerBuild;
    }

    private JweDecryptionProvider buildProviderFromProperties(Properties props) throws UtilsException {
        JweDecryptionProvider providerBuild;
        block4: {
            providerBuild = null;
            KeyAlgorithm keyAlgorithm = JweUtils.getKeyEncryptionAlgorithm((Properties)props, null);
            if (KeyAlgorithm.DIRECT.equals((Object)keyAlgorithm)) {
                providerBuild = JsonUtils.getJweDecryptionProviderFromJWKSymmetric(props, null);
            } else {
                try {
                    providerBuild = JweUtils.loadDecryptionProvider((Properties)props, (Message)JsonUtils.newMessage(), null);
                }
                catch (JweException jweExc) {
                    if (jweExc.getMessage() == null || !jweExc.getMessage().contains("NO_ENCRYPTOR") || (providerBuild = JsonUtils.getJweAsymmetricDecryptionProvider(props)) != null) break block4;
                    throw jweExc;
                }
            }
        }
        return providerBuild;
    }

    public JsonDecrypt(KeyStore keystore, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JWTOptions options) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), false, alias, passwordPrivateKey, keyAlgorithm, contentAlgorithm, options);
    }

    public JsonDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JWTOptions options) throws UtilsException {
        this(keystore, false, alias, passwordPrivateKey, keyAlgorithm, contentAlgorithm, options);
    }

    public JsonDecrypt(KeyStore keystore, boolean secretKey, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JWTOptions options) throws UtilsException {
        this(new org.openspcoop2.utils.certificate.KeyStore(keystore), secretKey, alias, passwordPrivateKey, keyAlgorithm, contentAlgorithm, options);
    }

    public JsonDecrypt(org.openspcoop2.utils.certificate.KeyStore keystore, boolean secretKey, String alias, String passwordPrivateKey, String keyAlgorithm, String contentAlgorithm, JWTOptions options) throws UtilsException {
        try {
            this.options = options;
            KeyAlgorithm keyAlgo = KeyAlgorithm.getAlgorithm((String)keyAlgorithm);
            ContentAlgorithm contentAlgo = ContentAlgorithm.getAlgorithm((String)contentAlgorithm);
            if (secretKey) {
                this.provider = KeyAlgorithm.DIRECT.equals((Object)keyAlgo) ? JweUtils.getDirectKeyJweDecryption((SecretKey)keystore.getSecretKey(alias, passwordPrivateKey), (ContentAlgorithm)contentAlgo) : JweUtils.createJweDecryptionProvider((SecretKey)keystore.getSecretKey(alias, passwordPrivateKey), (KeyAlgorithm)keyAlgo, (ContentAlgorithm)contentAlgo);
            } else {
                PrivateKey privateKey = keystore.getPrivateKey(alias, passwordPrivateKey);
                this.provider = JweUtils.createJweDecryptionProvider((PrivateKey)privateKey, (KeyAlgorithm)keyAlgo, (ContentAlgorithm)contentAlgo);
                this.checkKeyAlgorithm();
                if (this.provider == null) {
                    this.provider = JsonUtils.getJweAsymmetricDecryptionProvider(privateKey, keyAlgo, contentAlgo);
                    if (this.provider == null) {
                        throw new UtilsException("(" + keystore.getKeystore().getType() + ") JwsDecryptionProvider init failed; keyAlgorithm (" + keyAlgorithm + ") contentAlgorithm(" + contentAlgorithm + ")");
                    }
                }
            }
            this.setSafeCertificate(keystore, alias);
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), false, false, t);
        }
    }

    private void setSafeCertificate(org.openspcoop2.utils.certificate.KeyStore keystore, String alias) {
        try {
            Certificate cert = keystore.getCertificate(alias);
            if (cert instanceof X509Certificate) {
                this.x509Certificate = (X509Certificate)cert;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkKeyAlgorithm() {
        try {
            this.provider.getKeyAlgorithm();
        }
        catch (NullPointerException nullPointer) {
            this.provider = null;
        }
    }

    public JsonDecrypt(JsonWebKeys jsonWebKeys, boolean secretKey, String alias, String keyAlgorithm, String contentAlgorithm, JWTOptions options) throws UtilsException {
        this(JsonUtils.readKey(jsonWebKeys, alias), secretKey, keyAlgorithm, contentAlgorithm, options);
    }

    public JsonDecrypt(JsonWebKey jsonWebKey, boolean secretKey, String keyAlgorithm, String contentAlgorithm, JWTOptions options) throws UtilsException {
        try {
            this.options = options;
            KeyAlgorithm keyAlgo = KeyAlgorithm.getAlgorithm((String)keyAlgorithm);
            ContentAlgorithm contentAlgo = ContentAlgorithm.getAlgorithm((String)contentAlgorithm);
            if (secretKey) {
                if (jsonWebKey.getAlgorithm() == null) {
                    jsonWebKey.setAlgorithm(contentAlgorithm);
                }
                this.provider = KeyAlgorithm.DIRECT.equals((Object)keyAlgo) ? JweUtils.getDirectKeyJweDecryption((SecretKey)JwkUtils.toSecretKey((JsonWebKey)jsonWebKey), (ContentAlgorithm)contentAlgo) : JweUtils.createJweDecryptionProvider((SecretKey)JwkUtils.toSecretKey((JsonWebKey)jsonWebKey), (KeyAlgorithm)keyAlgo, (ContentAlgorithm)contentAlgo);
                if (this.provider == null) {
                    throw new UtilsException("(JsonWebKey) JwsDecryptionProvider init failed; check content algorithm (" + contentAlgorithm + ")");
                }
            } else {
                this.provider = JweUtils.createJweDecryptionProvider((PrivateKey)JwkUtils.toRSAPrivateKey((JsonWebKey)jsonWebKey), (KeyAlgorithm)keyAlgo, (ContentAlgorithm)contentAlgo);
            }
        }
        catch (Exception t) {
            throw JsonUtils.convert(options.getSerialization(), false, false, t);
        }
    }

    public JsonDecrypt(Properties propsTrustStoreHttps, KeyStore trustStoreVerificaCertificato, KeyStore keyStore, Map<String, String> keystoreMapAliasPassword, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(propsTrustStoreHttps, null, new org.openspcoop2.utils.certificate.KeyStore(trustStoreVerificaCertificato), new org.openspcoop2.utils.certificate.KeyStore(keyStore), keystoreMapAliasPassword, options);
    }

    public JsonDecrypt(org.openspcoop2.utils.certificate.KeyStore trustStoreHttps, KeyStore trustStoreVerificaCertificato, KeyStore keyStore, Map<String, String> keystoreMapAliasPassword, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(null, trustStoreHttps, new org.openspcoop2.utils.certificate.KeyStore(trustStoreVerificaCertificato), new org.openspcoop2.utils.certificate.KeyStore(keyStore), keystoreMapAliasPassword, options);
    }

    public JsonDecrypt(Properties propsTrustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStore, org.openspcoop2.utils.certificate.KeyStore keyStore, Map<String, String> keystoreMapAliasPassword, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(propsTrustStoreHttps, null, trustStore, keyStore, keystoreMapAliasPassword, options);
    }

    public JsonDecrypt(org.openspcoop2.utils.certificate.KeyStore trustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStore, org.openspcoop2.utils.certificate.KeyStore keyStore, Map<String, String> keystoreMapAliasPassword, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(null, trustStoreHttps, trustStore, keyStore, keystoreMapAliasPassword, options);
    }

    public JsonDecrypt(KeyStore trustStoreVerificaCertificato, KeyStore keyStore, Map<String, String> keystoreMapAliasPassword, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(null, null, new org.openspcoop2.utils.certificate.KeyStore(trustStoreVerificaCertificato), new org.openspcoop2.utils.certificate.KeyStore(keyStore), keystoreMapAliasPassword, options);
    }

    public JsonDecrypt(org.openspcoop2.utils.certificate.KeyStore trustStore, org.openspcoop2.utils.certificate.KeyStore keyStore, Map<String, String> keystoreMapAliasPassword, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(null, null, trustStore, keyStore, keystoreMapAliasPassword, options);
    }

    private void initDecryptHeaderJWTEngine(Properties propsTrustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStoreVerificaCertificato, org.openspcoop2.utils.certificate.KeyStore keyStore, Map<String, String> keystoreMapAliasPassword, JWTOptions options) {
        this.options = options;
        this.properties = propsTrustStoreHttps;
        this.trustStoreHttps = trustStoreHttps;
        this.trustStoreVerificaCertificatiX509 = trustStoreVerificaCertificato;
        this.keyStore = keyStore;
        this.keystoreMapAliasPassword = keystoreMapAliasPassword;
    }

    public JsonDecrypt(Properties propsTrustStoreHttps, JsonWebKeys jsonWebKeys, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(propsTrustStoreHttps, null, jsonWebKeys, options);
    }

    public JsonDecrypt(org.openspcoop2.utils.certificate.KeyStore trustStoreHttps, JsonWebKeys jsonWebKeys, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(null, trustStoreHttps, jsonWebKeys, options);
    }

    public JsonDecrypt(JsonWebKeys jsonWebKeys, JWTOptions options) {
        this.initDecryptHeaderJWTEngine(null, null, jsonWebKeys, options);
    }

    private void initDecryptHeaderJWTEngine(Properties propsTrustStoreHttps, org.openspcoop2.utils.certificate.KeyStore trustStoreHttps, JsonWebKeys jsonWebKeys, JWTOptions options) {
        this.options = options;
        this.properties = propsTrustStoreHttps;
        this.trustStoreHttps = trustStoreHttps;
        this.jsonWebKeys = jsonWebKeys;
    }

    public void decrypt(String jsonString) throws UtilsException {
        try {
            switch (this.options.getSerialization()) {
                case JSON: {
                    this.decryptJson(jsonString);
                    break;
                }
                case COMPACT: {
                    this.decryptCompact(jsonString);
                    break;
                }
                default: {
                    throw new UtilsException("Unsupported serialization '" + String.valueOf((Object)this.options.getSerialization()) + "'");
                }
            }
        }
        catch (Exception t) {
            throw JsonUtils.convert(this.options.getSerialization(), false, false, t);
        }
    }

    private void decryptCompact(String jsonString) throws UtilsException {
        JweCompactConsumer consumer = new JweCompactConsumer(jsonString);
        JweHeaders jweHeaders = consumer.getJweHeaders();
        JweDecryptionProvider providerBuild = this.getProvider(jweHeaders, null);
        JweDecryptionOutput output = providerBuild.decrypt(jsonString);
        this.decodedPayload = output.getContentText();
        this.decodedPayloadAsByte = output.getContent();
    }

    private void decryptJson(String jsonString) throws UtilsException {
        JweJsonConsumer consumer = new JweJsonConsumer(jsonString);
        JweHeaders jweHeaders = consumer.getProtectedHeader();
        JweHeaders jweUnprotectedHeaders = consumer.getSharedUnprotectedHeader();
        JweDecryptionProvider providerBuild = this.getProvider(jweHeaders, jweUnprotectedHeaders);
        JweDecryptionOutput output = consumer.decryptWith(providerBuild);
        this.decodedPayload = output.getContentText();
        this.decodedPayloadAsByte = output.getContent();
    }

    public String getDecodedPayload() {
        return this.decodedPayload;
    }

    public byte[] getDecodedPayloadAsByte() {
        return this.decodedPayloadAsByte;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public RSAPublicKey getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public String getKid() {
        return this.kid;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private JweDecryptionProvider getProvider(JweHeaders jweHeaders, JweHeaders jweUnprotectedHeaders) throws UtilsException {
        JweDecryptionProvider providerBuild = this.provider;
        if (jweHeaders == null) {
            return providerBuild;
        }
        if (this.dynamicProvider) {
            String alias = jweHeaders.getKeyId();
            Properties pNew = new Properties();
            pNew.putAll((Map<?, ?>)this.properties);
            pNew.put("rs.security.keystore.alias", alias);
            providerBuild = this.loadProviderFromProperties(pNew, jweHeaders.getContentEncryptionAlgorithm());
        }
        if (providerBuild == null) {
            KeyAlgorithm keyAlgo = jweHeaders.getKeyEncryptionAlgorithm();
            if (keyAlgo == null && jweUnprotectedHeaders != null) {
                keyAlgo = jweUnprotectedHeaders.getKeyEncryptionAlgorithm();
            }
            if (keyAlgo == null) {
                throw new UtilsException("KeyAlgorithm not found");
            }
            ContentAlgorithm contentAlgo = jweHeaders.getContentEncryptionAlgorithm();
            if (contentAlgo == null) {
                throw new UtilsException("ContentAlgorithm not found");
            }
            if (jweHeaders.getX509Chain() != null && !jweHeaders.getX509Chain().isEmpty() && this.options.isPermitUseHeaderX5C()) {
                try {
                    byte[] cer = Base64Utilities.decode((String)jweHeaders.getX509Chain().get(0));
                    CertificateInfo certificatoInfo = ArchiveLoader.load(cer).getCertificate();
                    if (this.trustStoreVerificaCertificatiX509 == null) return this.getProviderX509(certificatoInfo, keyAlgo, contentAlgo);
                    JsonUtils.validate(certificatoInfo, this.trustStoreVerificaCertificatiX509, this.crlX509, this.ocspValidatorX509, "x5c", true, this.validityCheck);
                    return this.getProviderX509(certificatoInfo, keyAlgo, contentAlgo);
                }
                catch (Exception e) {
                    throw new UtilsException("Process 'x5c' error: " + e.getMessage(), e);
                }
            }
            if (jweHeaders.getJsonWebKey() != null && this.options.isPermitUseHeaderJWK()) {
                try {
                    JsonWebKey webKey = jweHeaders.getJsonWebKey();
                    return this.getProviderJWK(webKey, keyAlgo, contentAlgo);
                }
                catch (Exception e) {
                    throw new UtilsException("Process 'jwk' error: " + e.getMessage(), e);
                }
            }
            if (jweHeaders.getX509Url() != null && this.options.isPermitUseHeaderX5U() || jweHeaders.getJsonWebKeysUrl() != null && this.options.isPermitUseHeaderJKU()) {
                boolean x509 = true;
                String path = jweHeaders.getX509Url();
                String hdr = "x5u";
                if (path == null) {
                    path = jweHeaders.getJsonWebKeysUrl();
                    x509 = false;
                    hdr = "jku";
                }
                try {
                    byte[] cer = null;
                    if (this.properties != null) {
                        this.properties.put("rs.security.keystore.file", path);
                        cer = JsonUtils.readKeystoreFromURI(this.properties);
                    } else {
                        HttpResponse httpResponse = null;
                        try {
                            httpResponse = this.trustStoreHttps != null ? HttpUtilities.getHTTPSResponse(path, this.trustStoreHttps.getKeystore(), this.crlHttps, this.ocspValidatorHttps) : HttpUtilities.getHTTPResponse(path);
                        }
                        catch (Exception e) {
                            throw new UtilsException("Resource '" + path + "' unavailable: " + e.getMessage(), e);
                        }
                        if (httpResponse == null) throw new UtilsException("Resource '" + path + "' unavailable");
                        if (httpResponse.getContent() == null) {
                            throw new UtilsException("Resource '" + path + "' unavailable");
                        }
                        if (httpResponse.getResultHTTPOperation() != 200) {
                            throw new UtilsException("Retrieve '" + path + "' failed (returnCode:" + httpResponse.getResultHTTPOperation() + ")");
                        }
                        cer = httpResponse.getContent();
                    }
                    if (cer == null) {
                        throw new UtilsException("Resource '" + path + "' unavailable");
                    }
                    if (x509) {
                        CertificateInfo certificatoInfo = ArchiveLoader.load(cer).getCertificate();
                        if (this.trustStoreVerificaCertificatiX509 == null) return this.getProviderX509(certificatoInfo, keyAlgo, contentAlgo);
                        JsonUtils.validate(certificatoInfo, this.trustStoreVerificaCertificatiX509, this.crlX509, this.ocspValidatorX509, "x5u", true, this.validityCheck);
                        return this.getProviderX509(certificatoInfo, keyAlgo, contentAlgo);
                    }
                    JWKSet set = new JWKSet(new String(cer));
                    JsonWebKeys jsonWebKeysBuild = set.getJsonWebKeys();
                    JsonWebKey jsonWebKey = null;
                    if (jsonWebKeysBuild.size() == 1) {
                        jsonWebKey = (JsonWebKey)jsonWebKeysBuild.getKeys().get(0);
                    } else {
                        if (jweHeaders.getKeyId() == null) {
                            throw new UtilsException("Kid non definito e JwkSet contiene pi\u00f9 di un certificato");
                        }
                        jsonWebKey = jsonWebKeysBuild.getKey(jweHeaders.getKeyId());
                    }
                    if (jsonWebKey != null) return this.getProviderJWK(jsonWebKey, keyAlgo, contentAlgo);
                    throw new UtilsException("JsonWebKey non trovata");
                }
                catch (Exception e) {
                    throw new UtilsException("Process '" + hdr + "' error: " + e.getMessage(), e);
                }
            }
            if (jweHeaders.getKeyId() != null && this.options.isPermitUseHeaderKID()) {
                try {
                    this.kid = jweHeaders.getKeyId();
                    if (this.jsonWebKeys != null) {
                        JsonWebKey jsonWebKey = null;
                        try {
                            jsonWebKey = this.jsonWebKeys.getKey(this.kid);
                        }
                        catch (Exception path) {
                            // empty catch block
                        }
                        if (jsonWebKey != null) {
                            providerBuild = this.getProviderJWK(jsonWebKey, keyAlgo, contentAlgo);
                        }
                    }
                    if (providerBuild != null) return providerBuild;
                    if (this.keyStore == null) return providerBuild;
                    if (!this.keyStore.existsAlias(this.kid)) return providerBuild;
                    Certificate cer = this.keyStore.getCertificate(this.kid);
                    if (!(cer instanceof X509Certificate)) return providerBuild;
                    X509Certificate x509CertificateBuild = (X509Certificate)cer;
                    if (this.trustStoreVerificaCertificatiX509 != null) {
                        JsonUtils.validate(new CertificateInfo(x509CertificateBuild, this.kid), this.trustStoreVerificaCertificatiX509, this.crlX509, this.ocspValidatorX509, "kid", false, this.validityCheck);
                    } else {
                        JsonUtils.validate(new CertificateInfo(x509CertificateBuild, this.kid), this.keyStore, this.crlX509, this.ocspValidatorX509, "kid", false, this.validityCheck);
                    }
                    CertificateInfo certificatoInfo = new CertificateInfo(x509CertificateBuild, this.kid);
                    return this.getProviderX509(certificatoInfo, keyAlgo, contentAlgo);
                }
                catch (Exception e) {
                    throw new UtilsException("Process 'kid' error: " + e.getMessage(), e);
                }
            }
            if (jweHeaders.getX509ThumbprintSHA256() != null && this.options.isPermitUseHeaderX5T_256() || jweHeaders.getX509Thumbprint() != null && this.options.isPermitUseHeaderX5T()) {
                String hdr = "x5t";
                if (jweHeaders.getX509ThumbprintSHA256() != null) {
                    hdr = "x5t#S256";
                }
                try {
                    if (this.keyStore == null) {
                        throw new UtilsException("KeyStore dei certificati non fornito");
                    }
                    Certificate cer = null;
                    cer = jweHeaders.getX509ThumbprintSHA256() != null ? this.keyStore.getCertificateByDigestSHA256UrlEncoded(jweHeaders.getX509ThumbprintSHA256()) : this.keyStore.getCertificateByDigestSHA1UrlEncoded(jweHeaders.getX509Thumbprint());
                    if (cer == null) {
                        throw new UtilsException("Certificato, corrispondente al digest indicato, non trovato nel KeyStore dei certificati");
                    }
                    if (!(cer instanceof X509Certificate)) throw new UtilsException("Certificato indicato non \u00e8 nel formato X.509");
                    X509Certificate x509CertificateBuild = (X509Certificate)cer;
                    if (this.trustStoreVerificaCertificatiX509 != null) {
                        JsonUtils.validate(new CertificateInfo(x509CertificateBuild, hdr), this.trustStoreVerificaCertificatiX509, this.crlX509, this.ocspValidatorX509, hdr, false, this.validityCheck);
                    } else {
                        JsonUtils.validate(new CertificateInfo(x509CertificateBuild, hdr), this.keyStore, this.crlX509, this.ocspValidatorX509, hdr, false, this.validityCheck);
                    }
                    CertificateInfo certificatoInfo = new CertificateInfo(x509CertificateBuild, "x5t");
                    return this.getProviderX509(certificatoInfo, keyAlgo, contentAlgo);
                }
                catch (Exception e) {
                    throw new UtilsException("Process '" + hdr + "' error: " + e.getMessage(), e);
                }
            }
            List<String> hdrNotPermitted = this.options.headersNotPermitted((JoseHeaders)jweHeaders);
            Object notPermitted = "";
            if (hdrNotPermitted == null) throw new UtilsException("Non \u00e8 stato trovato alcun header che consentisse di recuperare il certificato per decifrare" + (String)notPermitted);
            if (hdrNotPermitted.isEmpty()) throw new UtilsException("Non \u00e8 stato trovato alcun header che consentisse di recuperare il certificato per decifrare" + (String)notPermitted);
            notPermitted = "; header trovati ma non abilitati all'utilizzo: " + String.valueOf(hdrNotPermitted);
            throw new UtilsException("Non \u00e8 stato trovato alcun header che consentisse di recuperare il certificato per decifrare" + (String)notPermitted);
        }
        if (this.x509Certificate == null) return providerBuild;
        if (this.trustStoreVerificaCertificatiX509 == null) return providerBuild;
        try {
            CertificateInfo certificatoInfo = new CertificateInfo(this.x509Certificate, "x509");
            JsonUtils.validate(certificatoInfo, this.trustStoreVerificaCertificatiX509, this.crlX509, this.ocspValidatorX509, null, true, this.validityCheck);
            return providerBuild;
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }

    private JweDecryptionProvider getProviderX509(CertificateInfo certificatoInfo, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo) throws UtilsException {
        if (this.keyStore == null) {
            throw new UtilsException("Keystore da utilizzare per il recupero dei certificati non definito");
        }
        if (this.keystoreMapAliasPassword == null) {
            throw new UtilsException("Mappping alias-password non definito");
        }
        this.x509Certificate = certificatoInfo.getCertificate();
        PrivateKey privateKey = null;
        Enumeration<String> aliases = this.keyStore.aliases();
        while (aliases.hasMoreElements()) {
            X509Certificate x509CertificateCheck;
            String alias = aliases.nextElement();
            Certificate certificateCheck = this.keyStore.getCertificate(alias);
            if (!(certificateCheck instanceof X509Certificate) || !certificatoInfo.equals(x509CertificateCheck = (X509Certificate)certificateCheck, true)) continue;
            try {
                String passwordPrivateKey = this.keystoreMapAliasPassword.get(alias);
                if (passwordPrivateKey == null) {
                    throw new UtilsException("password non definita");
                }
                privateKey = this.keyStore.getPrivateKey(alias, passwordPrivateKey);
            }
            catch (Exception e) {
                throw new UtilsException("Chiave privata associato al certificato (alias: " + alias + ") non recuperabile: " + e.getMessage(), e);
            }
        }
        if (privateKey == null) {
            throw new UtilsException("Chiave privata associato al certificato (presente in header x5c) non recuperato");
        }
        JweDecryptionProvider providerBuild = JweUtils.createJweDecryptionProvider(privateKey, (KeyAlgorithm)keyAlgo, (ContentAlgorithm)contentAlgo);
        try {
            providerBuild.getKeyAlgorithm();
        }
        catch (NullPointerException nullPointer) {
            providerBuild = null;
        }
        if (providerBuild == null && (providerBuild = JsonUtils.getJweAsymmetricDecryptionProvider(privateKey, keyAlgo, contentAlgo)) == null) {
            throw new UtilsException("JwsDecryptionProvider init failed; keyAlgorithm (" + String.valueOf(keyAlgo) + ") contentAlgorithm(" + String.valueOf(contentAlgo) + ")");
        }
        return providerBuild;
    }

    private JweDecryptionProvider getProviderJWK(JsonWebKey webKey, KeyAlgorithm keyAlgo, ContentAlgorithm contentAlgo) throws UtilsException {
        String n = webKey.getStringProperty("n");
        if (n == null) {
            throw new UtilsException("JsonWebKey uncorrect? 'n' not found");
        }
        if (this.jsonWebKeys == null) {
            throw new UtilsException("JWKSet da utilizzare per il recupero dei certificati non definito");
        }
        this.rsaPublicKey = JwkUtils.toRSAPublicKey((JsonWebKey)webKey);
        List keys = this.jsonWebKeys.getKeys();
        if (keys == null || keys.isEmpty()) {
            throw new UtilsException("JWKSet da utilizzare per il recupero dei certificati vuoto");
        }
        JsonWebKey privateKey = null;
        for (JsonWebKey jsonWebKeyCheck : keys) {
            String nCheck = jsonWebKeyCheck.getStringProperty("n");
            if (nCheck == null || !nCheck.equals(n)) continue;
            privateKey = jsonWebKeyCheck;
            break;
        }
        return JweUtils.createJweDecryptionProvider((PrivateKey)JwkUtils.toRSAPrivateKey(privateKey), (KeyAlgorithm)keyAlgo, (ContentAlgorithm)contentAlgo);
    }
}

