/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.security;

import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import javax.crypto.SecretKey;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.security.AbstractXmlCipher;
import org.openspcoop2.utils.security.SymmetricKeyWrappedMode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlEncrypt
extends AbstractXmlCipher {
    public XmlEncrypt(KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey) throws UtilsException {
        super(1, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, false);
    }

    public XmlEncrypt(KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey) throws UtilsException {
        super(1, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, false);
    }

    public XmlEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, boolean symmetricKey, SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, symmetricKey, wrappedSymmetricKeyMode, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey, addBouncyCastleProvider);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, org.openspcoop2.utils.certificate.KeyStore keystore, String alias, String passwordPrivateKey) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, keystore, alias, passwordPrivateKey);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, SecretKey secretKey) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, secretKey);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, SecretKey secretKey, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, secretKey, addBouncyCastleProvider);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String keyAlgorithm, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, keyAlgorithm, addBouncyCastleProvider);
    }

    public XmlEncrypt(SymmetricKeyWrappedMode wrappedSymmetricKeyMode, String keyAlgorithm) throws UtilsException {
        super(1, wrappedSymmetricKeyMode, keyAlgorithm);
    }

    public XmlEncrypt(Certificate certificate, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, certificate, addBouncyCastleProvider);
    }

    public XmlEncrypt(Certificate certificate) throws UtilsException {
        super(1, certificate);
    }

    public XmlEncrypt(PrivateKey key, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key, addBouncyCastleProvider);
    }

    public XmlEncrypt(PrivateKey key) throws UtilsException {
        super(1, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key);
    }

    public XmlEncrypt(PublicKey key, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key, addBouncyCastleProvider);
    }

    public XmlEncrypt(PublicKey key) throws UtilsException {
        super(1, SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY, key);
    }

    public XmlEncrypt(KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, addBouncyCastleProvider);
    }

    public XmlEncrypt(KeyStore keystore) throws UtilsException {
        super(1, keystore);
    }

    public XmlEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, addBouncyCastleProvider);
    }

    public XmlEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore) throws UtilsException {
        super(1, keystore);
    }

    public XmlEncrypt(KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, alias, addBouncyCastleProvider);
    }

    public XmlEncrypt(KeyStore keystore, String alias) throws UtilsException {
        super(1, keystore, alias);
    }

    public XmlEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias, boolean addBouncyCastleProvider) throws UtilsException {
        super(1, keystore, alias, addBouncyCastleProvider);
    }

    public XmlEncrypt(org.openspcoop2.utils.certificate.KeyStore keystore, String alias) throws UtilsException {
        super(1, keystore, alias);
    }

    public Document encryptSymmetric(Document document, String encryptAlgorithm) throws UtilsException {
        return this.encrypt(document, document.getDocumentElement(), encryptAlgorithm, null, null, null, null);
    }

    public Document encryptSymmetric(Document document, String encryptAlgorithm, String canonicalizationMethod, String digestMethod) throws UtilsException {
        return this.encrypt(document, document.getDocumentElement(), encryptAlgorithm, canonicalizationMethod, digestMethod, null, null);
    }

    public Document encrypt(Document document, String encryptAlgorithm, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        return this.encrypt(document, document.getDocumentElement(), encryptAlgorithm, null, null, keyAlgorithm, wrappedKeyAlgorithm);
    }

    public Document encrypt(Document document, String encryptAlgorithm, String keyAlgorithm, String canonicalizationMethod, String digestMethod, String wrappedKeyAlgorithm) throws UtilsException {
        return this.encrypt(document, document.getDocumentElement(), encryptAlgorithm, canonicalizationMethod, digestMethod, keyAlgorithm, wrappedKeyAlgorithm);
    }

    public Document encryptSymmetric(Element element, String encryptAlgorithm) throws UtilsException {
        return this.encrypt(element.getOwnerDocument(), element, encryptAlgorithm, null, null, null, null);
    }

    public Document encryptSymmetric(Element element, String encryptAlgorithm, String canonicalizationMethod, String digestMethod) throws UtilsException {
        return this.encrypt(element.getOwnerDocument(), element, encryptAlgorithm, canonicalizationMethod, digestMethod, null, null);
    }

    public Document encrypt(Element element, String encryptAlgorithm, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        return this.encrypt(element.getOwnerDocument(), element, encryptAlgorithm, null, null, keyAlgorithm, wrappedKeyAlgorithm);
    }

    public Document encrypt(Element element, String encryptAlgorithm, String canonicalizationMethod, String digestMethod, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        return this.encrypt(element.getOwnerDocument(), element, encryptAlgorithm, canonicalizationMethod, digestMethod, keyAlgorithm, wrappedKeyAlgorithm);
    }

    public Document encryptSymmetric(Document document, Element element, String encryptAlgorithm) throws UtilsException {
        return this.encrypt(document, element, encryptAlgorithm, null, null, null, null);
    }

    public Document encryptSymmetric(Document document, Element element, String encryptAlgorithm, String canonicalizationMethod, String digestMethod) throws UtilsException {
        return this.encrypt(document, element, encryptAlgorithm, canonicalizationMethod, digestMethod, null, null);
    }

    public Document encrypt(Document document, Element element, String encryptAlgorithm, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        return this.encrypt(document, element, encryptAlgorithm, null, null, keyAlgorithm, wrappedKeyAlgorithm);
    }

    public Document encrypt(Document document, Element element, String encryptAlgorithm, String canonicalizationMethod, String digestMethod, String keyAlgorithm, String wrappedKeyAlgorithm) throws UtilsException {
        try {
            if (encryptAlgorithm == null) {
                throw new UtilsException("Encrypt Algorithm undefined");
            }
            EncryptedKey encryptedKey = null;
            if (super.isEncryptedKey()) {
                if (wrappedKeyAlgorithm == null) {
                    throw new UtilsException("WrappedKeyAlgorithm undefined");
                }
                XMLCipher xmlCipherWrappedAlgorithm = super.getXMLCipherWrappedKey(wrappedKeyAlgorithm);
                if (keyAlgorithm == null) {
                    throw new UtilsException("KeyAlgorithm undefined");
                }
                this.secretKeyEncrypt = XmlEncrypt.generateSecretKey(keyAlgorithm, this.provider);
                encryptedKey = xmlCipherWrappedAlgorithm.encryptKey(document, (Key)this.secretKeyEncrypt);
            }
            XMLCipher xmlCipher = super.getXMLCipher(encryptAlgorithm, canonicalizationMethod, digestMethod);
            if (encryptedKey != null) {
                EncryptedData encryptedData = xmlCipher.getEncryptedData();
                KeyInfo info = new KeyInfo(document);
                info.add(encryptedKey);
                encryptedData.setKeyInfo(info);
            }
            return xmlCipher.doFinal(document, element, true);
        }
        catch (Exception e) {
            throw new UtilsException(e.getMessage(), e);
        }
    }
}

