/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.semaphore.test;

import java.sql.Connection;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.id.serial.InfoStatistics;
import org.openspcoop2.utils.semaphore.Semaphore;
import org.openspcoop2.utils.semaphore.SemaphoreConfiguration;
import org.openspcoop2.utils.semaphore.SemaphoreMapping;
import org.openspcoop2.utils.semaphore.test.ClientTest;
import org.slf4j.Logger;

class ClientTestThread
implements Runnable {
    private Semaphore semaphore;
    private Connection con;
    private boolean lockAcquisito;
    private boolean lockRilasciato;
    private int lockAggiornamenti;
    private int index;
    private boolean debug;
    private boolean finished = false;
    private boolean error = false;

    public boolean isLockAcquisito() {
        return this.lockAcquisito;
    }

    public boolean isLockRilasciato() {
        return this.lockRilasciato;
    }

    public int getLockAggiornamenti() {
        return this.lockAggiornamenti;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public ClientTestThread(InfoStatistics infoStat, SemaphoreMapping mapping, SemaphoreConfiguration config, TipiDatabase tipoDatabase, Logger log, Connection con, int index, boolean debug) throws UtilsException {
        this.semaphore = new Semaphore(infoStat, mapping, config, tipoDatabase, log);
        this.con = con;
        this.lockAcquisito = false;
        this.lockRilasciato = false;
        this.lockAggiornamenti = 0;
        this.index = index;
        this.debug = debug;
    }

    @Override
    public void run() {
        try {
            boolean lock = false;
            for (int i = 0; i < ClientTest.CICLI_LOCK_PER_THREAD; ++i) {
                Utilities.sleep(50L);
                lock = this.semaphore.newLock(this.con, "[Thread-" + this.index + "] new lock (tentativo:" + i + ")...");
                if (lock) break;
            }
            if (!lock) {
                return;
            }
            this.lockAcquisito = true;
            for (int j = 0; j < 5; ++j) {
                Utilities.sleep(50L);
                lock = this.semaphore.updateLock(this.con, "[Thread-" + this.index + "] update lock iterazione-" + j + " ...");
                if (!lock) {
                    return;
                }
                ++this.lockAggiornamenti;
            }
            Utilities.sleep(50L);
            lock = this.semaphore.releaseLock(this.con, "[Thread-" + this.index + "] new lock...");
            if (!lock) {
                return;
            }
            this.lockRilasciato = true;
        }
        catch (Exception e) {
            this.error = true;
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            this.finished = true;
        }
    }
}

