/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.serialization;

import org.openspcoop2.utils.serialization.IDeserializer;
import org.openspcoop2.utils.serialization.IOException;
import org.openspcoop2.utils.serialization.ISerializer;
import org.openspcoop2.utils.serialization.JavaDeserializer;
import org.openspcoop2.utils.serialization.JavaSerializer;
import org.openspcoop2.utils.serialization.JsonJacksonDeserializer;
import org.openspcoop2.utils.serialization.JsonJacksonSerializer;
import org.openspcoop2.utils.serialization.SerializationConfig;

public class SerializationFactory {
    public static ISerializer getSerializer(SERIALIZATION_TYPE type, SerializationConfig config) throws IOException {
        switch (type.ordinal()) {
            case 0: {
                return new JavaSerializer();
            }
            case 1: {
                return new JsonJacksonSerializer(config);
            }
        }
        throw new IOException("SERIALIZATION_TYPE [" + String.valueOf((Object)type) + "] errato");
    }

    public static IDeserializer getDeserializer(SERIALIZATION_TYPE type, SerializationConfig config) throws IOException {
        switch (type.ordinal()) {
            case 0: {
                return new JavaDeserializer();
            }
            case 1: {
                return new JsonJacksonDeserializer(config);
            }
        }
        throw new IOException("SERIALIZATION_TYPE [" + String.valueOf((Object)type) + "] errato");
    }

    public static enum SERIALIZATION_TYPE {
        JAVA,
        JSON_JACKSON;

    }
}

