/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.authentication.entrypoint.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.openspcoop2.utils.jaxrs.JacksonJsonProviderCustomized;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

public abstract class AbstractBasicAuthenticationEntryPoint
extends BasicAuthenticationEntryPoint {
    private String realname = "GovWay";
    private TimeZone timeZone = TimeZone.getDefault();
    private String timeZoneId = null;

    public String getRealname() {
        return this.realname;
    }

    public void setRealname(String realname) {
        this.realname = realname;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
        this.timeZone = TimeZone.getTimeZone(timeZoneId);
    }

    public void fillResponse(AuthenticationException authException, HttpServletResponse httpResponse) {
        AbstractBasicAuthenticationEntryPoint.fillResponse(httpResponse, this.getPayload(authException, httpResponse), this.timeZone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillResponse(HttpServletResponse httpResponse, Response response, TimeZone timeZone) {
        ByteArrayInputStream bais = null;
        ServletOutputStream outputStream = null;
        try {
            httpResponse.setStatus(response.getStatus());
            MultivaluedMap headers = response.getHeaders();
            if (!headers.isEmpty()) {
                Set keySet = headers.keySet();
                for (String headerKey : keySet) {
                    List list = (List)headers.get((Object)headerKey);
                    if (list.isEmpty()) continue;
                    StringBuilder sb = new StringBuilder();
                    for (Object object : list) {
                        if (sb.length() > 0) {
                            sb.append(", ");
                        }
                        sb.append(object);
                    }
                    httpResponse.setHeader(headerKey, sb.toString());
                }
            }
            ObjectMapper mapper = JacksonJsonProviderCustomized.getObjectMapper(false, timeZone);
            String fault = mapper.writeValueAsString(response.getEntity());
            bais = new ByteArrayInputStream(fault.getBytes());
            outputStream = httpResponse.getOutputStream();
            IOUtils.copy((InputStream)bais, (OutputStream)outputStream);
            outputStream.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected abstract Response getPayload(AuthenticationException var1, HttpServletResponse var2);

    protected abstract void addCustomHeaders(HttpServletResponse var1);

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) {
        this.addCustomHeaders(response);
        this.fillResponse(authException, response);
    }

    public void afterPropertiesSet() {
        this.setRealmName(this.realname);
        super.afterPropertiesSet();
    }
}

