/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.authentication.filter;

import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.core.MultivaluedMap;
import org.openspcoop2.utils.io.Base64Utilities;

public class HTTPBasicAuthFilter
implements ClientRequestFilter {
    private final String user;
    private final String password;

    public HTTPBasicAuthFilter(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void filter(ClientRequestContext requestContext) {
        MultivaluedMap headers = requestContext.getHeaders();
        String basicAuthentication = this.getBasicAuthentication();
        headers.add((Object)"Authorization", (Object)basicAuthentication);
    }

    private String getBasicAuthentication() {
        String token = this.user + ":" + this.password;
        return "Basic " + Base64Utilities.encodeAsString(token.getBytes());
    }
}

