/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.context.dump;

import java.io.OutputStream;
import java.util.HashSet;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ext.logging.LoggingOutInterceptor;
import org.apache.cxf.ext.logging.event.DefaultLogEventMapper;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.service.context.dump.DumpConfig;
import org.openspcoop2.utils.service.context.dump.DumpInInterceptor;
import org.openspcoop2.utils.service.context.dump.DumpResponse;
import org.openspcoop2.utils.service.context.dump.DumpUtilities;
import org.openspcoop2.utils.service.context.server.ServerConfig;

@NoJSR250Annotations
public class DumpOutInterceptor
extends LoggingOutInterceptor {
    private DumpConfig dumpConfig;
    private ServerConfig serverConfig;

    public DumpConfig getDumpConfig() {
        return this.dumpConfig;
    }

    public void setDumpConfig(DumpConfig dumpConfig) {
        this.dumpConfig = dumpConfig;
        if (dumpConfig.getLimit() != null) {
            super.setLimit(dumpConfig.getLimit().intValue());
        } else {
            super.setLimit(-1);
        }
    }

    public ServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(ServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void handleMessage(Message message) throws Fault {
        try {
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            if (os != null) {
                LoggingCallback callback = new LoggingCallback(this.sender, message, os, this.limit, this.dumpConfig, this.serverConfig);
                message.setContent(OutputStream.class, (Object)this.internal_createCachingOut(message, os, callback));
            }
        }
        catch (Throwable e) {
            LoggerWrapperFactory.getLogger(DumpInInterceptor.class).error(e.getMessage(), e);
            throw new Fault(e);
        }
    }

    private OutputStream internal_createCachingOut(Message message, OutputStream os, CachedOutputStreamCallback callback) {
        CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
        if (this.threshold > 0L) {
            newOut.setThreshold(this.threshold);
        }
        if (this.limit > 0) {
            newOut.setCacheLimit((long)this.internal_getCacheLimit());
        }
        newOut.registerCallback(callback);
        return newOut;
    }

    private int internal_getCacheLimit() {
        if (this.limit == Integer.MAX_VALUE) {
            return this.limit;
        }
        return this.limit + 1;
    }

    public class LoggingCallback
    implements CachedOutputStreamCallback {
        private final Message message;
        private final OutputStream origStream;
        private final int lim;
        private LogEventSender sender;
        private DumpConfig dumpConfig;
        private ServerConfig serverConfig;

        public LoggingCallback(LogEventSender sender, Message msg, OutputStream os, int limit, DumpConfig dumpConfig, ServerConfig serverConfig) {
            this.sender = sender;
            this.message = msg;
            this.origStream = os;
            this.lim = limit == -1 ? Integer.MAX_VALUE : limit;
            this.dumpConfig = dumpConfig;
            this.serverConfig = serverConfig;
        }

        public void onFlush(CachedOutputStream cos) {
        }

        public void onClose(CachedOutputStream cos) {
            try {
                HashSet sensitiveProtocolHeaders = new HashSet();
                LogEvent event = new DefaultLogEventMapper().map(this.message, sensitiveProtocolHeaders);
                if (DumpOutInterceptor.this.shouldLogContent(event)) {
                    this.copyPayload(cos, event);
                } else {
                    event.setPayload("--- Content suppressed ---");
                }
                DumpUtilities utilities = null;
                if (this.serverConfig != null) {
                    this.serverConfig.setDumpConfig(this.dumpConfig);
                    utilities = new DumpUtilities(this.serverConfig);
                } else {
                    utilities = new DumpUtilities(this.dumpConfig);
                }
                DumpResponse response = new DumpResponse();
                if (event.getPayload() != null) {
                    response.setPayload(event.getPayload().getBytes());
                }
                response.setContentType(event.getContentType());
                try {
                    if (event.getResponseCode() != null) {
                        response.setResponseCode(Integer.parseInt(event.getResponseCode()));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                response.setHeaders(event.getHeaders());
                utilities.processAfterSend(response);
                try {
                    cos.lockOutputStream();
                    cos.resetOut(null, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.message.setContent(OutputStream.class, (Object)this.origStream);
            }
            catch (Throwable e) {
                LoggerWrapperFactory.getLogger(DumpInInterceptor.class).error(e.getMessage(), e);
                throw new Fault(e);
            }
        }

        private void copyPayload(CachedOutputStream cos, LogEvent event) {
            try {
                String encoding = (String)this.message.get((Object)Message.ENCODING);
                StringBuilder payload = new StringBuilder();
                this.writePayload(payload, cos, encoding, event.getContentType());
                event.setPayload(payload.toString());
                boolean isTruncated = cos.size() > (long)this.lim && this.lim != -1;
                event.setTruncated(isTruncated);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        protected void writePayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
            if (StringUtils.isEmpty((String)encoding)) {
                cos.writeCacheTo(builder, (long)this.lim);
            } else {
                cos.writeCacheTo(builder, encoding, (long)this.lim);
            }
        }
    }
}

