/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.service.fault.jaxrs;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.service.fault.jaxrs.FaultCode;
import org.openspcoop2.utils.service.fault.jaxrs.ITypeGenerator;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemRFC7807;
import org.openspcoop2.utils.service.fault.jaxrs.ProblemValidation;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class WebApplicationExceptionMapper
implements ExceptionMapper<WebApplicationException> {
    private Logger log = LoggerWrapperFactory.getLogger(WebApplicationExceptionMapper.class);
    private boolean excludeFaultBean;
    private boolean updateTitle = true;
    private ITypeGenerator typeGenerator;

    public boolean isExcludeFaultBean() {
        return this.excludeFaultBean;
    }

    public void setExcludeFaultBean(boolean excludeFaultBean) {
        this.excludeFaultBean = excludeFaultBean;
    }

    public boolean isUpdateTitle() {
        return this.updateTitle;
    }

    public void setUpdateTitle(boolean updateTitle) {
        this.updateTitle = updateTitle;
    }

    public ITypeGenerator getTypeGenerator() {
        return this.typeGenerator;
    }

    public void setTypeGenerator(ITypeGenerator typeGenerator) {
        this.typeGenerator = typeGenerator;
    }

    public Response toResponse(WebApplicationException e) {
        if (e.getResponse() == null || e.getResponse().getEntity() == null || !(e.getResponse().getEntity() instanceof ProblemRFC7807)) {
            this.log.error(e.getMessage(), (Throwable)e);
            ProblemRFC7807 problem = null;
            if (e.getCause() instanceof JsonMappingException) {
                JsonMappingException jsonMappingException = (JsonMappingException)e.getCause();
                problem = new ProblemValidation(FaultCode.RICHIESTA_NON_VALIDA.toFault());
                ((ProblemValidation)problem).addInvalidParam(jsonMappingException.getPathReference(), jsonMappingException.getMessage(), null);
            } else if (e.getCause() instanceof JsonParseException) {
                JsonParseException jsonParseException = (JsonParseException)e.getCause();
                problem = new ProblemValidation(FaultCode.RICHIESTA_NON_VALIDA.toFault());
                if (jsonParseException.getOriginalMessage() != null) {
                    ((ProblemValidation)problem).addInvalidParam("body", jsonParseException.getOriginalMessage(), null);
                } else {
                    ((ProblemValidation)problem).addInvalidParam("body", jsonParseException.getMessage(), null);
                }
                if (jsonParseException.getLocation() != null) {
                    StringBuilder bf = new StringBuilder();
                    bf.append("line: ").append(jsonParseException.getLocation().getLineNr()).append(", column: ").append(jsonParseException.getLocation().getColumnNr());
                    ((ProblemValidation)problem).addInvalidParam("position", bf.toString(), null);
                }
            } else {
                problem = FaultCode.RICHIESTA_NON_VALIDA.toFault();
            }
            this.updateProblem(problem, e);
            this._setType(problem, e);
            if (this.updateTitle) {
                problem.setTitle(HttpUtilities.getHttpReason(problem.getStatus()));
            }
            return Response.status((int)problem.getStatus()).entity((Object)problem).type("application/problem+json").build();
        }
        if (this.excludeFaultBean) {
            MultivaluedMap map;
            Response.ResponseBuilder responseBuilder = Response.status((int)e.getResponse().getStatus());
            if (e.getResponse().getHeaders() != null && !(map = e.getResponse().getHeaders()).isEmpty()) {
                map.keySet().stream().forEach(k -> responseBuilder.header(k, map.get(k)));
            }
            return responseBuilder.build();
        }
        ProblemRFC7807 problem = this._getProblem(e);
        if (problem != null) {
            this.updateProblem(problem, e);
            this._setType(problem, e);
            if (this.updateTitle) {
                problem.setTitle(HttpUtilities.getHttpReason(problem.getStatus()));
            }
        }
        return e.getResponse();
    }

    private ProblemRFC7807 _getProblem(WebApplicationException e) {
        if (e == null || e.getResponse() == null || e.getResponse().getEntity() == null) {
            return null;
        }
        if (!(e.getResponse().getEntity() instanceof ProblemRFC7807)) {
            return null;
        }
        ProblemRFC7807 problem = (ProblemRFC7807)e.getResponse().getEntity();
        return problem;
    }

    private void _setType(ProblemRFC7807 problem, WebApplicationException e) {
        if (this.typeGenerator == null) {
            return;
        }
        problem.setType(this.typeGenerator.getType(problem.getStatus(), (Exception)e));
    }

    public void updateProblem(ProblemRFC7807 problem, WebApplicationException e) {
    }
}

