/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sonde;

import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.openspcoop2.utils.io.Base64Utilities;

public class ParametriSonda {
    private String nome;
    private long sogliaWarn;
    private long sogliaError;
    private Date dataOk;
    private Date dataWarn;
    private Date dataError;
    private Date dataUltimoCheck;
    private Properties datiCheck;
    private Set<String> reserved = new HashSet<String>();
    private int statoUltimoCheck;
    private static final String SEPARATOR = ":";
    private static final String CUSTOM = "CUSTOM##";

    public void unmarshallDatiCheck(String datiCheck) {
        this.datiCheck = new Properties();
        if (datiCheck != null) {
            String[] datiList;
            for (String dato : datiList = datiCheck.split("\\\n")) {
                if (dato.startsWith(CUSTOM)) {
                    String datoReale = dato.substring(CUSTOM.length());
                    String[] nameValue = datoReale.split(SEPARATOR);
                    if (nameValue.length != 2) {
                        System.err.println("Dato Check [" + datoReale + "] non nel formato valido nome:valore");
                        continue;
                    }
                    try {
                        String key = nameValue[0].trim();
                        String value = nameValue[1].trim();
                        byte[] decodedKey = Base64Utilities.decode(key);
                        byte[] decodedValue = Base64Utilities.decode(value);
                        this.datiCheck.put(new String(decodedKey), new String(decodedValue));
                    }
                    catch (Throwable t) {
                        System.err.println("Errore durante il decoding del parametro [" + datoReale + "]: " + t.getMessage());
                    }
                    continue;
                }
                String[] nameValue = dato.split(SEPARATOR);
                if (nameValue.length != 2) {
                    System.err.println("Dato Check [" + dato + "] non nel formato valido nome:valore");
                    continue;
                }
                this.datiCheck.put(nameValue[0].trim(), nameValue[1].trim());
            }
        }
    }

    public String marshallDatiCheck() {
        if (this.datiCheck != null) {
            StringBuilder sb = new StringBuilder();
            for (Object key : this.datiCheck.keySet()) {
                boolean contains = this.reserved.contains(key);
                if (contains) {
                    sb.append(key).append(SEPARATOR).append(this.datiCheck.get(key)).append("\n");
                    continue;
                }
                String keyEncoded = Base64Utilities.encodeAsString(key.toString().getBytes());
                String valueEncoded = Base64Utilities.encodeAsString(this.datiCheck.get(key).toString().getBytes());
                sb.append(CUSTOM).append(keyEncoded).append(SEPARATOR).append(valueEncoded).append("\n");
            }
            return sb.toString();
        }
        return null;
    }

    public void putAllCheck(Properties checks) {
        if (checks != null) {
            for (Object key : checks.keySet()) {
                if (this.reserved.contains(key)) continue;
                this.datiCheck.put(key, checks.get(key));
            }
        }
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public long getSogliaWarn() {
        return this.sogliaWarn;
    }

    public void setSogliaWarn(long sogliaWarn) {
        this.sogliaWarn = sogliaWarn;
    }

    public long getSogliaError() {
        return this.sogliaError;
    }

    public void setSogliaError(long sogliaError) {
        this.sogliaError = sogliaError;
    }

    public Date getDataOk() {
        return this.dataOk;
    }

    public void setDataOk(Date dataOk) {
        this.dataOk = dataOk;
    }

    public Date getDataWarn() {
        return this.dataWarn;
    }

    public void setDataWarn(Date dataWarn) {
        this.dataWarn = dataWarn;
    }

    public Date getDataError() {
        return this.dataError;
    }

    public void setDataError(Date dataError) {
        this.dataError = dataError;
    }

    public Date getDataUltimoCheck() {
        return this.dataUltimoCheck;
    }

    public void setDataUltimoCheck(Date dataUltimoCheck) {
        this.dataUltimoCheck = dataUltimoCheck;
    }

    public Properties getDatiCheck() {
        return this.datiCheck;
    }

    public void setDatiCheck(Properties datiCheck) {
        this.datiCheck = datiCheck;
    }

    public int getStatoUltimoCheck() {
        return this.statoUltimoCheck;
    }

    public void setStatoUltimoCheck(int statoUltimoCheck) {
        this.statoUltimoCheck = statoUltimoCheck;
    }

    public Set<String> getReserved() {
        return this.reserved;
    }

    public void setReserved(Set<String> reserved) {
        this.reserved = reserved;
    }
}

