/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sonde.impl;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sonde.ParametriSonda;
import org.openspcoop2.utils.sonde.Sonda;
import org.openspcoop2.utils.sonde.SondaException;

public class SondaCoda
extends Sonda {
    public SondaCoda(ParametriSonda param) {
        super(param);
        HashSet<String> reserved = new HashSet<String>();
        reserved.add("dimensione_coda");
        this.getParam().setReserved(reserved);
    }

    @Override
    public Sonda.StatoSonda getStatoSonda() {
        long dimensione_coda = 0L;
        String dimensioneCodaString = super.getParam().getDatiCheck().getProperty("dimensione_coda");
        try {
            if (dimensioneCodaString != null) {
                dimensione_coda = Long.parseLong(dimensioneCodaString);
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace(System.err);
            System.err.println("Errore durante il parsing del parametro dimensione_coda: " + dimensioneCodaString + ". Elimino il valore");
            super.getParam().getDatiCheck().remove("dimensione_coda");
        }
        Sonda.StatoSonda statoSonda = new Sonda.StatoSonda(this);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.sss");
        if (dimensione_coda > super.getParam().getSogliaError()) {
            if (this.getParam().getDataError() == null) {
                this.getParam().setDataError(new Date());
            }
            statoSonda.setStato(2);
            statoSonda.setDescrizione("La coda " + super.getParam().getNome() + " ha superato la soglia di errore (" + super.getParam().getSogliaError() + ") dal " + format.format(this.getParam().getDataError()) + ". Dimensione attuale della coda: " + dimensione_coda + ".");
        } else if (dimensione_coda > super.getParam().getSogliaWarn()) {
            if (this.getParam().getDataWarn() == null) {
                this.getParam().setDataWarn(new Date());
            }
            statoSonda.setStato(1);
            statoSonda.setDescrizione("La coda " + super.getParam().getNome() + " ha superato la soglia di warn (" + super.getParam().getSogliaWarn() + ") dal " + format.format(this.getParam().getDataWarn()) + ". Dimensione attuale della coda: " + dimensione_coda + ".");
        } else {
            statoSonda.setStato(0);
            statoSonda.setDescrizione("Coda " + super.getParam().getNome() + ": numero elementi in coda: " + dimensione_coda);
        }
        return statoSonda;
    }

    public Sonda.StatoSonda aggiornaStatoSonda(long dimensioneCoda, Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        return this.aggiornaStatoSonda(dimensioneCoda, null, connection, tipoDatabase);
    }

    public Sonda.StatoSonda aggiornaStatoSonda(long dimensioneCoda, Properties params, Connection connection, TipiDatabase tipoDatabase) throws SondaException {
        super.getParam().putAllCheck(params);
        super.getParam().getDatiCheck().put("dimensione_coda", "" + dimensioneCoda);
        return this.updateSonda(connection, tipoDatabase);
    }
}

