/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.sql;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.utils.TipiDatabase;

public class JavaxPersistenceSqlGenerator {
    private JavaxPersistenceSqlGenerator() {
    }

    public static void generate(String persistenceId, String folder) throws IOException {
        TipiDatabase[] values;
        for (TipiDatabase tipoDatabase : values = new TipiDatabase[]{TipiDatabase.POSTGRESQL, TipiDatabase.MYSQL, TipiDatabase.ORACLE, TipiDatabase.DERBY}) {
            JavaxPersistenceSqlGenerator.generate(persistenceId, folder, tipoDatabase);
        }
    }

    private static void generate(String persistenceId, String folder, TipiDatabase tipoDatabase) throws IOException {
        String create = folder + tipoDatabase.toString().toLowerCase() + "/" + persistenceId + ".sql";
        String drop = folder + tipoDatabase.toString().toLowerCase() + "/" + persistenceId + "_drop.sql";
        Files.deleteIfExists(Paths.get(create, new String[0]));
        Files.deleteIfExists(Paths.get(drop, new String[0]));
        Map<String, String> map = JavaxPersistenceSqlGenerator.getMap(persistenceId, create, drop, tipoDatabase);
        try {
            Class<?> cPersistence = Class.forName("javax.persistence.Persistence");
            Method m = cPersistence.getMethod("generateSchema", persistenceId.getClass(), Map.class);
            m.invoke(null, persistenceId, map);
        }
        catch (Exception t) {
            throw new IOException(t);
        }
    }

    private static Map<String, String> getMap(String persistenceId, String create, String drop, TipiDatabase tipoDatabase) {
        if (persistenceId != null) {
            // empty if block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("javax.persistence.schema-generation.scripts.action", "drop-and-create");
        map.put("javax.persistence.schema-generation.scripts.create-target", create);
        map.put("javax.persistence.schema-generation.scripts.drop-target", drop);
        map.put("hibernate.hbm2ddl.delimiter", ";");
        map.put("hibernate.format_sql", "true");
        String productName = "javax.persistence.database-product-name";
        String dialect = "hibernate.dialect";
        switch (tipoDatabase) {
            case DERBY: {
                map.put(productName, "Derby");
                map.put(dialect, "org.hibernate.dialect.DerbyTenSevenDialect");
                break;
            }
            case MYSQL: {
                map.put(productName, "Mysql");
                map.put(dialect, "org.hibernate.dialect.MySQL5InnoDBDialect");
                break;
            }
            case ORACLE: {
                map.put(productName, "Oracle");
                map.put(dialect, "org.hibernate.dialect.Oracle10gDialect");
                break;
            }
            case POSTGRESQL: {
                map.put(productName, "Postgresql");
                map.put(dialect, "org.hibernate.dialect.PostgreSQLDialect");
                map.put("javax.persistence.database-major-version", "9");
                map.put("javax.persistence.database-minor-version", "1");
                break;
            }
        }
        return map;
    }
}

