/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.threads;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.threads.IGestoreRunnableInstance;
import org.openspcoop2.utils.threads.Runnable;
import org.openspcoop2.utils.threads.RunnableLogger;
import org.slf4j.Logger;

public class GestoreRunnable
extends Thread {
    private RunnableLogger log = null;
    private ExecutorService threadsPool = null;
    private int poolSize = -1;
    private List<Runnable> threads = new ArrayList<Runnable>();
    private IGestoreRunnableInstance gestoreRunnable;
    private String name;
    private boolean stop = false;

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }

    public String getThreadsImage() {
        if (this.threadsPool instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)this.threadsPool;
            return String.format("[monitor] [%d/%d] Active: %d, Completed: %d, Task: %d, isShutdown: %s, isTerminated: %s", tpe.getPoolSize(), tpe.getCorePoolSize(), tpe.getActiveCount(), tpe.getCompletedTaskCount(), tpe.getTaskCount(), tpe.isShutdown(), tpe.isTerminated());
        }
        return null;
    }

    public GestoreRunnable(String name, int poolSize, IGestoreRunnableInstance gestoreRunnable, Logger log) throws UtilsException {
        this.name = name;
        this.log = new RunnableLogger(name, log);
        this.gestoreRunnable = gestoreRunnable;
        try {
            if (this.gestoreRunnable != null) {
                this.gestoreRunnable.initialize(this.log);
            }
        }
        catch (Throwable t) {
            throw new UtilsException(t.getMessage(), t);
        }
        try {
            this.poolSize = poolSize;
            if (this.poolSize > 0) {
                this.threadsPool = Executors.newFixedThreadPool(this.poolSize);
                this.log.info("Inizializzato correttamente");
            } else {
                this.log.info("Non sono stati definiti threads");
            }
        }
        catch (Exception e) {
            throw new UtilsException("Inizializzazione pool di threads non riuscita: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int i;
        if (this.threadsPool == null) {
            return;
        }
        try {
            for (i = 0; i < this.poolSize; ++i) {
                String threadName = this.name + "-t" + (i + 1);
                Runnable thread = this.gestoreRunnable.newRunnable(new RunnableLogger(threadName, this.log.getLog()));
                this.log.debug("Avvio thread " + threadName + " ...");
                this.threadsPool.execute(thread);
                this.threads.add(thread);
                this.log.debug("Avviato thread " + threadName);
            }
        }
        catch (Throwable t) {
            this.log.error("Errore durante l'avvio dei threads: " + t.getMessage(), t);
        }
        while (!this.stop) {
            Utilities.sleep(1000L);
        }
        try {
            this.log.debug("Richiedo sospensione threads ...");
            for (i = 0; i < this.poolSize; ++i) {
                this.threads.get(i).setStop(true);
            }
        }
        catch (Throwable t) {
            this.log.error("Errore durante lo stop dei threads: " + t.getMessage(), t);
        }
        try {
            int timeout = 10;
            boolean terminated = false;
            while (!terminated) {
                this.log.info(this.poolSize + " threads avviati correttamente, attendo terminazione (timeout " + timeout + "s) ...");
                for (int i2 = 0; i2 < timeout * 4; ++i2) {
                    boolean tmpTerminated = true;
                    for (Runnable processorThread : this.threads) {
                        if (processorThread.isFinished()) continue;
                        tmpTerminated = false;
                        break;
                    }
                    if (!tmpTerminated) {
                        Utilities.sleep(250L);
                        continue;
                    }
                    terminated = true;
                }
            }
        }
        catch (Exception e) {
            this.log.error("Errore durante l'attesa della terminazione dei threads: " + e.getMessage(), e);
        }
    }
}

