/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.threads;

import org.slf4j.Logger;

public class RunnableLogger {
    private Logger log = null;
    private String threadName;
    private String prefix = null;

    public RunnableLogger(String threadName, Logger log) {
        this.log = log;
        this.threadName = threadName;
        this.prefix = "[" + this.threadName + "] ";
    }

    public Logger getLog() {
        return this.log;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void warn(String message, Throwable t) {
        this.log.warn(this.prefix + message, t);
    }

    public void warn(String message) {
        this.log.warn(this.prefix + message);
    }

    public void error(String message, Throwable t) {
        this.log.error(this.prefix + message, t);
    }

    public void error(String message) {
        this.log.error(this.prefix + message);
    }

    public void info(String message, Throwable t) {
        this.log.info(this.prefix + message, t);
    }

    public void info(String message) {
        this.log.info(this.prefix + message);
    }

    public void debug(String message, Throwable t) {
        this.log.debug(this.prefix + message, t);
    }

    public void debug(String message) {
        this.log.debug(this.prefix + message);
    }

    public void trace(String message, Throwable t) {
        this.log.trace(this.prefix + message, t);
    }

    public void trace(String message) {
        this.log.trace(this.prefix + message);
    }
}

