/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.transport.TransportUtils;
import org.slf4j.Logger;

public class TransportResponseContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Map<String, List<String>> headers;
    protected String codiceTrasporto = null;
    protected long contentLength = -1L;
    protected String errore = null;
    protected Exception exception = null;
    protected Logger log = null;

    public TransportResponseContext() throws UtilsException {
        this(null);
    }

    public TransportResponseContext(Logger log) throws UtilsException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(TransportResponseContext.class) : log;
    }

    @Deprecated
    public TransportResponseContext(Map<String, String> parametersTrasporto, String codiceTrasporto, long contentLength, String errore, Exception exception) throws UtilsException {
        this(null, codiceTrasporto, TransportUtils.convertToMapListValues(parametersTrasporto), contentLength, errore, exception);
    }

    @Deprecated
    public TransportResponseContext(Logger log, Map<String, String> parametersTrasporto, String codiceTrasporto, long contentLength, String errore, Exception exception) throws UtilsException {
        this(log, codiceTrasporto, TransportUtils.convertToMapListValues(parametersTrasporto), contentLength, errore, exception);
    }

    @Deprecated
    public TransportResponseContext(String codiceTrasporto, Map<String, List<String>> headers, long contentLength, String errore, Exception exception) throws UtilsException {
        this(null, codiceTrasporto, headers, contentLength, errore, exception);
    }

    public TransportResponseContext(Logger log, String codiceTrasporto, Map<String, List<String>> headers, long contentLength, String errore, Exception exception) throws UtilsException {
        this.log = log == null ? LoggerWrapperFactory.getLogger(TransportResponseContext.class) : log;
        this.headers = headers;
        this.codiceTrasporto = codiceTrasporto;
        this.contentLength = contentLength;
        this.errore = errore;
        this.exception = exception;
    }

    public String getCodiceTrasporto() {
        return this.codiceTrasporto;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public String getErrore() {
        return this.errore;
    }

    @Deprecated
    public Map<String, String> getParametersTrasporto() {
        return TransportUtils.convertToMapSingleValue(this.headers);
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Deprecated
    public String getParameterTrasporto(String name) {
        if (this.headers == null) {
            return null;
        }
        return TransportUtils.getObjectAsString(this.headers, name);
    }

    public String getHeader_compactMultipleValues(String name) {
        if (this.headers == null) {
            return null;
        }
        return TransportUtils.getObjectAsString(this.headers, name);
    }

    public String getHeaderFirstValue(String name) {
        List<String> l = this.getHeaderValues(name);
        if (l != null && !l.isEmpty()) {
            return l.get(0);
        }
        return null;
    }

    public List<String> getHeaderValues(String name) {
        if (this.headers == null) {
            return null;
        }
        return TransportUtils.getRawObject(this.headers, name);
    }

    @Deprecated
    public Object removeParameterTrasporto(String name) {
        if (this.headers == null) {
            return null;
        }
        return TransportUtils.removeObjectAsString(this.headers, name);
    }

    public String removeHeader_compactMultipleValues(String name) {
        if (this.headers == null) {
            return null;
        }
        return TransportUtils.removeObjectAsString(this.headers, name);
    }

    public List<String> removeHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return TransportUtils.removeRawObject(this.headers, name);
    }

    public String getContentType() {
        if (this.headers != null) {
            return this.getHeaderFirstValue("Content-Type");
        }
        return null;
    }

    public void setCodiceTrasporto(String codiceTrasporto) {
        this.codiceTrasporto = codiceTrasporto;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setErrore(String errore) {
        this.errore = errore;
    }

    @Deprecated
    public void setParametersTrasporto(Map<String, String> parametersTrasporto) {
        this.headers = TransportUtils.convertToMapListValues(parametersTrasporto);
    }

    public void setHeaders(Map<String, List<String>> parametersFormBased) {
        this.headers = parametersFormBased;
    }
}

