/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.utils.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.openspcoop2.utils.Utilities;

public class ChunkedInputStream
extends InputStream {
    private final InputStream is;
    private final int chunkedSize;
    private final int chunkedSleepMs;
    private int counter;

    public ChunkedInputStream(InputStream is, Integer chunkedSize, Integer chunkedSleepMs) {
        this.is = is;
        this.chunkedSize = Objects.requireNonNullElse(chunkedSize, -1);
        this.chunkedSleepMs = Objects.requireNonNullElse(chunkedSleepMs, 0);
        this.counter = 0;
    }

    private void trySleep() {
        if (this.chunkedSize > 0 && this.counter == this.chunkedSize) {
            Utilities.sleep(this.chunkedSleepMs);
        }
        this.counter %= this.chunkedSize;
    }

    @Override
    public int read() throws IOException {
        this.trySleep();
        ++this.counter;
        return this.is.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        this.trySleep();
        int readLength = Math.min(len, this.chunkedSize - this.counter);
        readLength = this.is.read(buf, off, readLength);
        this.counter += readLength;
        return readLength;
    }
}

